/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.modules.maven.nodes.AddDependencyPanel;
import org.netbeans.modules.maven.nodes.DependencyNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public class DependenciesNode
extends AbstractNode {
    static final int TYPE_COMPILE = 0;
    static final int TYPE_TEST = 1;
    static final int TYPE_RUNTIME = 2;
    private static final String SHOW_NONCLASSPATH_DEPENDENCIES = "show.nonclasspath.dependencies";
    private static final String SHOW_MANAGED_DEPENDENCIES = "show.managed.dependencies";
    public static final String PREF_DEPENDENCIES_UI = "org/netbeans/modules/maven/dependencies/ui";
    private NbMavenProjectImpl project;
    private int type;
    private static final DependencyWrapper NULL = new DependencyWrapper(null, null);
    private static final String ICON_KEY_UIMANAGER = "Tree.closedIcon";
    private static final String OPENED_ICON_KEY_UIMANAGER = "Tree.openIcon";
    private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";
    private static final String OPENED_ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.openedIcon";
    private static final String ICON_PATH = "org/netbeans/modules/maven/defaultFolder.gif";
    private static final String OPENED_ICON_PATH = "org/netbeans/modules/maven/defaultFolderOpen.gif";

    DependenciesNode(DependenciesChildren childs, NbMavenProjectImpl mavproject, int type) {
        super((Children)childs, Lookups.fixed((Object[])new Object[]{mavproject}));
        this.setName("Dependencies" + type);
        this.type = type;
        switch (type) {
            case 0: {
                this.setDisplayName(NbBundle.getMessage(DependenciesNode.class, (String)"LBL_Libraries"));
                break;
            }
            case 1: {
                this.setDisplayName(NbBundle.getMessage(DependenciesNode.class, (String)"LBL_Test_Libraries"));
                break;
            }
            case 2: {
                this.setDisplayName(NbBundle.getMessage(DependenciesNode.class, (String)"LBL_Runtime_Libraries"));
                break;
            }
            default: {
                this.setDisplayName(NbBundle.getMessage(DependenciesNode.class, (String)"LBL_Libraries"));
            }
        }
        this.project = mavproject;
        this.setIconBaseWithExtension(ICON_PATH);
    }

    public Image getIcon(int param) {
        Image retValue = ImageUtilities.mergeImages((Image)DependenciesNode.getTreeFolderIcon(false), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/libraries-badge.png"), (int)8, (int)8);
        return retValue;
    }

    public Image getOpenedIcon(int param) {
        Image retValue = ImageUtilities.mergeImages((Image)DependenciesNode.getTreeFolderIcon(true), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/libraries-badge.png"), (int)8, (int)8);
        return retValue;
    }

    public Action[] getActions(boolean context) {
        ArrayList<AbstractAction> toRet = new ArrayList<AbstractAction>();
        toRet.add(new AddDependencyAction());
        toRet.add(null);
        toRet.add(new ResolveDepsAction(this.project));
        toRet.add(new DownloadJavadocSrcAction(true));
        toRet.add(new DownloadJavadocSrcAction(false));
        toRet.addAll(Utilities.actionsForPath((String)"Projects/org-netbeans-modules-maven/DependenciesActions"));
        toRet.add(null);
        toRet.add(new ShowClasspathDepsAction());
        toRet.add(new ShowManagedStateAction());
        return toRet.toArray(new Action[toRet.size()]);
    }

    private static boolean showNonClasspath() {
        Preferences prefs = NbPreferences.root().node(PREF_DEPENDENCIES_UI);
        boolean b = prefs.getBoolean(SHOW_NONCLASSPATH_DEPENDENCIES, false);
        return b;
    }

    static boolean showManagedState() {
        Preferences prefs = NbPreferences.root().node(PREF_DEPENDENCIES_UI);
        boolean b = prefs.getBoolean(SHOW_MANAGED_DEPENDENCIES, false);
        return b;
    }

    public static Image getTreeFolderIcon(boolean opened) {
        Image base = null;
        Icon baseIcon = UIManager.getIcon(opened ? OPENED_ICON_KEY_UIMANAGER : ICON_KEY_UIMANAGER);
        if (baseIcon != null) {
            base = ImageUtilities.icon2Image((Icon)baseIcon);
        } else {
            base = (Image)UIManager.get(opened ? OPENED_ICON_KEY_UIMANAGER_NB : ICON_KEY_UIMANAGER_NB);
            if (base == null) {
                base = ImageUtilities.loadImage((String)(opened ? OPENED_ICON_PATH : ICON_PATH), (boolean)true);
            }
        }
        assert (base != null);
        return base;
    }

    private static class ExpandAction
    extends AbstractAction {
        private DependenciesChildren parent;

        public ExpandAction(DependenciesChildren parent) {
            this.parent = parent;
            this.putValue("Name", NbBundle.getMessage(DependenciesNode.class, (String)"LBL_Expand"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.parent.showNonCP();
        }
    }

    private static class NonCPNode
    extends AbstractNode {
        private DependenciesChildren parent;

        NonCPNode(int count, DependenciesChildren parent) {
            super(Children.LEAF);
            this.parent = parent;
            if (count == 1) {
                this.setDisplayName(NbBundle.getMessage(DependenciesNode.class, (String)"LBL_NonCPCount1"));
            } else {
                this.setDisplayName(NbBundle.getMessage(DependenciesNode.class, (String)"LBL_NonCPCount2", (Object)count));
            }
        }

        public Action getPreferredAction() {
            return new ExpandAction(this.parent);
        }

        public Action[] getActions(boolean context) {
            return new Action[]{new ExpandAction(this.parent)};
        }
    }

    private static class DependenciesComparator
    implements Comparator<DependencyWrapper> {
        private DependenciesComparator() {
        }

        @Override
        public int compare(DependencyWrapper art1, DependencyWrapper art2) {
            boolean transitive2;
            if (art1 == NULL && art2 == NULL) {
                return 0;
            }
            if (art1 == NULL) {
                return -1;
            }
            if (art2 == NULL) {
                return 1;
            }
            boolean transitive1 = art1.getArtifact().getDependencyTrail().size() > 2;
            boolean bl = transitive2 = art2.getArtifact().getDependencyTrail().size() > 2;
            if (transitive1 && !transitive2) {
                return 1;
            }
            if (!transitive1 && transitive2) {
                return -1;
            }
            int ret = art1.getArtifact().getArtifactId().compareTo(art2.getArtifact().getArtifactId());
            if (ret != 0) {
                return ret;
            }
            return art1.getArtifact().compareTo((Object)art2.getArtifact());
        }
    }

    private class ShowManagedStateAction
    extends AbstractAction
    implements Presenter.Popup {
        public ShowManagedStateAction() {
            String s = NbBundle.getMessage(DependenciesNode.class, (String)"LBL_ShowManagedState");
            this.putValue("Name", s);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean b = DependenciesNode.showManagedState();
            Preferences prefs = NbPreferences.root().node(DependenciesNode.PREF_DEPENDENCIES_UI);
            prefs.putBoolean(DependenciesNode.SHOW_MANAGED_DEPENDENCIES, !b);
            try {
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            for (Node nd : DependenciesNode.this.getChildren().getNodes(true)) {
                if (!(nd instanceof DependencyNode)) continue;
                ((DependencyNode)nd).refreshNode();
            }
        }

        public JMenuItem getPopupPresenter() {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(this);
            mi.setSelected(DependenciesNode.showManagedState());
            return mi;
        }
    }

    private static class ShowClasspathDepsAction
    extends AbstractAction
    implements Presenter.Popup {
        public ShowClasspathDepsAction() {
            String s = NbBundle.getMessage(DependenciesNode.class, (String)"LBL_ShowNonClasspath");
            this.putValue("Name", s);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean b = DependenciesNode.showNonClasspath();
            Preferences prefs = NbPreferences.root().node(DependenciesNode.PREF_DEPENDENCIES_UI);
            prefs.putBoolean(DependenciesNode.SHOW_NONCLASSPATH_DEPENDENCIES, !b);
            try {
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public JMenuItem getPopupPresenter() {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(this);
            mi.setSelected(DependenciesNode.showNonClasspath());
            return mi;
        }
    }

    public static class ResolveDepsAction
    extends AbstractAction {
        private Project project;

        public ResolveDepsAction(Project prj) {
            this.putValue("Name", NbBundle.getMessage(DependenciesNode.class, (String)"LBL_Download"));
            this.project = prj;
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            this.setEnabled(false);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    ((NbMavenProject)ResolveDepsAction.this.project.getLookup().lookup(NbMavenProject.class)).downloadDependencyAndJavadocSource();
                }
            });
        }
    }

    private class DownloadJavadocSrcAction
    extends AbstractAction {
        private boolean javadoc;

        public DownloadJavadocSrcAction(boolean javadoc) {
            this.putValue("Name", javadoc ? NbBundle.getMessage(DependenciesNode.class, (String)"LBL_Download_Javadoc") : NbBundle.getMessage(DependenciesNode.class, (String)"LBL_Download__Sources"));
            this.javadoc = javadoc;
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
                    Node[] nds = DependenciesNode.this.getChildren().getNodes();
                    ProgressContributor[] contribs = new ProgressContributor[nds.length];
                    for (int i = 0; i < nds.length; ++i) {
                        contribs[i] = AggregateProgressFactory.createProgressContributor((String)("multi-" + i));
                    }
                    String label = DownloadJavadocSrcAction.this.javadoc ? NbBundle.getMessage(DependenciesNode.class, (String)"Progress_Javadoc") : NbBundle.getMessage(DependenciesNode.class, (String)"Progress_Source");
                    AggregateProgressHandle handle = AggregateProgressFactory.createHandle((String)label, (ProgressContributor[])contribs, null, null);
                    handle.start();
                    try {
                        ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)handle);
                        for (int i = 0; i < nds.length; ++i) {
                            if (!(nds[i] instanceof DependencyNode)) continue;
                            DependencyNode nd = (DependencyNode)nds[i];
                            if (DownloadJavadocSrcAction.this.javadoc && !nd.hasJavadocInRepository()) {
                                nd.downloadJavadocSources(online, contribs[i], DownloadJavadocSrcAction.this.javadoc);
                                continue;
                            }
                            if (!DownloadJavadocSrcAction.this.javadoc && !nd.hasSourceInRepository()) {
                                nd.downloadJavadocSources(online, contribs[i], DownloadJavadocSrcAction.this.javadoc);
                                continue;
                            }
                            contribs[i].finish();
                        }
                    }
                    finally {
                        handle.finish();
                        ProgressTransferListener.clearAggregateHandle();
                    }
                }
            });
        }
    }

    private class AddDependencyAction
    extends AbstractAction {
        public AddDependencyAction() {
            this.putValue("Name", NbBundle.getMessage(DependenciesNode.class, (String)"BTN_Add_Library"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            AddDependencyPanel pnl = new AddDependencyPanel(DependenciesNode.this.project.getOriginalMavenProject(), DependenciesNode.this.project);
            String typeString = DependenciesNode.this.type == 2 ? "runtime" : (DependenciesNode.this.type == 1 ? "test" : "compile");
            pnl.setSelectedScope(typeString);
            pnl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DependenciesNode.class, (String)"TIT_Add_Library"));
            DialogDescriptor dd = new DialogDescriptor((Object)pnl, NbBundle.getMessage(DependenciesNode.class, (String)"TIT_Add_Library"));
            dd.setClosingOptions(new Object[]{pnl.getOkButton(), DialogDescriptor.CANCEL_OPTION});
            dd.setOptions(new Object[]{pnl.getOkButton(), DialogDescriptor.CANCEL_OPTION});
            pnl.attachDialogDisplayer(dd);
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (pnl.getOkButton() == ret) {
                String version = pnl.getVersion();
                if (version != null && version.trim().length() == 0) {
                    version = null;
                }
                ModelUtils.addDependency(DependenciesNode.this.project.getProjectDirectory().getFileObject("pom.xml"), pnl.getGroupId(), pnl.getArtifactId(), version, null, pnl.getScope(), null, false);
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        ((NbMavenProject)DependenciesNode.this.project.getLookup().lookup(NbMavenProject.class)).downloadDependencyAndJavadocSource();
                    }
                });
            }
        }
    }

    private static class DependencyWrapper {
        private Artifact artifact;
        private Dependency dependency;

        public DependencyWrapper(Artifact artifact, Dependency dependency) {
            this.artifact = artifact;
            this.dependency = dependency;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public Dependency getDependency() {
            return this.dependency;
        }

        public boolean equals(Object obj) {
            if (this == NULL && obj == NULL) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DependencyWrapper other = (DependencyWrapper)obj;
            return this.artifact == other.artifact || this.artifact != null && this.artifact.equals(other.artifact);
        }

        public int hashCode() {
            int hash = 7;
            if (this == NULL) {
                return hash;
            }
            hash = 23 * hash + (this.artifact != null ? this.artifact.hashCode() : 0);
            return hash;
        }
    }

    static class DependenciesChildren
    extends Children.Keys<DependencyWrapper>
    implements PropertyChangeListener,
    PreferenceChangeListener {
        private NbMavenProjectImpl project;
        private int type;
        boolean showNonCP = false;
        int nonCPcount = 0;

        public DependenciesChildren(NbMavenProjectImpl proj, int type) {
            this.project = proj;
            this.type = type;
        }

        public void showNonCP() {
            this.showNonCP = true;
            this.regenerateKeys();
            this.refresh();
            this.refreshKey(NULL);
        }

        protected Node[] createNodes(DependencyWrapper wr) {
            if (wr == NULL) {
                return new Node[]{new NonCPNode(this.nonCPcount, this)};
            }
            Lookup look = Lookups.fixed((Object[])new Object[]{wr.getArtifact(), wr.getDependency(), this.project});
            return new Node[]{new DependencyNode(look, true)};
        }

        Node getParentNode() {
            return this.getNode();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                this.regenerateKeys();
                this.refresh();
                this.refreshKey(NULL);
            }
        }

        protected void addNotify() {
            super.addNotify();
            NbMavenProject.addPropertyChangeListener(this.project, this);
            Preferences prefs = NbPreferences.root().node(DependenciesNode.PREF_DEPENDENCIES_UI);
            prefs.addPreferenceChangeListener(this);
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptyList());
            NbMavenProject.removePropertyChangeListener(this.project, this);
            Preferences prefs = NbPreferences.root().node(DependenciesNode.PREF_DEPENDENCIES_UI);
            prefs.removePreferenceChangeListener(this);
            super.removeNotify();
        }

        int regenerateKeys() {
            int cnt;
            TreeSet<DependencyWrapper> lst = new TreeSet<DependencyWrapper>(new DependenciesComparator());
            MavenProject mp = this.project.getOriginalMavenProject();
            if (this.type == 0) {
                lst.addAll(this.create(mp.getCompileDependencies(), mp.getArtifacts()));
                if (this.nonCPcount > 0) {
                    lst.add(NULL);
                }
            }
            if (this.type == 1) {
                lst.addAll(this.create(mp.getTestDependencies(), mp.getArtifacts()));
                cnt = this.nonCPcount;
                this.nonCPcount = 0;
                lst.removeAll(this.create(mp.getCompileDependencies(), mp.getArtifacts()));
                lst.removeAll(this.create(mp.getRuntimeDependencies(), mp.getArtifacts()));
                this.nonCPcount = (cnt -= this.nonCPcount) - this.nonCPcount;
                if (this.nonCPcount <= 0) {
                    lst.remove(NULL);
                } else {
                    lst.add(NULL);
                }
            }
            if (this.type == 2) {
                lst.addAll(this.create(mp.getRuntimeDependencies(), mp.getArtifacts()));
                cnt = this.nonCPcount;
                this.nonCPcount = 0;
                lst.removeAll(this.create(mp.getCompileDependencies(), mp.getArtifacts()));
                this.nonCPcount = cnt - this.nonCPcount;
                if (this.nonCPcount <= 0) {
                    lst.remove(NULL);
                } else {
                    lst.add(NULL);
                }
            }
            this.setKeys(lst);
            return lst.size();
        }

        private Set<DependencyWrapper> create(Collection<Dependency> deps, Collection<Artifact> arts) {
            boolean nonCP = DependenciesNode.showNonClasspath() || this.showNonCP;
            int nonCPCount = 0;
            TreeSet<DependencyWrapper> lst = new TreeSet<DependencyWrapper>(new DependenciesComparator());
            for (Dependency d : deps) {
                boolean added = false;
                for (Artifact a : arts) {
                    if (!a.getGroupId().equals(d.getGroupId()) || !a.getArtifactId().equals(d.getArtifactId()) || !StringUtils.equals((String)a.getClassifier(), (String)d.getClassifier())) continue;
                    if (nonCP || a.getArtifactHandler().isAddedToClasspath()) {
                        lst.add(new DependencyWrapper(a, d));
                    } else {
                        ++nonCPCount;
                    }
                    added = true;
                    break;
                }
                if (added) continue;
                System.out.println("not found artifact for " + d);
            }
            this.nonCPcount = nonCPCount;
            return lst;
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            if (DependenciesNode.SHOW_NONCLASSPATH_DEPENDENCIES.equals(evt.getKey())) {
                this.regenerateKeys();
            }
        }
    }
}

