/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ArchetypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class LayerBasedArchetypeProvider
implements ArchetypeProvider {
    @Override
    public List<Archetype> getArchetypes() {
        FileObject root = FileUtil.getConfigFile((String)"Projects/org-netbeans-modules-maven/Archetypes");
        ArrayList<Archetype> toRet = new ArrayList<Archetype>();
        for (FileObject fo : FileUtil.getOrder(Arrays.asList(root.getChildren()), (boolean)false)) {
            String groupId = (String)fo.getAttribute("groupId");
            String artifactId = (String)fo.getAttribute("artifactId");
            String version = (String)fo.getAttribute("version");
            String repository = (String)fo.getAttribute("repository");
            String nameKey = (String)fo.getAttribute("nameBundleKey");
            String descKey = (String)fo.getAttribute("descriptionBundleKey");
            String bundleLocation = (String)fo.getAttribute("SystemFileSystem.localizingBundle");
            if (groupId == null || artifactId == null || version == null) continue;
            Archetype simple = new Archetype(false);
            simple.setGroupId(groupId);
            simple.setArtifactId(artifactId);
            simple.setVersion(version);
            simple.setRepository(repository);
            if (bundleLocation != null) {
                ResourceBundle bundle = NbBundle.getBundle((String)bundleLocation);
                if (bundle != null && nameKey != null) {
                    simple.setName(bundle.getString(nameKey));
                }
                if (bundle != null && descKey != null) {
                    simple.setDescription(bundle.getString(descKey));
                }
            }
            if (simple.getName() == null) {
                simple.setName(simple.getArtifactId());
            }
            toRet.add(simple);
        }
        return toRet;
    }
}

