/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.apache.maven.monitor.event.EventMonitor;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.embedder.exec.MyLifecycleExecutor;
import org.netbeans.modules.maven.execute.AbstractOutputHandler;
import org.netbeans.modules.maven.execute.CommandLineOutputHandler;
import org.openide.execution.ExecutorTask;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.io.NullOutputStream;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

class JavaOutputHandler
extends AbstractOutputHandler
implements EventMonitor,
MavenEmbedderLogger {
    private static final String SEC_MOJO_EXEC = "mojo-execute";
    private static final String SEC_PRJ_EXEC = "project-execute";
    private static final String SEC_REAC_EXEC = "reactor-execute";
    private InputOutput inputOutput;
    private OutputWriter stdOut;
    private OutputWriter stdErr;
    private StreamBridge out;
    private StreamBridge err;
    private InputStream in;
    private int threshold = 1;
    private AggregateProgressHandle handle;
    private boolean doCancel = false;
    private ExecutorTask task;
    private List<ProgressContributor> progress = new ArrayList<ProgressContributor>();
    private boolean isReactor = false;
    private ProgressContributor cont;
    private int total = 10;
    private int count = 0;
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Maven Embedded Input Redirection", 5);
    private static RequestProcessor PRCS = new RequestProcessor();

    JavaOutputHandler(AggregateProgressHandle hand) {
        super(hand);
    }

    @Deprecated
    void setup(HashMap<String, Set<OutputProcessor>> procs, OutputWriter std, OutputWriter err) {
        this.processors = procs;
        this.stdErr = err;
        this.stdOut = std;
    }

    public JavaOutputHandler(InputOutput io, Project proj, AggregateProgressHandle hand, RunConfig config) {
        this(hand);
        this.inputOutput = io;
        this.handle = hand;
        this.stdOut = this.inputOutput.getOut();
        this.stdErr = this.inputOutput.getErr();
        this.initProcessorList(proj, config);
    }

    public void errorEvent(String eventName, String target, long l, Throwable throwable) {
        this.processFail(this.getEventId(eventName, target), this.stdErr);
    }

    public void startEvent(String eventName, String target, long l) {
        this.processStart(this.getEventId(eventName, target), this.stdOut);
        if (this.handle != null) {
            if (SEC_REAC_EXEC.equals(eventName)) {
                this.isReactor = true;
            }
            if (this.isReactor && SEC_PRJ_EXEC.equals(eventName)) {
                this.isReactor = false;
                int bufferSize = MyLifecycleExecutor.getAffectedProjects().size();
                for (int i = 0; i < bufferSize; ++i) {
                    ProgressContributor contr = AggregateProgressFactory.createProgressContributor((String)("project" + i));
                    this.handle.addContributor(contr);
                    this.progress.add(contr);
                }
            }
            if (SEC_PRJ_EXEC.equals(eventName)) {
                if (this.progress.size() > 0) {
                    this.cont = this.progress.remove(0);
                    this.cont.start(1);
                } else {
                    this.cont = AggregateProgressFactory.createProgressContributor((String)"project");
                }
                this.count = 0;
                this.cont.start(this.total);
            }
            if (SEC_MOJO_EXEC.equals(eventName)) {
                ++this.count;
                if (this.count < this.total) {
                    this.cont.progress(target, this.count);
                }
            }
        }
        if (this.cont != null) {
            this.cont.progress(target);
        }
    }

    public void endEvent(String eventName, String target, long l) {
        this.processEnd(this.getEventId(eventName, target), this.stdOut);
        if (SEC_PRJ_EXEC.equals(eventName) && this.cont != null) {
            this.total = this.count;
            this.cont.finish();
        }
        if (this.doCancel) {
            assert (this.task != null);
            this.task.stop();
        }
    }

    public void debug(String string) {
        if (this.isDebugEnabled()) {
            this.processMultiLine(string, this.stdOut, "DEBUG");
        }
    }

    public void debug(String string, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.processMultiLine(string, this.stdOut, "DEBUG");
            throwable.printStackTrace((PrintWriter)this.stdOut);
        }
    }

    public boolean isDebugEnabled() {
        return this.threshold == 0;
    }

    public void info(String string) {
        this.processMultiLine(string, this.stdOut, "");
    }

    public void info(String string, Throwable throwable) {
        this.processMultiLine(string, this.stdOut, "");
        throwable.printStackTrace((PrintWriter)this.stdOut);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void warn(String string) {
        if (string.startsWith("Unable to get resource from repository")) {
            if (this.isDebugEnabled()) {
                this.processMultiLine(string, this.stdOut, "DEBUG");
            }
            return;
        }
        if (string.startsWith("The <pluginRepositories/> section of the POM has been deprecated")) {
            if (this.isDebugEnabled()) {
                this.processMultiLine(string, this.stdOut, "DEBUG");
            }
            return;
        }
        this.processMultiLine(string, this.stdOut, "WARN");
    }

    public void warn(String string, Throwable throwable) {
        this.processMultiLine(string, this.stdOut, "WARN");
        throwable.printStackTrace((PrintWriter)this.stdOut);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void error(String string) {
        this.processMultiLine(string, this.stdErr, "ERROR");
    }

    public void error(String string, Throwable throwable) {
        this.processMultiLine(string, this.stdErr, "ERROR");
        throwable.printStackTrace((PrintWriter)this.stdErr);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void fatalError(String string) {
        this.processMultiLine(string, this.stdErr, "FATAL");
    }

    public void fatalError(String string, Throwable throwable) {
        this.processMultiLine(string, this.stdErr, "FATAL");
        throwable.printStackTrace((PrintWriter)this.stdErr);
    }

    public boolean isFatalErrorEnabled() {
        return true;
    }

    public void setThreshold(int i) {
        this.threshold = i;
    }

    public int getThreshold() {
        return this.threshold;
    }

    PrintStream getErr() {
        if (this.err == null) {
            this.err = new StreamBridge(this.stdErr);
        }
        return this.err;
    }

    InputStream getIn() {
        if (this.in == null) {
            try {
                PipedInputStream inS = new PipedInputStream();
                PipedOutputStream ouS = new PipedOutputStream();
                inS.connect(ouS);
                CommandLineOutputHandler.Input inp = new CommandLineOutputHandler.Input(ouS, this.inputOutput);
                PROCESSOR.post((Runnable)inp);
                this.in = inS;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this.in;
    }

    PrintStream getOut() {
        if (this.out == null) {
            this.out = new StreamBridge(this.stdOut);
        }
        return this.out;
    }

    void requestCancel(ExecutorTask task) {
        this.doCancel = true;
        this.task = task;
    }

    @Override
    protected InputOutput getIO() {
        return this.inputOutput;
    }

    @Override
    MavenEmbedderLogger getLogger() {
        return this;
    }

    public void close() {
    }

    private class StreamBridge
    extends PrintStream
    implements Runnable {
        StringBuffer buff;
        private OutputWriter writer;
        RequestProcessor.Task task;

        public StreamBridge(OutputWriter wr) {
            super((OutputStream)new NullOutputStream());
            this.buff = new StringBuffer();
            this.writer = wr;
            this.task = PRCS.create((Runnable)this);
        }

        @Override
        public synchronized void run() {
            if (this.buff.length() > 0) {
                this.writer.print(this.buff.toString());
                this.buff.setLength(0);
            }
        }

        @Override
        public synchronized void flush() {
            if (this.buff.length() > 0) {
                this.doPrint();
            }
        }

        @Override
        public synchronized void print(long l) {
            this.buff.append(l);
            this.task.schedule(500);
        }

        @Override
        public synchronized void print(char[] s) {
            this.buff.append(s);
            this.task.schedule(500);
        }

        @Override
        public synchronized void print(int i) {
            this.buff.append(i);
            this.task.schedule(500);
        }

        @Override
        public synchronized void print(boolean b) {
            this.buff.append(b);
            this.task.schedule(500);
        }

        @Override
        public synchronized void print(char c) {
            this.buff.append(c);
            this.task.schedule(500);
        }

        @Override
        public synchronized void print(float f) {
            this.buff.append(f);
            this.task.schedule(500);
        }

        @Override
        public synchronized void print(double d) {
            this.buff.append(d);
            this.task.schedule(500);
        }

        @Override
        public synchronized void print(Object obj) {
            this.buff.append(obj.toString());
            this.task.schedule(500);
        }

        @Override
        public synchronized void print(String s) {
            this.buff.append(s);
            this.task.schedule(500);
        }

        @Override
        public synchronized void println(double x) {
            this.buff.append(x);
            this.doPrint();
        }

        @Override
        public synchronized void println(Object x) {
            this.buff.append(x.toString());
            this.doPrint();
        }

        @Override
        public synchronized void println(float x) {
            this.buff.append(x);
            this.doPrint();
        }

        @Override
        public synchronized void println(int x) {
            this.buff.append(x);
            this.doPrint();
        }

        @Override
        public synchronized void println(char x) {
            this.buff.append(x);
            this.doPrint();
        }

        @Override
        public synchronized void println(boolean x) {
            this.buff.append(x);
            this.doPrint();
        }

        @Override
        public synchronized void println(String x) {
            this.buff.append(x);
            this.doPrint();
        }

        @Override
        public synchronized void println(char[] x) {
            this.buff.append(x);
            this.doPrint();
        }

        @Override
        public synchronized void println() {
            this.doPrint();
        }

        @Override
        public synchronized void println(long x) {
            this.buff.append(x);
            this.doPrint();
        }

        @Override
        public synchronized void write(int b) {
            this.buff.append((char)b);
            this.task.schedule(500);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            ByteArrayInputStream bais = new ByteArrayInputStream(b, off, len);
            InputStreamReader read = new InputStreamReader(bais);
            try {
                while (((Reader)read).ready()) {
                    this.buff.append((char)((Reader)read).read());
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.task.schedule(500);
        }

        private void doPrint() {
            assert (Thread.holdsLock(this));
            JavaOutputHandler.this.processMultiLine(this.buff.toString(), this.writer, "");
            this.buff.setLength(0);
        }
    }
}

