/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.output.ContextOutputProcessorFactory;
import org.netbeans.modules.maven.api.output.NotifyFinishOutputProcessor;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputProcessorFactory;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOColorLines;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public abstract class AbstractOutputHandler {
    protected static final String PRJ_EXECUTE = "project-execute";
    protected HashMap<String, Set<OutputProcessor>> processors = new HashMap();
    protected Set<OutputProcessor> currentProcessors = new HashSet<OutputProcessor>();
    protected Set<NotifyFinishOutputProcessor> toFinishProcessors;
    protected OutputVisitor visitor = new OutputVisitor();
    private RequestProcessor.Task sleepTask;
    private static final int SLEEP_DELAY = 5000;

    protected AbstractOutputHandler() {
        this.toFinishProcessors = new HashSet<NotifyFinishOutputProcessor>();
    }

    protected AbstractOutputHandler(final ProgressHandle hand) {
        this();
        this.sleepTask = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                hand.suspend("");
            }
        });
    }

    protected AbstractOutputHandler(final AggregateProgressHandle hand) {
        this();
        this.sleepTask = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                hand.suspend("");
            }
        });
    }

    protected abstract InputOutput getIO();

    protected void checkSleepiness() {
        RequestProcessor.Task task = this.sleepTask;
        if (task != null) {
            task.schedule(5000);
        }
    }

    protected final void quitSleepiness() {
        RequestProcessor.Task task = this.sleepTask;
        if (task != null) {
            task.cancel();
            this.sleepTask = null;
        }
    }

    abstract MavenEmbedderLogger getLogger();

    protected final String getEventId(String eventName, String target) {
        if (PRJ_EXECUTE.equals(eventName)) {
            return eventName;
        }
        return eventName + "#" + target;
    }

    protected final void initProcessorList(Project proj, RunConfig config) {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(OutputProcessorFactory.class));
        for (OutputProcessorFactory factory : result.allInstances()) {
            Set<OutputProcessor> procs = factory.createProcessorsSet(proj);
            if (factory instanceof ContextOutputProcessorFactory) {
                procs = new HashSet<OutputProcessor>(procs);
                procs.addAll(((ContextOutputProcessorFactory)factory).createProcessorsSet(proj, config));
            }
            for (OutputProcessor proc : procs) {
                String[] regs = proc.getRegisteredOutputSequences();
                for (int i = 0; i < regs.length; ++i) {
                    String str = regs[i];
                    Set<OutputProcessor> set = this.processors.get(str);
                    if (set == null) {
                        set = new HashSet<OutputProcessor>();
                        this.processors.put(str, set);
                    }
                    set.add(proc);
                }
            }
        }
    }

    protected final void processStart(String id, OutputWriter writer) {
        this.checkSleepiness();
        Set<OutputProcessor> set = this.processors.get(id);
        if (set != null) {
            this.currentProcessors.addAll(set);
        }
        this.visitor.resetVisitor();
        for (OutputProcessor proc : this.currentProcessors) {
            proc.sequenceStart(id, this.visitor);
        }
        if (this.visitor.getLine() != null) {
            if (this.visitor.getOutputListener() != null) {
                try {
                    writer.println(this.visitor.getLine(), this.visitor.getOutputListener(), this.visitor.isImportant());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else if (this.visitor.getColor() != null && IOColorLines.isSupported((InputOutput)this.getIO())) {
                try {
                    IOColorLines.println((InputOutput)this.getIO(), (CharSequence)this.visitor.getLine(), (Color)this.visitor.getColor());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                writer.println(this.visitor.getLine());
            }
        }
    }

    protected final void processEnd(String id, OutputWriter writer) {
        Set<OutputProcessor> set;
        this.checkSleepiness();
        this.visitor.resetVisitor();
        for (OutputProcessor proc : this.currentProcessors) {
            proc.sequenceEnd(id, this.visitor);
            if (!(proc instanceof NotifyFinishOutputProcessor)) continue;
            this.toFinishProcessors.add((NotifyFinishOutputProcessor)proc);
        }
        if (this.visitor.getLine() != null) {
            if (this.visitor.getOutputListener() != null) {
                try {
                    writer.println(this.visitor.getLine(), this.visitor.getOutputListener(), this.visitor.isImportant());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                writer.println(this.visitor.getLine());
            }
        }
        if ((set = this.processors.get(id)) != null) {
            this.currentProcessors.removeAll(set);
        }
    }

    protected final void processFail(String id, OutputWriter writer) {
        Set<OutputProcessor> set;
        this.checkSleepiness();
        this.visitor.resetVisitor();
        for (OutputProcessor proc : this.currentProcessors) {
            if (proc instanceof NotifyFinishOutputProcessor) {
                this.toFinishProcessors.add((NotifyFinishOutputProcessor)proc);
            }
            proc.sequenceFail(id, this.visitor);
        }
        if (this.visitor.getLine() != null) {
            if (this.visitor.getOutputListener() != null) {
                try {
                    writer.println(this.visitor.getLine(), this.visitor.getOutputListener(), this.visitor.isImportant());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                writer.println(this.visitor.getLine());
            }
        }
        if ((set = this.processors.get(id)) != null) {
            HashSet<OutputProcessor> retain = new HashSet<OutputProcessor>();
            retain.addAll(set);
            retain.retainAll(this.currentProcessors);
            HashSet<OutputProcessor> remove = new HashSet<OutputProcessor>();
            remove.addAll(set);
            remove.removeAll(retain);
            this.currentProcessors.removeAll(remove);
        }
    }

    protected final void buildFinished() {
        this.quitSleepiness();
        for (NotifyFinishOutputProcessor proc : this.toFinishProcessors) {
            proc.buildFinished();
        }
    }

    protected final void processMultiLine(String input, OutputWriter writer, String levelText) {
        if (input == null) {
            return;
        }
        for (String s : AbstractOutputHandler.splitMultiLine(input)) {
            this.processLine(s, writer, levelText);
        }
    }

    protected final void processLine(String input, OutputWriter writer, String levelText) {
        this.checkSleepiness();
        this.visitor.resetVisitor();
        for (OutputProcessor proc : this.currentProcessors) {
            proc.processLine(input, this.visitor);
        }
        if (!this.visitor.isLineSkipped()) {
            String line;
            String string = line = this.visitor.getLine() == null ? input : this.visitor.getLine();
            if (this.visitor.getOutputListener() != null) {
                try {
                    writer.println((levelText.length() == 0 ? "" : "[" + levelText + "]") + line, this.visitor.getOutputListener(), this.visitor.isImportant());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else if (this.visitor.getColor() != null && IOColorLines.isSupported((InputOutput)this.getIO())) {
                try {
                    IOColorLines.println((InputOutput)this.getIO(), (CharSequence)line, (Color)this.visitor.getColor());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                writer.println((levelText.length() == 0 ? "" : "[" + levelText + "]") + line);
            }
        }
    }

    public static List<String> splitMultiLine(String input) {
        ArrayList<String> list = new ArrayList<String>();
        String[] strs = input.split("\\r|\\n");
        for (int i = 0; i < strs.length; ++i) {
            if (strs[i].length() <= 0) continue;
            list.add(strs[i]);
        }
        return list;
    }
}

