/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.CadDevice;
import com.sun.javacard.apduio.TLP224Exception;
import com.sun.javacard.apduio.TLP224Message;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CadT0
extends CadDevice {
    private boolean first_time_receiving_by_server = true;

    public CadT0(InputStream in, OutputStream out) {
        super((byte)0, in, out);
    }

    public synchronized void receiveTLP224Message(TLP224Message msg) throws IOException, TLP224Exception {
        int tries = 0;
        while (true) {
            if (tries++ > 5) {
                throw new TLP224Exception(1);
            }
            boolean messageTooLong = false;
            boolean xmitError = false;
            byte[] msgData = msg.getData();
            int got = 0;
            while (true) {
                int lowNibble;
                int hiNibble = this.in.read();
                if (this.first_time_receiving_by_server) {
                    if (hiNibble != 54) {
                        System.err.println(CadDevice._messages.getString("cad.3"));
                        this.in.close();
                        System.exit(1);
                    }
                    this.first_time_receiving_by_server = false;
                }
                if (hiNibble == 3) break;
                if (hiNibble == -1) {
                    throw new EOFException();
                }
                if ((hiNibble -= 48) > 9) {
                    hiNibble -= 7;
                }
                if (hiNibble < 0 || hiNibble > 15) {
                    xmitError = true;
                }
                if ((lowNibble = this.in.read()) == 3) {
                    xmitError = true;
                    break;
                }
                if (lowNibble == -1) {
                    throw new EOFException();
                }
                if ((lowNibble -= 48) > 9) {
                    lowNibble -= 7;
                }
                if (lowNibble < 0 || lowNibble > 15) {
                    xmitError = true;
                }
                if (messageTooLong || xmitError) continue;
                try {
                    msgData[got++] = (byte)(hiNibble << 4 | lowNibble);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    messageTooLong = true;
                }
            }
            if (xmitError) {
                if (this.debug) {
                    System.out.println(CadDevice._messages.getString("cad.1"));
                    System.out.flush();
                }
                this.transmissionError();
                continue;
            }
            if (messageTooLong) {
                if (this.debug) {
                    System.out.println(CadDevice._messages.getString("cad.2"));
                    System.out.flush();
                }
                this.statusResponse(18);
                continue;
            }
            msg.setLength(got);
            if (this.debug) {
                System.out.println("<-- " + msg);
                System.out.flush();
            }
            if (msgData[got - 1] != (byte)msg.computeLRC(got - 1)) {
                this.transmissionError();
                continue;
            }
            if (msgData[1] != (byte)(got - 3)) {
                this.transmissionError();
                continue;
            }
            if (msgData[0] == 96 || msgData[0] == -32) break;
            this.statusResponse(9);
        }
    }

    public void sendTLP224Message(TLP224Message msg) throws IOException {
        this.first_time_receiving_by_server = false;
        if (this.debug) {
            System.out.println("--> " + msg);
            System.out.flush();
        }
        byte[] msgData = msg.getData();
        for (int i = 0; i < msg.getLength(); ++i) {
            int nibble = msgData[i] >> 4 & 0xF;
            nibble = nibble < 10 ? (nibble += 48) : (nibble += 55);
            this.out.write(nibble);
            nibble = msgData[i] & 0xF;
            nibble = nibble < 10 ? (nibble += 48) : (nibble += 55);
            this.out.write(nibble);
        }
        this.out.write(3);
        this.out.flush();
    }

    void statusResponse(int code) throws IOException {
        TLP224Message msg = new TLP224Message(new byte[4]);
        byte[] msgData = msg.getData();
        msgData[0] = 96;
        msgData[1] = 1;
        msgData[2] = (byte)code;
        msgData[3] = (byte)msg.computeLRC(3);
        msg.setLength(4);
        this.sendTLP224Message(msg);
    }

    private void transmissionError() throws IOException {
        TLP224Message msg = new TLP224Message(new byte[3]);
        byte[] msgData = msg.getData();
        msgData[0] = -32;
        msgData[1] = 0;
        msgData[2] = (byte)msg.computeLRC(2);
        msg.setLength(3);
        this.sendTLP224Message(msg);
    }
}

