/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.EventQueue;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CloseProject
extends ProjectAction {
    private static final String namePattern = NbBundle.getMessage(CloseProject.class, (String)"LBL_CloseProjectAction_Name");
    private static final String namePatternPopup = NbBundle.getMessage(CloseProject.class, (String)"LBL_CloseProjectAction_Popup_Name");

    public CloseProject() {
        this((Lookup)null);
    }

    public CloseProject(Lookup context) {
        super((String)null, namePattern, namePatternPopup, null, context);
        this.refresh(this.getLookup(), true);
    }

    @Override
    protected void actionPerformed(final Lookup context) {
        if (EventQueue.isDispatchThread()) {
            OpenProjectList.OPENING_RP.post(new Runnable(){

                @Override
                public void run() {
                    CloseProject.this.actionPerformed(context);
                }
            });
            return;
        }
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, null);
        OpenProjectList.getDefault().close(projects, true);
    }

    @Override
    public void refresh(Lookup context, boolean immediate) {
        super.refresh(context, immediate);
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, null);
        if (projects.length == 0 || !OpenProjectList.getDefault().isOpen(projects[0])) {
            this.enable(false);
        } else {
            this.enable(true);
        }
    }

    private void enable(final boolean enable) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CloseProject.this.setEnabled(enable);
                }
            });
        } else {
            this.setEnabled(enable);
        }
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        return new CloseProject(actionContext);
    }
}

