/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.ErrorManager;
import org.openide.actions.PropertiesAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class PhysicalView {
    public static boolean isProjectDirNode(Node n) {
        return n instanceof GroupNode && ((GroupNode)n).isProjectDir;
    }

    public static Node[] createNodesForProject(Project p) {
        Sources s = ProjectUtils.getSources((Project)p);
        SourceGroup[] groups = s.getSourceGroups("generic");
        FileObject projectDirectory = p.getProjectDirectory();
        SourceGroup projectDirGroup = null;
        for (int i = 0; i < groups.length; ++i) {
            FileObject groupRoot = groups[i].getRootFolder();
            if (!projectDirectory.equals(groupRoot) && !FileUtil.isParentOf((FileObject)groupRoot, (FileObject)projectDirectory)) continue;
            if (projectDirGroup != null) {
                projectDirGroup = null;
                break;
            }
            projectDirGroup = groups[i];
        }
        if (projectDirGroup == null) {
            ErrorManager.getDefault().log(16, "Project " + p + "either does not contain it's project directory under the " + "Generic source groups or the project directory is under " + "more than one source group");
            return new Node[0];
        }
        FileObject rootFolder = projectDirGroup.getRootFolder();
        if (!rootFolder.isValid() || !rootFolder.isFolder()) {
            return new Node[0];
        }
        ArrayList<GroupNode> nodesList = new ArrayList<GroupNode>(groups.length);
        nodesList.add(new GroupNode(p, projectDirGroup, true, DataFolder.findFolder((FileObject)rootFolder)));
        for (SourceGroup group : groups) {
            if (group == projectDirGroup || "sharedlibraries".equals(group.getName()) || !(rootFolder = group.getRootFolder()).isValid() || !rootFolder.isFolder()) continue;
            nodesList.add(new GroupNode(p, group, false, DataFolder.findFolder((FileObject)rootFolder)));
        }
        Node[] nodes = new Node[nodesList.size()];
        nodesList.toArray(nodes);
        return nodes;
    }

    public static class PathFinder {
        private SourceGroup group;

        public PathFinder(SourceGroup group) {
            this.group = group;
        }

        public Node findPath(Node root, Object object) {
            block10: {
                if (!(object instanceof FileObject)) {
                    return null;
                }
                FileObject fo = (FileObject)object;
                FileObject groupRoot = this.group.getRootFolder();
                if (FileUtil.isParentOf((FileObject)groupRoot, (FileObject)fo)) {
                    String relPath = FileUtil.getRelativePath((FileObject)groupRoot, (FileObject)fo);
                    ArrayList<String> path = new ArrayList<String>();
                    StringTokenizer strtok = new StringTokenizer(relPath, "/");
                    while (strtok.hasMoreTokens()) {
                        path.add(strtok.nextToken());
                    }
                    if (path.size() <= 0) {
                        return null;
                    }
                    path.remove(path.size() - 1);
                    try {
                        DataObject dobj;
                        Node parent = NodeOp.findPath((Node)root, Collections.enumeration(path));
                        if (parent == null) break block10;
                        Node[] nds = parent.getChildren().getNodes(true);
                        for (int i = 0; i < nds.length; ++i) {
                            dobj = (DataObject)nds[i].getLookup().lookup(DataObject.class);
                            if (dobj == null || !fo.equals(dobj.getPrimaryFile())) continue;
                            return nds[i];
                        }
                        String name = fo.getName();
                        try {
                            dobj = DataObject.find((FileObject)fo);
                            name = dobj.getNodeDelegate().getName();
                        }
                        catch (DataObjectNotFoundException ex) {
                            // empty catch block
                        }
                        return parent.getChildren().findChild(name);
                    }
                    catch (NodeNotFoundException e) {
                        return null;
                    }
                }
                if (groupRoot.equals(fo)) {
                    return root;
                }
            }
            return null;
        }
    }

    static final class GroupNode
    extends FilterNode
    implements PropertyChangeListener {
        private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();
        static final String GROUP_NAME_PATTERN = NbBundle.getMessage(PhysicalView.class, (String)"FMT_PhysicalView_GroupName");
        private ProjectInformation pi;
        private SourceGroup group;
        private boolean isProjectDir;

        public GroupNode(Project project, SourceGroup group, boolean isProjectDir, DataFolder dataFolder) {
            super(dataFolder.getNodeDelegate(), dataFolder.createNodeChildren(VISIBILITY_QUERY_FILTER), GroupNode.createLookup(project, group, dataFolder));
            this.pi = ProjectUtils.getInformation((Project)project);
            this.group = group;
            this.isProjectDir = isProjectDir;
            this.pi.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.pi));
            group.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group));
        }

        public String getName() {
            if (this.isProjectDir) {
                return this.pi.getName();
            }
            String n = this.group.getName();
            if (n == null) {
                n = "???";
                ErrorManager.getDefault().log(16, "SourceGroup impl of type " + this.group.getClass().getName() + " specified a null getName(); this is illegal");
            }
            return n;
        }

        public String getDisplayName() {
            if (this.isProjectDir) {
                return this.pi.getDisplayName();
            }
            return MessageFormat.format(GROUP_NAME_PATTERN, this.group.getDisplayName(), this.pi.getDisplayName(), this.getOriginal().getDisplayName());
        }

        public String getShortDescription() {
            FileObject gdir = this.group.getRootFolder();
            String dir = FileUtil.getFileDisplayName((FileObject)gdir);
            return NbBundle.getMessage(PhysicalView.class, (String)(this.isProjectDir ? "HINT_project" : "HINT_group"), (Object)dir);
        }

        public boolean canRename() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public Action[] getActions(boolean context) {
            Action[] projectActions;
            if (context) {
                return super.getActions(true);
            }
            Action[] folderActions = super.getActions(false);
            if (this.isProjectDir) {
                projectActions = new Action[folderActions.length];
                for (int i = 0; i < folderActions.length; ++i) {
                    projectActions[i] = folderActions[i] instanceof PropertiesAction ? CommonProjectActions.customizeProjectAction() : folderActions[i];
                }
            } else {
                projectActions = folderActions;
            }
            return projectActions;
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    String prop = evt.getPropertyName();
                    boolean ok = false;
                    if (prop == null || "displayName".equals(prop)) {
                        GroupNode.this.fireDisplayNameChange(null, null);
                        ok = true;
                    }
                    if (prop == null || "name".equals(prop)) {
                        GroupNode.this.fireNameChange(null, null);
                        ok = true;
                    }
                    if (prop == null || "icon".equals(prop)) {
                        ok = true;
                    }
                    if (prop == null || "name".equals(prop)) {
                        GroupNode.this.fireNameChange(null, null);
                        ok = true;
                    }
                    if (prop == null || "displayName".equals(prop)) {
                        GroupNode.this.fireDisplayNameChange(null, null);
                        ok = true;
                    }
                    if (prop == null || "icon".equals(prop)) {
                        ok = true;
                    }
                    if (prop == null || "rootFolder".equals(prop)) {
                        GroupNode.this.fireNameChange(null, null);
                        GroupNode.this.fireDisplayNameChange(null, null);
                        GroupNode.this.fireShortDescriptionChange(null, null);
                        ok = true;
                    }
                    if (prop == null || "containership".equals(prop)) {
                        ok = true;
                    }
                    if (!ok) assert (false) : "Attempt to fire an unsupported property change event from " + GroupNode.access$900(GroupNode.this).getClass().getName() + ": " + prop;
                }
            };
            SwingUtilities.invokeLater(r);
        }

        private static Lookup createLookup(Project p, SourceGroup group, DataFolder dataFolder) {
            return new ProxyLookup(new Lookup[]{dataFolder.getNodeDelegate().getLookup(), Lookups.fixed((Object[])new Object[]{p, new PathFinder(group)}), p.getLookup()});
        }

        static /* synthetic */ ProjectInformation access$900(GroupNode x0) {
            return x0.pi;
        }
    }

    static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter,
    DataFilter.FileBased {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject obj) {
            return this.acceptFileObject(obj.getPrimaryFile());
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    VisibilityQueryDataFilter.this.changeSupport.fireChange();
                }
            };
            SwingUtilities.invokeLater(r);
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        public boolean acceptFileObject(FileObject fo) {
            return VisibilityQuery.getDefault().isVisible(fo);
        }
    }
}

