/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.earproject.ModuleType;
import org.netbeans.modules.j2ee.earproject.util.EarProjectUtil;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PanelModuleDetectionVisual
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Vector<Vector<String>> modules = new Vector();
    private static final int REL_PATH_INDEX = 0;
    private static final int TYPE_INDEX = 1;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private File eaLocation;
    private JButton addModuleButton;
    private JLabel appModulesLabel;
    private JScrollPane moduleSP;
    private JTable moduleTable;
    private JButton removeModuleButton;

    public PanelModuleDetectionVisual() {
        this.initComponents();
        this.initModuleTable();
        this.setName(PanelModuleDetectionVisual.getMessage("LBL_IW_ApplicationModulesStep"));
        this.putClientProperty("NewProjectWizard_Title", PanelModuleDetectionVisual.getMessage("TXT_ImportProject"));
        this.getAccessibleContext().setAccessibleDescription(PanelModuleDetectionVisual.getMessage("ACS_NWP1_NamePanel_A11YDesc"));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    private void initModuleTable() {
        Vector<String> vector = new Vector<String>();
        vector.add(PanelModuleDetectionVisual.getMessage("LBL_IW_Module"));
        vector.add(PanelModuleDetectionVisual.getMessage("LBL_IW_Type"));
        DefaultTableModel defaultTableModel = new DefaultTableModel(this.modules, vector);
        this.moduleTable.setModel(defaultTableModel);
        TableColumnModel tableColumnModel = this.moduleTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        ModuleTypeRenderer moduleTypeRenderer = new ModuleTypeRenderer();
        tableColumn.setCellRenderer(moduleTypeRenderer);
        tableColumn.setCellEditor(new ModuleTypeEditor());
        this.moduleTable.setRowHeight((int)moduleTypeRenderer.getPreferredSize().getHeight());
        this.moduleSP.getViewport().setBackground(this.moduleTable.getBackground());
    }

    void read(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("sourceRoot");
        assert (file != null) : "Location is not available!";
        if (!file.equals(this.eaLocation)) {
            this.modules.removeAllElements();
        }
        this.eaLocation = file;
        FileObject fileObject = FileUtil.toFileObject((File)this.eaLocation);
        Map<FileObject, ModuleType> map = ModuleType.detectModules(fileObject);
        for (FileObject fileObject2 : map.keySet()) {
            this.addModuleToTable(FileUtil.toFile((FileObject)fileObject2));
        }
        this.getModuleTableModel().fireTableDataChanged();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        for (Vector<String> vector : this.modules) {
            String string = vector.get(0);
            if (!this.isForbiddenProject(string)) continue;
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"MSG_ModuleNotJavaEEModule", (Object)string));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        return true;
    }

    private boolean isForbiddenProject(String string) {
        File file = FileUtil.normalizeFile((File)new File(this.eaLocation, string));
        Project project = null;
        try {
            project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        }
        if (project == null) {
            return false;
        }
        return !EarProjectUtil.isJavaEEModule(project);
    }

    void store(WizardDescriptor wizardDescriptor) {
        HashMap<FileObject, ModuleType> hashMap = new HashMap<FileObject, ModuleType>();
        block0: for (Vector<String> vector : this.modules) {
            String string = vector.get(1);
            for (ModuleType moduleType : ModuleType.values()) {
                if (!moduleType.getDescription().equals(string)) continue;
                File file = new File(this.eaLocation, vector.get(0));
                FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                assert (fileObject != null);
                hashMap.put(fileObject, moduleType);
                continue block0;
            }
        }
        wizardDescriptor.putProperty("userModules", hashMap);
    }

    private DefaultTableModel getModuleTableModel() {
        return (DefaultTableModel)this.moduleTable.getModel();
    }

    private void addModuleToTable(File file) {
        String string = PropertyUtils.relativizeFile((File)this.eaLocation, (File)file);
        for (Vector<String> vector : this.modules) {
            if (!string.equals(vector.get(0))) continue;
            return;
        }
        Vector vector = new Vector();
        vector.add(string);
        vector.add(this.getModuleType(string).getDescription());
        this.modules.add(vector);
        this.changeSupport.fireChange();
    }

    private static final String getMessage(String string) {
        return NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)string);
    }

    private void initComponents() {
        this.appModulesLabel = new JLabel();
        this.moduleSP = new JScrollPane();
        this.moduleTable = new JTable();
        this.addModuleButton = new JButton();
        this.removeModuleButton = new JButton();
        this.appModulesLabel.setLabelFor(this.moduleTable);
        Mnemonics.setLocalizedText((JLabel)this.appModulesLabel, (String)NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"LBL_IW_ApplicationModules"));
        this.appModulesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"ACSD_LBL_IW_ApplicationModules"));
        this.moduleSP.setViewportView(this.moduleTable);
        this.moduleSP.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"ACSN_CTL_AppModules"));
        this.moduleSP.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"ACSD_CTL_AppModules"));
        Mnemonics.setLocalizedText((AbstractButton)this.addModuleButton, (String)NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"LBL_IW_Add"));
        this.addModuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PanelModuleDetectionVisual.this.addModuleButtonActionPerformed(actionEvent);
            }
        });
        this.addModuleButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"ACSD_LBL_IW_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeModuleButton, (String)NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"LBL_IW_Remove"));
        this.removeModuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PanelModuleDetectionVisual.this.removeModuleButtonActionPerformed(actionEvent);
            }
        });
        this.removeModuleButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"ACSD_LBL_IW_Remove"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.appModulesLabel).add((Component)this.moduleSP, -1, 296, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.addModuleButton, -1, 83, Short.MAX_VALUE).add((Component)this.removeModuleButton))));
        groupLayout.linkSize(new Component[]{this.addModuleButton, this.removeModuleButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.appModulesLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addModuleButton).addPreferredGap(0).add((Component)this.removeModuleButton).addContainerGap()).add((Component)this.moduleSP, -1, 270, Short.MAX_VALUE))));
    }

    private void removeModuleButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.moduleTable.getSelectedRow();
        if (n != -1) {
            this.modules.remove(n);
            this.getModuleTableModel().fireTableRowsDeleted(n, n);
            this.changeSupport.fireChange();
        }
    }

    private void addModuleButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.eaLocation);
        jFileChooser.setFileSelectionMode(1);
        if (jFileChooser.showOpenDialog(this) == 0) {
            if (this.eaLocation.equals(jFileChooser.getSelectedFile())) {
                return;
            }
            this.addModuleToTable(jFileChooser.getSelectedFile());
            this.getModuleTableModel().fireTableDataChanged();
        }
    }

    private ModuleType getModuleType(String string) {
        ModuleType moduleType = null;
        File file = FileUtil.normalizeFile((File)new File(this.eaLocation, string));
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            moduleType = ModuleType.detectModuleType(fileObject);
        }
        return moduleType == null ? ModuleType.WEB : moduleType;
    }

    private class ModuleTypeEditor
    extends JComboBox
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        protected EventListenerList listenerList = new EventListenerList();
        protected ChangeEvent changeEvent = new ChangeEvent(this);

        ModuleTypeEditor() {
            for (ModuleType moduleType : ModuleType.values()) {
                this.addItem(moduleType.getDescription());
            }
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ModuleTypeEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listenerList.add(CellEditorListener.class, cellEditorListener);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listenerList.remove(CellEditorListener.class, cellEditorListener);
        }

        protected void fireEditingStopped() {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != CellEditorListener.class) continue;
                CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
                cellEditorListener.editingStopped(this.changeEvent);
            }
        }

        protected void fireEditingCanceled() {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != CellEditorListener.class) continue;
                CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
                cellEditorListener.editingCanceled(this.changeEvent);
            }
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return this.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = (String)object;
            this.setSelectedItem(string);
            return this;
        }
    }

    private static final class ModuleTypeRenderer
    extends JComboBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        ModuleTypeRenderer() {
            for (ModuleType moduleType : ModuleType.values()) {
                this.addItem(moduleType.getDescription());
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            String string = (String)object;
            this.setSelectedItem(string);
            return this;
        }
    }
}

