/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.grammar;

import java.awt.Component;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import org.apache.maven.project.MavenProject;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.spi.dom.AbstractNode;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Enumerations;
import org.openide.util.ImageUtilities;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class AbstractSchemaBasedGrammar
implements GrammarQuery {
    Document schemaDoc;
    private GrammarEnvironment environment;

    public AbstractSchemaBasedGrammar(GrammarEnvironment grammarEnvironment) {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            InputStream inputStream = this.getSchemaStream();
            this.schemaDoc = sAXBuilder.build(inputStream);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        this.environment = grammarEnvironment;
    }

    protected final GrammarEnvironment getEnvironment() {
        return this.environment;
    }

    protected final MavenProject getMavenProject() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.environment.getFileObject());
        if (project != null) {
            NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            assert (nbMavenProject != null);
            return nbMavenProject.getMavenProject();
        }
        ErrorManager.getDefault().log(16, "File " + this.environment.getFileObject() + " has maven2 code completion but doesn't belong to a maven2 project.");
        return null;
    }

    protected abstract InputStream getSchemaStream();

    protected List<GrammarResult> getDynamicCompletion(String string, HintContext hintContext, Element element) {
        return Collections.emptyList();
    }

    protected Enumeration<GrammarResult> getDynamicValueCompletion(String string, HintContext hintContext, Element element) {
        return null;
    }

    protected final Element findElement(Element element, String string) {
        List list = element.getChildren("element", element.getNamespace());
        for (Element element2 : list) {
            if (!string.equals(element2.getAttributeValue("name"))) continue;
            return element2;
        }
        return null;
    }

    protected final Element findNonTypedContent(Element element) {
        Element element2 = element.getChild("complexType", element.getNamespace());
        if (element2 != null) {
            element2 = element2.getChild("sequence", element.getNamespace());
        }
        return element2;
    }

    protected final Element findTypeContent(final String string, Element element) {
        List list = element.getContent(new Filter(){

            public boolean matches(Object object) {
                Element element;
                return object instanceof Element && "complexType".equals((element = (Element)object).getName()) && string.equals(element.getAttributeValue("name"));
            }
        });
        if (list.size() > 0) {
            Element element2 = (Element)list.get(0);
            return element2.getChild("all", element.getNamespace());
        }
        return null;
    }

    private void processElement(String string, Element element, Vector<GrammarResult> vector) {
        String string2 = element.getAttributeValue("ref");
        if (string2 == null) {
            string2 = element.getAttributeValue("name");
        }
        if (string2 != null && string2.startsWith(string)) {
            vector.add(new MyElement(string2));
        }
    }

    public Component getCustomizer(HintContext hintContext) {
        return null;
    }

    public Node.Property[] getProperties(HintContext hintContext) {
        return new Node.Property[0];
    }

    public boolean hasCustomizer(HintContext hintContext) {
        return false;
    }

    public boolean isAllowed(Enumeration enumeration) {
        return true;
    }

    protected final void processSequence(String string, Element element, Vector<GrammarResult> vector) {
        List list = element.getContent((Filter)new DefinitionContentElementFilter());
        for (Element element2 : list) {
            this.processElement(string, element2, vector);
        }
    }

    public Enumeration<GrammarResult> queryAttributes(HintContext hintContext) {
        return Enumerations.empty();
    }

    public GrammarResult queryDefault(HintContext hintContext) {
        return null;
    }

    public Enumeration<GrammarResult> queryElements(HintContext hintContext) {
        String string = hintContext.getCurrentPrefix();
        Node node = hintContext.getParentNode();
        boolean bl = false;
        if (node != null && this.schemaDoc != null) {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (node != null & node.getNodeName() != null) {
                arrayList.add(0, node.getNodeName());
                if (node.getParentNode() == null || node.getParentNode().getNodeName() == null) {
                    object = node.getAttributes();
                    bl = object.getNamedItemNS("xsi", "schemaLocation") != null;
                }
                node = node.getParentNode();
            }
            object = this.schemaDoc.getRootElement();
            Iterator iterator = arrayList.iterator();
            String string2 = "";
            Vector<GrammarResult> vector = new Vector<GrammarResult>();
            while (iterator.hasNext() && object != null) {
                String string3 = (String)iterator.next();
                string2 = string2 + "/" + string3;
                Element element = this.findElement((Element)object, string3);
                if (!iterator.hasNext()) {
                    vector.addAll(this.getDynamicCompletion(string2, hintContext, element));
                }
                if (element == null) continue;
                String string4 = element.getAttributeValue("type");
                if (string4 != null) {
                    object = this.findTypeContent(string4, this.schemaDoc.getRootElement());
                    if (object != null) continue;
                    System.err.println("no schema parent for " + string3 + " of type " + element.getAttributeValue("type"));
                    continue;
                }
                object = this.findNonTypedContent(element);
            }
            if (object != null && !bl) {
                this.processSequence(string, (Element)object, vector);
            }
            return vector.elements();
        }
        return Enumerations.empty();
    }

    public Enumeration<GrammarResult> queryEntities(String string) {
        return Enumerations.empty();
    }

    public Enumeration<GrammarResult> queryNotations(String string) {
        return Enumerations.empty();
    }

    public Enumeration<GrammarResult> queryValues(HintContext hintContext) {
        Node node = hintContext.getParentNode();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (hintContext.getCurrentPrefix().length() == 0) {
            arrayList.add(hintContext.getNodeName());
        }
        if (node != null && this.schemaDoc != null) {
            while (node != null & node.getNodeName() != null) {
                arrayList.add(0, node.getNodeName());
                node = node.getParentNode();
            }
            Element element = this.schemaDoc.getRootElement();
            Iterator iterator = arrayList.iterator();
            String string = "";
            while (iterator.hasNext() && element != null) {
                Object object;
                String string2 = (String)iterator.next();
                string = string + "/" + string2;
                Element element2 = this.findElement(element, string2);
                if (!iterator.hasNext() && (object = this.getDynamicValueCompletion(string, hintContext, element2)) != null) {
                    return object;
                }
                if (element2 != null) {
                    object = element2.getAttributeValue("type");
                    if (object != null) {
                        element = this.findTypeContent((String)object, this.schemaDoc.getRootElement());
                        if (element != null) continue;
                        System.err.println("no schema parent for " + string2 + " of type=" + element2.getAttributeValue("type"));
                        continue;
                    }
                    element = this.findNonTypedContent(element2);
                    continue;
                }
                System.err.println("cannot find element=" + string2);
            }
        }
        return Enumerations.empty();
    }

    protected final Enumeration<GrammarResult> createTextValueList(String[] stringArray, HintContext hintContext) {
        ArrayList<MyTextElement> arrayList = new ArrayList<MyTextElement>();
        for (String string : stringArray) {
            if (!string.startsWith(hintContext.getCurrentPrefix())) continue;
            arrayList.add(new MyTextElement(string, hintContext.getCurrentPrefix()));
        }
        return Collections.enumeration(arrayList);
    }

    protected static class ComplexElement
    extends AbstractResultNode
    implements org.w3c.dom.Element {
        private String name;
        private String display;
        private NodeList list;

        ComplexElement(String string, String string2, NodeList nodeList) {
            this.name = string;
            this.display = string2;
            this.list = nodeList;
        }

        @Override
        public short getNodeType() {
            return 1;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public String getTagName() {
            return this.name;
        }

        @Override
        public String getDisplayName() {
            return this.display;
        }

        @Override
        public NodeList getChildNodes() {
            return this.list;
        }

        @Override
        public boolean hasChildNodes() {
            return true;
        }

        @Override
        public Node getLastChild() {
            return this.list.item(this.list.getLength() - 1);
        }

        @Override
        public Node getFirstChild() {
            return this.list.item(0);
        }
    }

    public static class MyTextElement
    extends AbstractResultNode
    implements Text {
        private String name;
        private String prefix;

        public MyTextElement(String string, String string2) {
            this.name = string;
            this.prefix = string2;
            this.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/grammar/value.png", (boolean)false));
        }

        @Override
        public short getNodeType() {
            return 3;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        public String getTagName() {
            return this.name;
        }

        @Override
        public String getNodeValue() {
            return this.name.substring(this.prefix.length());
        }
    }

    protected static class MyElement
    extends AbstractResultNode
    implements org.w3c.dom.Element {
        private String name;

        MyElement(String string) {
            this.name = string;
            this.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/grammar/element.png", (boolean)false));
        }

        @Override
        public short getNodeType() {
            return 1;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public String getTagName() {
            return this.name;
        }
    }

    protected static abstract class AbstractResultNode
    extends AbstractNode
    implements GrammarResult {
        private String desc;
        private Icon icon;

        protected AbstractResultNode() {
        }

        public Icon getIcon(int n) {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String string) {
            this.desc = string;
        }

        public String getText() {
            return this.getNodeName();
        }

        public String getDisplayName() {
            return this.getNodeName();
        }

        public boolean isEmptyElement() {
            return false;
        }
    }

    private class DefinitionContentElementFilter
    extends ElementFilter {
        public boolean matches(Object object) {
            boolean bl = super.matches(object);
            if (bl) {
                Element element = (Element)object;
                bl = false;
                if ("element".equals(element.getName()) || "group".equals(element.getName())) {
                    bl = true;
                }
            }
            return bl;
        }
    }
}

