/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.maven.codegen.NewMirrorPanel;
import org.netbeans.modules.maven.model.settings.Mirror;
import org.netbeans.modules.maven.model.settings.SettingsModel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.w3c.dom.Node;

public class MirrorGenerator
implements CodeGenerator {
    private SettingsModel model;
    private JTextComponent component;

    private MirrorGenerator(SettingsModel model, JTextComponent component) {
        this.model = model;
        this.component = component;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(MirrorGenerator.class, (String)"NAME_Mirror");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        try {
            this.model.sync();
        }
        catch (IOException ex) {
            Logger.getLogger(MirrorGenerator.class.getName()).log(Level.INFO, "Error while syncing the editor document with model for pom.xml file", ex);
        }
        if (!this.model.getState().equals((Object)Model.State.VALID)) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(MirrorGenerator.class, (String)"MSG_Cannot_Parse"));
            return;
        }
        NewMirrorPanel panel = new NewMirrorPanel(this.model);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(MirrorGenerator.class, (String)"TIT_Add_mirror"));
        panel.attachDialogDisplayer(dd);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (ret == DialogDescriptor.OK_OPTION) {
            String id = panel.getMirrorId();
            Mirror mirror = this.model.getSettings().findMirrorById(id);
            if (mirror == null) {
                try {
                    this.model.startTransaction();
                    mirror = this.model.getFactory().createMirror();
                    mirror.setId(id);
                    mirror.setUrl(panel.getMirrorUrl());
                    mirror.setMirrorOf(panel.getMirrorOf());
                    this.model.getSettings().addMirror(mirror);
                }
                finally {
                    this.model.endTransaction();
                }
                int pos = mirror.getModel().getAccess().findPosition((Node)mirror.getPeer());
                this.component.setCaretPosition(pos);
            }
        }
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<MirrorGenerator> toRet = new ArrayList<MirrorGenerator>();
            SettingsModel model = (SettingsModel)context.lookup(SettingsModel.class);
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            if (model != null) {
                toRet.add(new MirrorGenerator(model, component));
            }
            return toRet;
        }
    }
}

