/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.vmd.api.codegen.CodeSetterPresenter;
import org.netbeans.modules.vmd.api.codegen.MultiGuardedSection;
import org.netbeans.modules.vmd.api.codegen.Parameter;
import org.netbeans.modules.vmd.api.codegen.Setter;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;

public final class InitCodeGenerator {
    private static final int PRICE_OF_REQUIRED_PARAM = 3;
    private static final int PRICE_OF_DEFAULT_PARAM = -1;

    public static void generateInitializationCode(MultiGuardedSection section, DesignComponent component) {
        Collection presenters = component.getPresenters(CodeSetterPresenter.class);
        HashMap<String, Parameter> parametersMap = new HashMap<String, Parameter>();
        ArrayList<Setter> constructors = new ArrayList<Setter>();
        ArrayList<Setter> setters = new ArrayList<Setter>();
        HashSet<String> requiredToBeSet = new HashSet<String>();
        parametersMap.put("#INDEX#", Parameter.INDEX);
        for (CodeSetterPresenter presenter : presenters) {
            for (Parameter parameter : presenter.getParameters()) {
                String parameterName = parameter.getParameterName();
                assert (parameterName != null);
                Parameter currentParameter = (Parameter)parametersMap.get(parameterName);
                if (currentParameter != null) {
                    int priority;
                    int currentPriority = currentParameter.getParameterPriority();
                    if (currentPriority >= (priority = parameter.getParameterPriority())) {
                        if (currentPriority != priority) continue;
                        Debug.warning((Object[])new Object[]{"Duplicate parameter found", component, parameterName});
                        continue;
                    }
                    requiredToBeSet.remove(parameterName);
                }
                parametersMap.put(parameterName, parameter);
                if (!parameter.isRequiredToBeSet(component)) continue;
                requiredToBeSet.add(parameterName);
            }
            for (Setter setter : presenter.getSetters()) {
                if (!setter.getVersionable().isAvailable(component.getDocument())) continue;
                if (setter.isConstructor()) {
                    if (!component.getType().equals((Object)setter.getConstructorRelatedTypeID())) continue;
                    constructors.add(setter);
                    continue;
                }
                setters.add(setter);
            }
        }
        HashSet unusedParameters = new HashSet(parametersMap.keySet());
        for (Setter setter : constructors) {
            for (String parameter : setter.getParameters()) {
                unusedParameters.remove(parameter);
                if (parametersMap.containsKey(parameter)) continue;
                Debug.warning((Object[])new Object[]{"No setter parameter found", component, setter.getSetterName(), parameter});
            }
        }
        for (Setter setter : setters) {
            for (String parameter : setter.getParameters()) {
                unusedParameters.remove(parameter);
                if (parametersMap.containsKey(parameter)) continue;
                Debug.warning((Object[])new Object[]{"No setter parameter found", component, setter.getSetterName(), parameter});
            }
        }
        unusedParameters.remove("#INDEX#");
        if (!unusedParameters.isEmpty()) {
            Debug.warning((Object[])new Object[]{"Unused parameters", component, unusedParameters});
        }
        Collections.sort(constructors, new SetterComparator());
        Setter setter = InitCodeGenerator.findSetter(constructors, requiredToBeSet, false);
        if (setter != null) {
            do {
                for (String string : setter.getParameters()) {
                    requiredToBeSet.remove(string);
                }
                setter.generateSetterCode(section, component, parametersMap);
            } while ((setter = InitCodeGenerator.findSetter(setters, requiredToBeSet, true)) != null && !setter.getParameters().isEmpty());
        }
    }

    private static Setter findSetter(ArrayList<Setter> setters, HashSet<String> requiredToBeSet, boolean mustUseChangedProperty) {
        Setter bestSetter = null;
        int bestPrice = Integer.MIN_VALUE;
        for (Setter setter : setters) {
            boolean usesChangedProperty = false;
            int price = 0;
            for (String parameterName : setter.getParameters()) {
                if (requiredToBeSet.contains(parameterName)) {
                    price += 3;
                    usesChangedProperty = true;
                } else {
                    --price;
                }
                price += setter.getPriority();
            }
            if (mustUseChangedProperty && !usesChangedProperty || price <= bestPrice) continue;
            bestSetter = setter;
            bestPrice = price;
        }
        return bestSetter;
    }

    private static int compareStrings(String s1, String s2) {
        if (s1 != null) {
            return s2 != null ? s1.compareTo(s2) : 1;
        }
        return s2 != null ? -1 : 0;
    }

    private static class SetterComparator
    implements Comparator<Setter> {
        private SetterComparator() {
        }

        @Override
        public int compare(Setter setter1, Setter setter2) {
            List<String> params2;
            List<String> params1 = setter1.getParameters();
            int diff = (params1 != null ? params1.size() : 0) - ((params2 = setter2.getParameters()) != null ? params2.size() : 0);
            if (diff != 0) {
                return diff;
            }
            diff = InitCodeGenerator.compareStrings(setter1.getSetterName(), setter2.getSetterName());
            if (diff != 0) {
                return diff;
            }
            if (params1 != null && params2 != null) {
                for (int a = 0; a < params1.size(); ++a) {
                    diff = InitCodeGenerator.compareStrings(params1.get(a), params2.get(a));
                    if (diff == 0) continue;
                    return diff;
                }
            }
            return 0;
        }
    }
}

