/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import org.jrubyparser.ast.Node;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;

public abstract class RubyHints {
    private static final String RAILS_PROJECT = "RailsProject";

    private RubyHints() {
    }

    static boolean isNullOrInvisible(Node node) {
        return node == null || node.isInvisible();
    }

    static boolean isInRailsProject(FileObject file) {
        return RubyHints.isRailsProject(FileOwnerQuery.getOwner((FileObject)file));
    }

    static boolean isInRails3Project(FileObject file) {
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (!RubyHints.isRailsProject(project)) {
            return false;
        }
        FileObject railsScript = project.getProjectDirectory().getFileObject("script/rails");
        return railsScript != null && railsScript.isValid();
    }

    private static boolean isRailsProject(Project project) {
        return project != null && project.getClass().getName().indexOf(RAILS_PROJECT) != -1;
    }
}

