/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jrubyparser.ast.ConstDeclNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

public class ConstantNames
extends RubyAstRule {
    public boolean appliesTo(RuleContext context) {
        return true;
    }

    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.CONSTDECLNODE);
    }

    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        Node node = context.node;
        ParserResult info = context.parserResult;
        assert (node.getNodeType() == NodeType.CONSTDECLNODE);
        String name = ((ConstDeclNode)node).getName();
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isLowerCase(name.charAt(i))) continue;
            String displayName = NbBundle.getMessage(ConstantNames.class, (String)"InvalidConstantName");
            OffsetRange range = AstUtilities.getNameRange((Node)node);
            if ((range = LexUtilities.getLexerOffsets((Parser.Result)info, (OffsetRange)range)) != OffsetRange.NONE) {
                List fixList = Collections.emptyList();
                Hint desc = new Hint((Rule)this, displayName, RubyUtils.getFileObject((Parser.Result)info), range, fixList, 1600);
                result.add(desc);
            }
            return;
        }
    }

    public String getId() {
        return "Constant_Names";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ConstantNames.class, (String)"ConstantNameWarning");
    }

    public String getDescription() {
        return NbBundle.getMessage(ConstantNames.class, (String)"ConstantNameWarningDesc");
    }

    public boolean getDefaultEnabled() {
        return false;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public boolean showInTasklist() {
        return true;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }
}

