/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.jrubyparser.IRubyWarnings;
import org.jrubyparser.lexer.SyntaxException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.RubyParser;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyErrorRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CommonSyntaxErrors
extends RubyErrorRule {
    @Override
    public Set<IRubyWarnings.ID> getCodes() {
        return Collections.singleton(IRubyWarnings.ID.SYNTAX_ERROR);
    }

    @Override
    public void run(RubyRuleContext context, RubyParser.RubyError error, List<Hint> result) {
        ParserResult info = context.parserResult;
        SyntaxException.PID pid = (SyntaxException.PID)error.getParameters()[0];
        if (pid != SyntaxException.PID.GRAMMAR_ERROR) {
            return;
        }
        String message = error.getDisplayName();
        if (message.indexOf("'='") == -1) {
            return;
        }
        try {
            BaseDocument doc = context.doc;
            int astOffset = error.getStartPosition();
            int lexOffset = LexUtilities.getLexerOffset((Parser.Result)info, (int)astOffset);
            if (lexOffset == -1) {
                return;
            }
            if (lexOffset < doc.getLength() - "begin".length() && "begin".equals(doc.getText(lexOffset, "begin".length()))) {
                OffsetRange range = new OffsetRange(lexOffset - 1, lexOffset + "=begin".length());
                FixDocIndent fix = new FixDocIndent(context, lexOffset - 1);
                List<FixDocIndent> fixList = Collections.singletonList(fix);
                String displayName = NbBundle.getMessage(CommonSyntaxErrors.class, (String)"DontIndentDocs");
                Hint desc = new Hint((Rule)this, displayName, RubyUtils.getFileObject((Parser.Result)info), range, fixList, 500);
                result.add(desc);
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean appliesTo(RuleContext context) {
        return true;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(CommonSyntaxErrors.class, (String)"CommonSyntaxErrorsHint");
    }

    public String getId() {
        return "CommonSyntaxErrors";
    }

    public String getDescription() {
        return "";
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    public boolean showInTasklist() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.ERROR;
    }

    private class FixDocIndent
    implements PreviewableFix {
        private final RubyRuleContext context;
        private final int equalOffset;

        private FixDocIndent(RubyRuleContext context, int equalOffset) {
            this.context = context;
            this.equalOffset = equalOffset;
        }

        public String getDescription() {
            return NbBundle.getMessage(CommonSyntaxErrors.class, (String)"ReindentBegin");
        }

        public void implement() throws Exception {
            this.getEditList().apply();
        }

        public EditList getEditList() throws Exception {
            int beginIndex;
            String text;
            int index;
            BaseDocument doc = this.context.doc;
            if (this.equalOffset > doc.getLength()) {
                return null;
            }
            EditList edits = new EditList(doc);
            int rowStart = Utilities.getRowStart((BaseDocument)doc, (int)this.equalOffset);
            if (Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)this.equalOffset) < this.equalOffset) {
                edits.replace(this.equalOffset, 0, "\n", false, 0);
            } else {
                edits.replace(rowStart, this.equalOffset - rowStart, null, false, 0);
            }
            int nextRow = Utilities.getRowEnd((BaseDocument)doc, (int)rowStart) + 1;
            if (nextRow < doc.getLength() && (index = (text = doc.getText(nextRow, doc.getLength() - nextRow)).indexOf("=end")) != -1 && (index < (beginIndex = text.indexOf("=begin")) || beginIndex == -1)) {
                int offset = nextRow + index;
                rowStart = Utilities.getRowStart((BaseDocument)doc, (int)offset);
                if (Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset) < offset) {
                    edits.replace(offset, 0, "\n", false, 1);
                } else {
                    edits.replace(rowStart, offset - rowStart, null, false, 1);
                }
            }
            return edits;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

