/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.server;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.gems.GemInfo;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.railsprojects.server.GlassFishGem;
import org.netbeans.modules.ruby.railsprojects.server.Mongrel;
import org.netbeans.modules.ruby.railsprojects.server.Passenger;
import org.netbeans.modules.ruby.railsprojects.server.RubyServer;
import org.netbeans.modules.ruby.railsprojects.server.ServerInstanceProviderImpl;
import org.netbeans.modules.ruby.railsprojects.server.WEBrick;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstanceProvider;
import org.openide.util.lookup.Lookups;

public class ServerRegistry
implements VetoableChangeListener {
    private static ServerRegistry defaultRegistry;
    private static boolean ENABLE_PASSENGER;

    private ServerRegistry() {
    }

    public static synchronized ServerRegistry getDefault() {
        if (defaultRegistry == null) {
            defaultRegistry = new ServerRegistry();
            RubyPlatformManager.addVetoableChangeListener((VetoableChangeListener)defaultRegistry);
        }
        return defaultRegistry;
    }

    public List<RubyInstance> getServers() {
        ArrayList<RubyInstance> result = new ArrayList<RubyInstance>();
        for (RubyInstanceProvider provider : Lookups.forPath((String)"Servers/Ruby").lookupAll(RubyInstanceProvider.class)) {
            result.addAll(provider.getInstances());
        }
        result.addAll(this.getRubyServers());
        return result;
    }

    List<RubyInstance> getServers(RubyPlatform platform) {
        ArrayList<RubyInstance> result = new ArrayList<RubyInstance>();
        for (RubyInstance each : this.getServers()) {
            if (!each.isPlatformSupported(platform)) continue;
            result.add(each);
        }
        return result;
    }

    List<RubyServer> getRubyServers() {
        ArrayList<RubyServer> result = new ArrayList<RubyServer>();
        for (RubyPlatform each : RubyPlatformManager.getPlatforms()) {
            result.addAll(RubyServerFactory.getInstance(each).getServers());
        }
        return result;
    }

    public RubyInstance getServer(String serverId, RubyPlatform platform) {
        for (RubyInstanceProvider provider : Lookups.forPath((String)"Servers/Ruby").lookupAll(RubyInstanceProvider.class)) {
            RubyInstance instance = provider.getInstance(serverId);
            if (instance == null || !instance.isPlatformSupported(platform)) continue;
            return instance;
        }
        for (RubyServer each : RubyServerFactory.getInstance(platform).getServers()) {
            if (!each.getServerUri().equals(serverId) || !each.isPlatformSupported(platform)) continue;
            return each;
        }
        return null;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (evt.getPropertyName().equals("platforms")) {
            ServerInstanceProviderImpl.getInstance().fireServersChanged();
        }
    }

    static {
        ENABLE_PASSENGER = Boolean.getBoolean("passenger.support");
    }

    static class ServerComparator
    implements Comparator<RubyServer> {
        ServerComparator() {
        }

        @Override
        public int compare(RubyServer o1, RubyServer o2) {
            if (o1.getClass().equals(o2.getClass())) {
                return o2.getDisplayName().compareTo(o1.getDisplayName());
            }
            if (o1 instanceof GlassFishGem) {
                return -1;
            }
            if (o2 instanceof GlassFishGem) {
                return 1;
            }
            if (o1 instanceof Mongrel) {
                return -1;
            }
            return 1;
        }
    }

    private static class RubyServerFactory
    implements PropertyChangeListener {
        private static final Map<RubyPlatform, RubyServerFactory> instances = new HashMap<RubyPlatform, RubyServerFactory>();
        private final RubyPlatform platform;
        private final List<RubyServer> servers = new ArrayList<RubyServer>();

        private RubyServerFactory(RubyPlatform platform) {
            this.platform = platform;
        }

        public static synchronized RubyServerFactory getInstance(RubyPlatform platform) {
            RubyServerFactory existing = instances.get(platform);
            if (existing != null) {
                return existing;
            }
            RubyServerFactory result = new RubyServerFactory(platform);
            result.initGlassFish();
            result.initMongrel();
            result.initWEBrick();
            if (ENABLE_PASSENGER) {
                result.initPassenger();
            }
            platform.addPropertyChangeListener((PropertyChangeListener)result);
            instances.put(platform, result);
            return result;
        }

        public List<RubyServer> getServers() {
            Collections.sort(this.servers, new ServerComparator());
            return Collections.unmodifiableList(this.servers);
        }

        private void initGlassFish() {
            if (this.platform.isJRuby()) {
                GemInfo glassFishGemInfo;
                GemManager gemManager = this.platform.getGemManager();
                if (gemManager == null) {
                    return;
                }
                List versions = gemManager.getVersions("glassfish");
                GemInfo gemInfo = glassFishGemInfo = versions.isEmpty() ? null : (GemInfo)versions.get(0);
                if (glassFishGemInfo == null) {
                    Iterator<RubyServer> it = this.servers.iterator();
                    while (it.hasNext()) {
                        if (!(it.next() instanceof GlassFishGem)) continue;
                        it.remove();
                    }
                    return;
                }
                GlassFishGem candidate = new GlassFishGem(this.platform, glassFishGemInfo);
                if (!this.servers.contains(candidate)) {
                    this.servers.add(candidate);
                }
            }
        }

        private void initMongrel() {
            GemManager gemManager = this.platform.getGemManager();
            if (gemManager == null) {
                return;
            }
            String mongrelVersion = gemManager.getLatestVersion("mongrel");
            if (mongrelVersion == null) {
                Iterator<RubyServer> it = this.servers.iterator();
                while (it.hasNext()) {
                    if (!(it.next() instanceof Mongrel)) continue;
                    it.remove();
                }
                return;
            }
            Mongrel candidate = new Mongrel(this.platform, mongrelVersion);
            if (!this.servers.contains(candidate)) {
                this.servers.add(candidate);
            }
        }

        private void initWEBrick() {
            WEBrick candidate = new WEBrick(this.platform);
            if (!this.servers.contains(candidate)) {
                this.servers.add(candidate);
            }
        }

        private void initPassenger() {
            GemManager gemManager = this.platform.getGemManager();
            if (gemManager == null) {
                return;
            }
            String passengerVersion = gemManager.getLatestVersion("passenger");
            if (passengerVersion == null) {
                Iterator<RubyServer> it = this.servers.iterator();
                while (it.hasNext()) {
                    if (!(it.next() instanceof Passenger)) continue;
                    it.remove();
                }
                return;
            }
            Passenger candidate = new Passenger(this.platform, passengerVersion);
            if (!this.servers.contains(candidate)) {
                this.servers.add(candidate);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("gems")) {
                this.initGlassFish();
                this.initMongrel();
                this.initWEBrick();
                ServerInstanceProviderImpl.getInstance().fireServersChanged();
            }
        }
    }
}

