/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.plugins;

import java.awt.Dialog;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.RailsProjectUtil;
import org.netbeans.modules.ruby.railsprojects.plugins.PluginManager;
import org.netbeans.modules.ruby.railsprojects.plugins.PluginPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class PluginAction
extends NodeAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] activatedNodes) {
        Lookup lookup = activatedNodes[0].getLookup();
        Project p = (Project)lookup.lookup(Project.class);
        if (!RubyPlatform.platformFor((Project)p).showWarningIfInvalid()) {
            return;
        }
        RailsProject project = (RailsProject)p;
        PluginManager manager = new PluginManager(project);
        String pluginProblem = manager.getPluginProblem();
        if (pluginProblem != null) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)pluginProblem, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return;
        }
        PluginPanel customizer = new PluginPanel(manager);
        JButton close = new JButton(NbBundle.getMessage(PluginAction.class, (String)"CTL_Close"));
        close.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginAction.class, (String)"AD_Close"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)customizer, NbBundle.getMessage(PluginAction.class, (String)"CTL_PluginTitle"), true, new Object[]{close}, (Object)close, 0, new HelpCtx(PluginPanel.class), null);
        Dialog dlg = null;
        try {
            dlg = DialogDisplayer.getDefault().createDialog(descriptor);
            dlg.setVisible(true);
        }
        finally {
            if (dlg != null) {
                dlg.dispose();
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        Lookup lookup = activatedNodes[0].getLookup();
        Project project = (Project)lookup.lookup(Project.class);
        return project instanceof RailsProject && !RailsProjectUtil.getRailsVersion(project).isRails3OrHigher();
    }

    public String getName() {
        return NbBundle.getMessage(PluginAction.class, (String)"CTL_PluginAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return true;
    }
}

