/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.netbeans.modules.spellchecker.spi.dictionary.Dictionary;
import org.netbeans.modules.spellchecker.spi.dictionary.ValidityType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrieDictionary
implements Dictionary {
    private byte[] array;
    private ByteBuffer buffer;
    private static final int CURRENT_TRIE_DICTIONARY_VERSION = 1;
    private static final File CACHE_DIR = new File(new File(new File(System.getProperty("netbeans.user"), "var"), "cache"), "dict");

    TrieDictionary(byte[] array) {
        this.array = array;
        this.buffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrieDictionary(File data) throws IOException {
        this.array = null;
        FileInputStream ins = new FileInputStream(data);
        FileChannel channel = ins.getChannel();
        try {
            this.buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        }
        finally {
            channel.close();
            ins.close();
        }
    }

    public ValidityType validateWord(CharSequence word) {
        String wordString = ((Object)word).toString();
        ValidityType type = this.validateWordImpl(wordString.toLowerCase());
        if (type != ValidityType.VALID) {
            ValidityType curr = this.validateWordImpl(wordString);
            if (type == ValidityType.PREFIX_OF_VALID) {
                if (curr == ValidityType.VALID) {
                    type = curr;
                }
            } else {
                type = curr;
            }
        }
        return type;
    }

    private ValidityType validateWordImpl(CharSequence word) {
        int node = this.findNode(word, 0, 4);
        if (node == -1) {
            return ValidityType.INVALID;
        }
        if (this.readByte(node) == 1) {
            return ValidityType.VALID;
        }
        return ValidityType.PREFIX_OF_VALID;
    }

    public List<String> findValidWordsForPrefix(CharSequence word) {
        ArrayList<String> result = new ArrayList<String>();
        int node = this.findNode(word, 0, 4);
        if (node == -1) {
            return Collections.emptyList();
        }
        return this.findValidWordsForPrefix(new StringBuffer(word), node, result);
    }

    public List<String> findProposals(CharSequence pattern) {
        ArrayList<String> result = new ArrayList<String>();
        return this.findProposals(pattern, 2, 4, new StringBuffer(), result);
    }

    private List<String> findProposals(CharSequence pattern, int maxDistance, int node, StringBuffer word, List<String> result) {
        int entries = this.readInt(node + 1);
        for (int currentEntry = 0; currentEntry < entries; ++currentEntry) {
            char ac = this.readChar(node + 5 + currentEntry * 6);
            word.append(ac);
            int distance = TrieDictionary.distance(pattern, word);
            int targetNode = node + this.readInt(node + 5 + currentEntry * 6 + 2);
            if (distance < maxDistance && this.readByte(targetNode) == 1) {
                result.add(word.toString());
            }
            if (distance - (pattern.length() - word.length()) < maxDistance) {
                this.findProposals(pattern, maxDistance, targetNode, word, result);
            }
            word.deleteCharAt(word.length() - 1);
        }
        return result;
    }

    private List<String> findValidWordsForPrefix(StringBuffer foundSoFar, int node, List<String> result) {
        int entries = this.readInt(node + 1);
        for (int currentEntry = 0; currentEntry < entries; ++currentEntry) {
            char ac = this.readChar(node + 5 + currentEntry * 6);
            foundSoFar.append(ac);
            int targetNode = node + this.readInt(node + 5 + currentEntry * 6 + 2);
            if (this.readByte(targetNode) == 1) {
                result.add(foundSoFar.toString());
            }
            this.findValidWordsForPrefix(foundSoFar, targetNode, result);
            foundSoFar.deleteCharAt(foundSoFar.length() - 1);
        }
        return result;
    }

    private int findNode(CharSequence word, int currentCharOffset, int currentNode) {
        if (word.length() <= currentCharOffset) {
            return currentNode;
        }
        char c = word.charAt(currentCharOffset);
        int entries = this.readInt(currentNode + 1);
        for (int currentEntry = 0; currentEntry < entries; ++currentEntry) {
            char ac = this.readChar(currentNode + 5 + currentEntry * 6);
            if (ac != c) continue;
            int newNodeOffset = this.readInt(currentNode + 5 + currentEntry * 6 + 2);
            int newNode = currentNode + newNodeOffset;
            return this.findNode(word, currentCharOffset + 1, newNode);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dictionary getDictionary(String suffix, List<URL> sources) throws IOException {
        File trie = new File(CACHE_DIR, "dictionary" + suffix + ".trie" + 1);
        if (!trie.exists()) {
            byte[] array = TrieDictionary.constructTrie(sources);
            trie.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(trie);
            try {
                ((OutputStream)out).write(array);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        return new TrieDictionary(trie);
    }

    private static int toUnsigned(byte b) {
        if (b < 0) {
            return 256 + b;
        }
        return b;
    }

    private int readInt(int pos) {
        return (TrieDictionary.toUnsigned(this.readByte(pos + 0)) << 24) + (TrieDictionary.toUnsigned(this.readByte(pos + 1)) << 16) + (TrieDictionary.toUnsigned(this.readByte(pos + 2)) << 8) + TrieDictionary.toUnsigned(this.readByte(pos + 3));
    }

    private char readChar(int pos) {
        return (char)((TrieDictionary.toUnsigned(this.readByte(pos + 0)) << 8) + TrieDictionary.toUnsigned(this.readByte(pos + 1)));
    }

    private byte readByte(int pos) {
        if (this.buffer != null) {
            return this.buffer.get(pos);
        }
        return this.array[pos];
    }

    private static boolean compareChars(char c1, char c2) {
        return c1 == c2 || Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    private static int distance(CharSequence pattern, CharSequence word) {
        int[] old = new int[pattern.length() + 1];
        int[] current = new int[pattern.length() + 1];
        int[] oldLength = new int[pattern.length() + 1];
        int[] length = new int[pattern.length() + 1];
        for (int cntr = 0; cntr < old.length; ++cntr) {
            old[cntr] = pattern.length() + 1;
            oldLength[cntr] = -1;
        }
        length[0] = 0;
        oldLength[0] = 0;
        old[0] = 0;
        current[0] = 0;
        for (int currentIndex = 0; currentIndex < word.length(); ++currentIndex) {
            for (int cntr = 0; cntr < pattern.length(); ++cntr) {
                int insert = old[cntr + 1] + 1;
                int delete = current[cntr] + 1;
                int replace = old[cntr] + (TrieDictionary.compareChars(pattern.charAt(cntr), word.charAt(currentIndex)) ? 0 : 1);
                if (insert < delete) {
                    if (insert < replace) {
                        current[cntr + 1] = insert;
                        length[cntr + 1] = oldLength[cntr + 1] + 1;
                        continue;
                    }
                    current[cntr + 1] = replace;
                    length[cntr + 1] = oldLength[cntr] + 1;
                    continue;
                }
                if (delete < replace) {
                    current[cntr + 1] = delete;
                    length[cntr + 1] = length[cntr];
                    continue;
                }
                current[cntr + 1] = replace;
                length[cntr + 1] = oldLength[cntr] + 1;
            }
            int[] temp = old;
            old = current;
            current = temp;
            temp = oldLength;
            oldLength = length;
            length = temp;
        }
        return old[pattern.length()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] constructTrie(List<URL> sources) throws IOException {
        TreeSet<String> data = new TreeSet<String>();
        for (URL u : sources) {
            BufferedReader in = new BufferedReader(new InputStreamReader(u.openStream(), "UTF-8"));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    data.add(line);
                }
            }
            finally {
                in.close();
            }
        }
        return TrieDictionary.constructTrieData(data);
    }

    public static byte[] constructTrieData(SortedSet<String> data) throws IOException {
        ByteArray array = new ByteArray();
        array.put(0, 1);
        int length = TrieDictionary.encodeOneLayer(array, 4, 0, data);
        byte[] result = new byte[length];
        System.arraycopy(array.data, 0, result, 0, length);
        return result;
    }

    public static TrieDictionary constructTrie(SortedSet<String> data) throws IOException {
        return new TrieDictionary(TrieDictionary.constructTrieData(data));
    }

    private static int encodeOneLayer(ByteArray array, int currentPointer, int currentChar, SortedSet<String> data) {
        TreeMap<Character, TreeSet<String>> char2Words = new TreeMap<Character, TreeSet<String>>();
        boolean representsFullWord = !data.isEmpty() && data.first().length() <= currentChar;
        Iterator dataIt = data.iterator();
        if (representsFullWord) {
            dataIt.next();
        }
        while (dataIt.hasNext()) {
            String word = (String)dataIt.next();
            char c = word.charAt(currentChar);
            TreeSet<String> words = (TreeSet<String>)char2Words.get(Character.valueOf(c));
            if (words == null) {
                words = new TreeSet<String>();
                char2Words.put(Character.valueOf(c), words);
            }
            words.add(word);
        }
        int entries = char2Words.size();
        byte flags = 0;
        if (representsFullWord) {
            flags = 1;
        }
        array.put(currentPointer, flags);
        array.put(currentPointer + 1, entries);
        int currentEntry = 0;
        int childPointer = currentPointer + 5 + entries * 6;
        for (Map.Entry e : char2Words.entrySet()) {
            array.put(currentPointer + 5 + currentEntry * 6, ((Character)e.getKey()).charValue());
            array.put(currentPointer + 5 + currentEntry * 6 + 2, childPointer - currentPointer);
            childPointer = TrieDictionary.encodeOneLayer(array, childPointer, currentChar + 1, (SortedSet)e.getValue());
            ++currentEntry;
        }
        return childPointer;
    }

    private static class ByteArray {
        byte[] data = new byte[0];

        private ByteArray() {
        }

        private void assureCapacity(int size) {
            if (this.data.length < size) {
                byte[] newData = new byte[size + 0x100000];
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
                this.data = newData;
            }
        }

        public void put(int pos, char what) {
            this.assureCapacity(pos + 2);
            char whatInt = what;
            this.data[pos] = (byte)(whatInt >> 8);
            this.data[pos + 1] = (byte)(whatInt & 0xFF);
        }

        public void put(int pos, byte what) {
            this.assureCapacity(pos + 1);
            this.data[pos] = what;
        }

        public void put(int pos, int what) {
            this.assureCapacity(pos + 4);
            this.data[pos + 0] = (byte)(what >> 24 & 0xFF);
            this.data[pos + 1] = (byte)(what >> 16 & 0xFF);
            this.data[pos + 2] = (byte)(what >> 8 & 0xFF);
            this.data[pos + 3] = (byte)(what >> 0 & 0xFF);
        }
    }
}

