/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsfret.source.parsing.FileObjects;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceTaskFactoryManager;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public abstract class SourceTaskFactory {
    private static final Logger LOG = Logger.getLogger(SourceTaskFactory.class.getName());
    static final String BEFORE_ADDING_REMOVING_TASKS = "beforeAddingRemovingTasks";
    static final String FILEOBJECTS_COMPUTATION = "fileObjectsComputation";
    private final Phase phase;
    private final Source.Priority priority;
    static boolean SYNCHRONOUS_EVENTS = false;
    private final Map<FileObject, CancellableTask<CompilationInfo>> file2Task;
    private final Map<FileObject, Source> file2JS;
    private static RequestProcessor WORKER = new RequestProcessor("SourceTaskFactory", 1);
    static Accessor2 ACCESSOR2;

    protected SourceTaskFactory(Phase phase, Source.Priority priority) {
        this.phase = phase;
        this.priority = priority;
        this.file2Task = new HashMap<FileObject, CancellableTask<CompilationInfo>>();
        this.file2JS = new HashMap<FileObject, Source>();
    }

    protected abstract CancellableTask<CompilationInfo> createTask(FileObject var1);

    protected abstract Collection<FileObject> getFileObjects();

    protected final void fileObjectsChanged() {
        LOG.log(Level.FINEST, FILEOBJECTS_COMPUTATION);
        final ArrayList<FileObject> currentFiles = new ArrayList<FileObject>(this.getFileObjects());
        if (SYNCHRONOUS_EVENTS) {
            this.stateChangedImpl(currentFiles);
        } else {
            WORKER.post(new Runnable(){

                @Override
                public void run() {
                    SourceTaskFactory.this.stateChangedImpl(currentFiles);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stateChangedImpl(List<FileObject> currentFiles) {
        HashMap<Source, CancellableTask<CompilationInfo>> toRemove = new HashMap<Source, CancellableTask<CompilationInfo>>();
        HashMap<Source, CancellableTask<CompilationInfo>> toAdd = new HashMap<Source, CancellableTask<CompilationInfo>>();
        SourceTaskFactory sourceTaskFactory = this;
        synchronized (sourceTaskFactory) {
            ArrayList<FileObject> addedFiles = new ArrayList<FileObject>(currentFiles);
            ArrayList<FileObject> removedFiles = new ArrayList<FileObject>(this.file2Task.keySet());
            addedFiles.removeAll(this.file2Task.keySet());
            removedFiles.removeAll(currentFiles);
            for (FileObject r : removedFiles) {
                Source source = this.file2JS.remove(r);
                if (source == null) continue;
                toRemove.put(source, this.file2Task.remove(r));
            }
            for (FileObject a : addedFiles) {
                Source js;
                if (a == null || !a.isValid() || (js = Source.forFileObject(a)) == null) continue;
                CancellableTask<CompilationInfo> task = this.createTask(a);
                toAdd.put(js, task);
                this.file2Task.put(a, task);
                this.file2JS.put(a, js);
            }
        }
        LOG.log(Level.FINEST, BEFORE_ADDING_REMOVING_TASKS);
        for (Map.Entry e : toRemove.entrySet()) {
            ACCESSOR2.removePhaseCompletionTask((Source)e.getKey(), (CancellableTask<CompilationInfo>)((CancellableTask)e.getValue()));
        }
        for (Map.Entry e : toAdd.entrySet()) {
            try {
                ACCESSOR2.addPhaseCompletionTask((Source)e.getKey(), (CancellableTask<CompilationInfo>)((CancellableTask)e.getValue()), this.phase, this.priority);
            }
            catch (FileObjects.InvalidFileException ie) {
                LOG.info("Source.addPhaseCompletionTask called on deleted file");
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    protected final synchronized void reschedule(FileObject file) throws IllegalArgumentException {
        Source source = this.file2JS.get(file);
        if (source == null) {
            return;
        }
        CancellableTask<CompilationInfo> task = this.file2Task.get(file);
        if (task == null) {
            return;
        }
        ACCESSOR2.rescheduleTask(source, task);
    }

    static {
        SourceTaskFactoryManager.ACCESSOR = new SourceTaskFactoryManager.Accessor(){

            @Override
            public void fireChangeEvent(SourceTaskFactory f) {
                f.fileObjectsChanged();
            }
        };
        ACCESSOR2 = new Accessor2(){

            @Override
            public void addPhaseCompletionTask(Source js, CancellableTask<CompilationInfo> task, Phase phase, Source.Priority priority) throws IOException {
                js.addPhaseCompletionTask(task, phase, priority);
            }

            @Override
            public void removePhaseCompletionTask(Source js, CancellableTask<CompilationInfo> task) {
                js.removePhaseCompletionTask(task);
            }

            @Override
            public void rescheduleTask(Source js, CancellableTask<CompilationInfo> task) {
                js.rescheduleTask(task);
            }
        };
    }

    static interface Accessor2 {
        public void addPhaseCompletionTask(Source var1, CancellableTask<CompilationInfo> var2, Phase var3, Source.Priority var4) throws IOException;

        public void removePhaseCompletionTask(Source var1, CancellableTask<CompilationInfo> var2);

        public void rescheduleTask(Source var1, CancellableTask<CompilationInfo> var2);
    }
}

