/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.EmbeddingModel;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.ParseEvent;
import org.netbeans.modules.gsf.api.ParseListener;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.SourceFileReader;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.gsfret.source.parsing.SourceFileObject;
import org.netbeans.napi.gsfret.source.StringSourceFileReader;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class ParserTaskImpl {
    private ParseListener listener;
    private Language language;

    public ParserTaskImpl(Language language) {
        this.language = language;
    }

    public void setParseListener(ParseListener listener) {
        this.listener = listener;
    }

    public Iterable<ParserResult> parse(ParserFile ... files) throws IOException {
        ArrayList<ParserResult> results = new ArrayList<ParserResult>(files.length);
        for (ParserFile file : files) {
            if (file == null) continue;
            ArrayList<ParserFile> sourceFiles = new ArrayList<ParserFile>(1);
            sourceFiles.add(file);
            FileObject fo = file.getFileObject();
            if (fo == null) {
                Logger.getLogger(ParserTaskImpl.class.getName()).log(Level.WARNING, "No fileobject for " + file);
                continue;
            }
            assert (this.language != null);
            Parser parser = this.language.getParser();
            if (parser == null) continue;
            final ParserResult[] resultHolder = new ParserResult[1];
            ParseListener delegatingListener = new ParseListener(){

                public void started(ParseEvent e) {
                    ParserTaskImpl.this.listener.started(e);
                }

                public void error(Error e) {
                    ParserTaskImpl.this.listener.error(e);
                }

                public void exception(Exception e) {
                    ParserTaskImpl.this.listener.exception(e);
                }

                public void finished(ParseEvent e) {
                    if (e.getKind() == ParseEvent.Kind.PARSE) {
                        resultHolder[0] = e.getResult();
                    }
                    ParserTaskImpl.this.listener.finished(e);
                }
            };
            String mimeType = file.getFileObject().getMIMEType();
            LanguageRegistry registry = LanguageRegistry.getInstance();
            EmbeddingModel model = registry.getEmbedding(this.language.getMimeType(), mimeType);
            if (model != null) {
                FileObject bufferFo = file.getFileObject();
                BaseDocument document = GsfUtilities.getDocument((FileObject)bufferFo, (boolean)true, (boolean)true);
                if (document == null) continue;
                Collection translations = model.translate((Document)document);
                for (TranslatedSource translatedSource : translations) {
                    String buffer = translatedSource.getSource();
                    StringSourceFileReader reader = new StringSourceFileReader(buffer, bufferFo);
                    Parser.Job job = new Parser.Job(sourceFiles, delegatingListener, (SourceFileReader)reader, translatedSource);
                    parser.parseFiles(job);
                    ParserResult result = resultHolder[0];
                    result.setTranslatedSource(translatedSource);
                    assert (result != null);
                    results.add(result);
                }
                continue;
            }
            SourceFileReader reader = new SourceFileReader(){

                public CharSequence read(ParserFile file) throws IOException {
                    if (file.getFileObject() == null) {
                        ErrorManager.getDefault().log("Null fileobject for " + file.getNameExt());
                        return "";
                    }
                    return SourceFileObject.create(file.getFileObject()).getCharContent(false).toString();
                }

                public int getCaretOffset(ParserFile fileObject) {
                    return -1;
                }
            };
            Parser.Job job = new Parser.Job(sourceFiles, delegatingListener, reader, null);
            parser.parseFiles(job);
            ParserResult result = resultHolder[0];
            assert (result != null) : "Parser " + parser.getClass().getName() + " returned null instead of an invalid parser result!";
            results.add(result);
        }
        return results;
    }
}

