/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.EditHistory;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsfret.source.parsing.SourceFileObject;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.ParserTaskImpl;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CompilationInfo
extends org.netbeans.modules.gsf.api.CompilationInfo {
    private Phase phase = Phase.MODIFIED;
    private ParserTaskImpl javacTask;
    final SourceFileObject jfo;
    final Source javaSource;
    boolean needsRestart;
    private Language language;
    private Map<String, ParserResult> embeddedResults = new HashMap<String, ParserResult>();
    private Set<String> unchanged;
    private EditHistory history;

    CompilationInfo() throws IOException {
        super(null);
        this.javaSource = null;
        this.jfo = null;
        this.javacTask = null;
    }

    CompilationInfo(Source javaSource, FileObject fo, ParserTaskImpl javacTask) throws IOException {
        super(fo);
        assert (javaSource != null);
        this.javaSource = javaSource;
        this.jfo = fo.isValid() && !fo.isVirtual() ? new SourceFileObject(fo, true) : null;
        this.javacTask = javacTask;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public String getText() {
        if (this.jfo == null) {
            throw new IllegalStateException();
        }
        try {
            return this.jfo.getCharContent(false).toString();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            return null;
        }
    }

    public TokenHierarchy<?> getTokenHierarchy() {
        if (this.jfo == null) {
            throw new IllegalStateException();
        }
        try {
            return this.jfo.getTokenHierarchy();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            return null;
        }
    }

    public Source getSource() {
        return this.javaSource;
    }

    public ClasspathInfo getClasspathInfo() {
        return this.javaSource.getClasspathInfo();
    }

    public Index getIndex(String mimeType) {
        return this.getClasspathInfo().getClassIndex(mimeType);
    }

    void setPhase(Phase phase) {
        assert (phase != null);
        this.phase = phase;
    }

    synchronized ParserTaskImpl getParserTask() {
        if (this.javacTask == null) {
            this.javacTask = this.javaSource.createParserTask(this);
        }
        return this.javacTask;
    }

    public Language getLanguage() {
        if (this.language == null) {
            FileObject fo = this.getFileObject();
            String mimeType = fo.getMIMEType();
            this.language = LanguageRegistry.getInstance().getLanguageByMimeType(mimeType);
        }
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public Set<String> getEmbeddedMimeTypes() {
        return this.embeddedResults.keySet();
    }

    public void addEmbeddingResult(String mimeType, ParserResult result) {
        this.embeddedResults.put(mimeType, result);
        result.setInfo((org.netbeans.modules.gsf.api.CompilationInfo)this);
    }

    public Collection<? extends ParserResult> getEmbeddedResults(String mimeType) {
        ParserResult result = this.getEmbeddedResult(mimeType, 0);
        if (result != null) {
            return Collections.singletonList(result);
        }
        return Collections.emptyList();
    }

    public ParserResult getEmbeddedResult(String embeddedMimeType, int offset) {
        ParserResult root = this.embeddedResults.get(embeddedMimeType);
        return root;
    }

    public boolean hasUnchangedResults() {
        for (ParserResult result : this.embeddedResults.values()) {
            if (!result.getUpdateState().isUnchanged()) continue;
            return true;
        }
        return false;
    }

    public boolean hasInvalidResults() {
        for (ParserResult result : this.embeddedResults.values()) {
            if (result.isValid()) continue;
            return true;
        }
        return false;
    }

    public List<Error> getErrors() {
        ArrayList<Error> errors = new ArrayList<Error>();
        for (ParserResult result : this.embeddedResults.values()) {
            errors.addAll(result.getDiagnostics());
        }
        return errors;
    }

    public String toString() {
        return "CompilationInfo for " + FileUtil.getFileDisplayName((FileObject)this.getFileObject()) + "; phase=" + (Object)((Object)this.getPhase());
    }

    public EditHistory getHistory() {
        return this.history;
    }

    public void setHistory(EditHistory history) {
        this.history = history;
    }
}

