/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.navigation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.StructureItem;
import org.netbeans.modules.gsf.api.StructureScanner;
import org.netbeans.modules.gsfret.navigation.ClassMemberPanelUI;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.openide.util.ImageUtilities;

public class ElementScanningTask
implements CancellableTask<CompilationInfo> {
    private ClassMemberPanelUI ui;
    private volatile boolean canceled;

    public ElementScanningTask(ClassMemberPanelUI ui) {
        this.ui = ui;
    }

    public void cancel() {
        this.canceled = true;
    }

    public void run(CompilationInfo info) throws Exception {
        this.canceled = false;
        final ArrayList<? extends StructureItem> items = new ArrayList<StructureItem>();
        StructureItem rootDescription = new StructureItem(){

            public String getName() {
                return null;
            }

            public String getHtml(HtmlFormatter formatter) {
                return null;
            }

            public ElementHandle getElementHandle() {
                throw new UnsupportedOperationException("Not supported on the Root Node.");
            }

            public ElementKind getKind() {
                return ElementKind.OTHER;
            }

            public Set<Modifier> getModifiers() {
                return Collections.emptySet();
            }

            public boolean isLeaf() {
                return false;
            }

            public List<? extends StructureItem> getNestedItems() {
                return items;
            }

            public long getPosition() {
                return 0L;
            }

            public long getEndPosition() {
                return Long.MAX_VALUE;
            }

            public ImageIcon getCustomIcon() {
                return null;
            }

            public String getSortText() {
                return null;
            }
        };
        Set<String> mimeTypes = info.getEmbeddedMimeTypes();
        LanguageRegistry registry = LanguageRegistry.getInstance();
        ArrayList<String> sortedMimes = new ArrayList<String>(mimeTypes);
        Collections.sort(sortedMimes);
        ArrayList<MimetypeRootNode> roots = new ArrayList<MimetypeRootNode>();
        int mimetypesWithElements = 0;
        for (String mimeType : mimeTypes) {
            Language language = registry.getLanguageByMimeType(mimeType);
            StructureScanner scanner = language.getStructure();
            if (scanner == null) continue;
            long startTime = System.currentTimeMillis();
            List children = scanner.scan((org.netbeans.modules.gsf.api.CompilationInfo)info);
            long endTime = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Structure (" + mimeType + ")", new Object[]{info.getFileObject(), endTime - startTime});
            if (children.size() > 0) {
                ++mimetypesWithElements;
            }
            roots.add(new MimetypeRootNode(language, children));
        }
        if (roots.size() > 1) {
            Collections.sort(roots, new Comparator<MimetypeRootNode>(){

                @Override
                public int compare(MimetypeRootNode o1, MimetypeRootNode o2) {
                    return o1.getSortText().compareTo(o2.getSortText());
                }
            });
        }
        if (mimetypesWithElements > 1) {
            for (MimetypeRootNode root : roots) {
                items.add(root);
            }
        } else {
            for (MimetypeRootNode root : roots) {
                items.addAll(root.getNestedItems());
            }
        }
        if (!this.canceled) {
            this.ui.refresh(rootDescription, info.getFileObject());
        }
    }

    static final class MimetypeRootNode
    implements StructureItem {
        private static final String CSS_MIMETYPE = "text/x-css";
        private static final String CSS_SORT_TEXT = "2";
        private static final String JAVASCRIPT_MIMETYPE = "text/javascript";
        private static final String RUBY_MIMETYPE = "text/x-ruby";
        private static final String YAML_MIMETYPE = "text/x-yaml";
        private static final String PHP_MIME_TYPE = "text/x-php5";
        private static final String PHP_SORT_TEXT = "0";
        private static final String JAVASCRIPT_SORT_TEXT = "1";
        private static final String HTML_MIMETYPE = "text/html";
        private static final String HTML_SORT_TEXT = "3";
        private static final String YAML_SORT_TEXT = "4";
        private static final String RUBY_SORT_TEXT = "5";
        private static final String OTHER_SORT_TEXT = "9";
        Language language;
        private List<? extends StructureItem> items;
        long from;
        long to;

        private MimetypeRootNode(Language lang, List<? extends StructureItem> items) {
            this.language = lang;
            this.items = items;
            this.from = items.size() > 0 ? items.get(0).getPosition() : 0L;
            this.to = items.size() > 0 ? items.get(items.size() - 1).getEndPosition() : 0L;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MimetypeRootNode)) {
                return false;
            }
            MimetypeRootNode compared = (MimetypeRootNode)o;
            return this.language.equals(compared.language);
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + (this.language != null ? this.language.hashCode() : 0);
            return hash;
        }

        public String getName() {
            return this.language.getDisplayName();
        }

        public String getSortText() {
            String mimeType = this.language.getMimeType();
            if (mimeType.equals(CSS_MIMETYPE)) {
                return CSS_SORT_TEXT;
            }
            if (mimeType.equals(JAVASCRIPT_MIMETYPE)) {
                return JAVASCRIPT_SORT_TEXT;
            }
            if (mimeType.equals(HTML_MIMETYPE)) {
                return HTML_SORT_TEXT;
            }
            if (mimeType.equals(YAML_MIMETYPE)) {
                return YAML_SORT_TEXT;
            }
            if (mimeType.equals(RUBY_MIMETYPE)) {
                return RUBY_SORT_TEXT;
            }
            if (mimeType.equals(PHP_MIME_TYPE)) {
                return PHP_SORT_TEXT;
            }
            return OTHER_SORT_TEXT + this.getName();
        }

        public String getHtml(HtmlFormatter formatter) {
            return this.getName();
        }

        public ElementHandle getElementHandle() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return false;
        }

        public List<? extends StructureItem> getNestedItems() {
            return this.items;
        }

        public long getPosition() {
            return this.from;
        }

        public long getEndPosition() {
            return this.to;
        }

        public ImageIcon getCustomIcon() {
            String iconBase = this.language.getIconBase();
            return iconBase == null ? null : ImageUtilities.loadImageIcon((String)iconBase, (boolean)false);
        }
    }
}

