/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.hints.infrastructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintFix;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.PreviewableFix;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.gsfret.hints.infrastructure.DisableHintFix;
import org.netbeans.modules.gsfret.hints.infrastructure.FixWrapper;
import org.netbeans.modules.gsfret.hints.infrastructure.HintsOptionsPanelController;
import org.netbeans.modules.gsfret.hints.infrastructure.HintsSettings;
import org.netbeans.modules.gsfret.hints.infrastructure.HintsTask;
import org.netbeans.modules.gsfret.hints.infrastructure.Pair;
import org.netbeans.modules.gsfret.hints.infrastructure.PreviewHintFix;
import org.netbeans.modules.gsfret.hints.infrastructure.SuggestionsTask;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class GsfHintsManager
extends HintsProvider.HintsManager {
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.gsfret.hints.infrastructure");
    private static final String INSTANCE_EXT = ".instance";
    private static final String NON_GUI = "nonGUI";
    private static final String RULES_FOLDER = "gsf-hints/";
    private static final String ERRORS = "/errors";
    private static final String HINTS = "/hints";
    private static final String SUGGESTIONS = "/suggestions";
    private static final String SELECTION = "/selection";
    private Map<?, List<? extends Rule.ErrorRule>> errors = new HashMap();
    private Map<?, List<? extends Rule.AstRule>> hints = new HashMap();
    private Map<?, List<? extends Rule.AstRule>> suggestions = new HashMap();
    private List<Rule.SelectionRule> selectionHints = new ArrayList<Rule.SelectionRule>();
    private TreeModel prefTreeModel;
    private DefaultMutableTreeNode hintsRoot;
    private DefaultMutableTreeNode suggestionsRoot;
    private DefaultMutableTreeNode errorsRoot;
    private DefaultMutableTreeNode selectionsRoot;
    private String mimeType;
    private HintsProvider provider;
    private String id;
    boolean isTest = false;
    private OptionsPanelController panelController;

    public GsfHintsManager(String mimeType, HintsProvider provider, Language language) {
        this.mimeType = mimeType;
        this.provider = provider;
        this.id = language.getMimeType().replace('/', '_') + '_';
        this.initErrors();
        this.initHints();
        this.initSuggestions();
        this.initSelectionHints();
        this.initBuiltins();
    }

    public boolean isEnabled(Rule.UserConfigurableRule rule) {
        return HintsSettings.isEnabled(this, rule);
    }

    public Map<?, List<? extends Rule.ErrorRule>> getErrors() {
        return this.errors;
    }

    public Map<?, List<? extends Rule.AstRule>> getHints() {
        return this.hints;
    }

    public List<? extends Rule.SelectionRule> getSelectionHints() {
        return this.selectionHints;
    }

    public Map<?, List<? extends Rule.AstRule>> getHints(boolean onLine, RuleContext context) {
        HashMap result = new HashMap();
        for (Map.Entry<?, List<Rule.AstRule>> e : this.getHints().entrySet()) {
            LinkedList<Rule.AstRule> nueRules = new LinkedList<Rule.AstRule>();
            for (Rule.AstRule astRule : e.getValue()) {
                Preferences p = HintsSettings.getPreferences(this, (Rule.UserConfigurableRule)astRule, null);
                if (p == null) {
                    if (onLine || !astRule.appliesTo(context)) continue;
                    nueRules.add(astRule);
                    continue;
                }
                if (HintsSettings.getSeverity(this, (Rule.UserConfigurableRule)astRule) == HintSeverity.CURRENT_LINE_WARNING) {
                    if (!onLine || !astRule.appliesTo(context)) continue;
                    nueRules.add(astRule);
                    continue;
                }
                if (onLine || !astRule.appliesTo(context)) continue;
                nueRules.add(astRule);
            }
            if (nueRules.isEmpty()) continue;
            result.put(e.getKey(), nueRules);
        }
        return result;
    }

    public Map<?, List<? extends Rule.AstRule>> getSuggestions() {
        return this.suggestions;
    }

    public TreeModel getHintsTreeModel() {
        if (this.prefTreeModel == null) {
            DefaultMutableTreeNode node;
            int i;
            ArrayList<DefaultMutableTreeNode> nodes;
            int childCount;
            if (this.suggestionsRoot != null && !this.suggestionsRoot.isLeaf() && (childCount = this.suggestionsRoot.getChildCount()) > 0) {
                nodes = new ArrayList<DefaultMutableTreeNode>();
                for (i = 0; i < childCount; ++i) {
                    node = (DefaultMutableTreeNode)this.errorsRoot.getChildAt(i);
                    if (!(node.getUserObject() instanceof Rule.UserConfigurableRule)) continue;
                    nodes.add(node);
                }
                if (nodes.size() > 0) {
                    DefaultMutableTreeNode category = new DefaultMutableTreeNode(NbBundle.getMessage(GsfHintsManager.class, (String)"CaretHints"), true);
                    this.hintsRoot.add(category);
                    for (MutableTreeNode mutableTreeNode : nodes) {
                        this.hintsRoot.add(mutableTreeNode);
                    }
                }
            }
            if (this.errorsRoot != null && !this.errorsRoot.isLeaf() && (childCount = this.errorsRoot.getChildCount()) > 0) {
                nodes = new ArrayList();
                for (i = 0; i < childCount; ++i) {
                    node = (DefaultMutableTreeNode)this.errorsRoot.getChildAt(i);
                    if (!(node.getUserObject() instanceof Rule.UserConfigurableRule)) continue;
                    nodes.add(node);
                }
                if (nodes.size() > 0) {
                    DefaultMutableTreeNode category = new DefaultMutableTreeNode(NbBundle.getMessage(GsfHintsManager.class, (String)"ErrorHints"), true);
                    this.hintsRoot.add(category);
                    for (MutableTreeNode mutableTreeNode : nodes) {
                        category.add(mutableTreeNode);
                    }
                }
            }
            if (this.selectionsRoot != null && !this.selectionsRoot.isLeaf() && (childCount = this.selectionsRoot.getChildCount()) > 0) {
                nodes = new ArrayList();
                for (int i2 = 0; i2 < childCount; ++i2) {
                    node = (DefaultMutableTreeNode)this.selectionsRoot.getChildAt(i2);
                    if (!(node.getUserObject() instanceof Rule.UserConfigurableRule)) continue;
                    nodes.add(node);
                }
                if (nodes.size() > 0) {
                    DefaultMutableTreeNode category = new DefaultMutableTreeNode(NbBundle.getMessage(GsfHintsManager.class, (String)"SelectionHints"), true);
                    this.hintsRoot.add(category);
                    for (MutableTreeNode mutableTreeNode : nodes) {
                        category.add(mutableTreeNode);
                    }
                }
            }
            this.prefTreeModel = new DefaultTreeModel(this.hintsRoot);
        }
        return this.prefTreeModel;
    }

    public String getId() {
        return this.id;
    }

    private void initErrors() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        FileObject folder = FileUtil.getConfigFile((String)(RULES_FOLDER + this.mimeType + ERRORS));
        List<Pair<Rule, FileObject>> rules = GsfHintsManager.readRules(folder);
        GsfHintsManager.categorizeErrorRules(rules, this.errors, folder, rootNode);
        this.errorsRoot = rootNode;
    }

    private void initHints() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        FileObject folder = FileUtil.getConfigFile((String)(RULES_FOLDER + this.mimeType + HINTS));
        List<Pair<Rule, FileObject>> rules = GsfHintsManager.readRules(folder);
        GsfHintsManager.categorizeAstRules(rules, this.hints, folder, rootNode);
        this.hintsRoot = rootNode;
    }

    private void initSuggestions() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        FileObject folder = FileUtil.getConfigFile((String)(RULES_FOLDER + this.mimeType + SUGGESTIONS));
        List<Pair<Rule, FileObject>> rules = GsfHintsManager.readRules(folder);
        GsfHintsManager.categorizeAstRules(rules, this.suggestions, folder, rootNode);
        this.suggestionsRoot = rootNode;
    }

    private void initSelectionHints() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        FileObject folder = FileUtil.getConfigFile((String)(RULES_FOLDER + this.mimeType + SELECTION));
        List<Pair<Rule, FileObject>> rules = GsfHintsManager.readRules(folder);
        GsfHintsManager.categorizeSelectionRules(rules, this.selectionHints, folder, rootNode);
        this.selectionsRoot = rootNode;
    }

    private void initBuiltins() {
        DefaultMutableTreeNode root;
        List extraRules = this.provider.getBuiltinRules();
        if (extraRules != null) {
            Map<?, List<Rule.ErrorRule>> errorMap = this.errors;
            List<Rule.SelectionRule> selectionList = this.selectionHints;
            Map<?, List<Rule.AstRule>> hintsMap = this.hints;
            for (Rule rule : extraRules) {
                List<? extends Rule.ErrorRule> list;
                if (rule instanceof Rule.ErrorRule) {
                    Rule.ErrorRule errorRule = (Rule.ErrorRule)rule;
                    for (Object key : errorRule.getCodes()) {
                        list = this.errors.get(key);
                        if (list == null) {
                            list = new ArrayList<Rule.ErrorRule>(2);
                            errorMap.put(key, list);
                        }
                        list.add((Rule.ErrorRule)rule);
                    }
                    continue;
                }
                if (rule instanceof Rule.SelectionRule) {
                    selectionList.add((Rule.SelectionRule)rule);
                    continue;
                }
                if (rule instanceof Rule.AstRule) {
                    Rule.AstRule astRule = (Rule.AstRule)rule;
                    for (Object key : astRule.getKinds()) {
                        list = this.hints.get(key);
                        if (list == null) {
                            list = new ArrayList<Rule.ErrorRule>(2);
                            hintsMap.put(key, list);
                        }
                        list.add((Rule.ErrorRule)rule);
                    }
                    continue;
                }
                assert (false) : "Unexpected rule type " + rule;
            }
        }
        if (extraRules != null && (root = this.hintsRoot) != null) {
            TreeNode firstChild;
            if (root.getAllowsChildren() && root.getChildCount() > 0 && (firstChild = root.getChildAt(0)) instanceof DefaultMutableTreeNode && !firstChild.isLeaf()) {
                root = (DefaultMutableTreeNode)firstChild;
            }
            for (Rule rule : extraRules) {
                root.add(new DefaultMutableTreeNode(rule, false));
            }
        }
    }

    private static List<Pair<Rule, FileObject>> readRules(FileObject folder) {
        LinkedList<Pair<Rule, FileObject>> rules = new LinkedList<Pair<Rule, FileObject>>();
        if (folder == null) {
            return rules;
        }
        Enumeration e = folder.getData(true);
        while (e.hasMoreElements()) {
            FileObject o = (FileObject)e.nextElement();
            String name = o.getNameExt().toLowerCase();
            if (!o.canRead()) continue;
            Rule r = null;
            if (name.endsWith(INSTANCE_EXT)) {
                r = GsfHintsManager.instantiateRule(o);
            }
            if (r == null) continue;
            rules.add(new Pair<Rule, FileObject>(r, o));
        }
        return rules;
    }

    private static void categorizeErrorRules(List<Pair<Rule, FileObject>> rules, Map<?, List<? extends Rule.ErrorRule>> dest, FileObject rootFolder, DefaultMutableTreeNode rootNode) {
        HashMap<FileObject, DefaultMutableTreeNode> dir2node = new HashMap<FileObject, DefaultMutableTreeNode>();
        dir2node.put(rootFolder, rootNode);
        for (Pair<Rule, FileObject> pair : rules) {
            Rule rule = pair.getA();
            FileObject fo = pair.getB();
            if (rule instanceof Rule.ErrorRule) {
                GsfHintsManager.addRule((Rule.ErrorRule)rule, dest);
                FileObject parent = fo.getParent();
                DefaultMutableTreeNode category = (DefaultMutableTreeNode)dir2node.get(parent);
                if (category == null) {
                    category = new DefaultMutableTreeNode(parent);
                    rootNode.add(category);
                    dir2node.put(parent, category);
                }
                category.add(new DefaultMutableTreeNode(rule, false));
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fo.getPath() + "is not instance of ErrorRule");
        }
    }

    private static void categorizeAstRules(List<Pair<Rule, FileObject>> rules, Map<?, List<? extends Rule.AstRule>> dest, FileObject rootFolder, DefaultMutableTreeNode rootNode) {
        HashMap<FileObject, DefaultMutableTreeNode> dir2node = new HashMap<FileObject, DefaultMutableTreeNode>();
        dir2node.put(rootFolder, rootNode);
        for (Pair<Rule, FileObject> pair : rules) {
            Rule rule = pair.getA();
            FileObject fo = pair.getB();
            if (rule instanceof Rule.AstRule) {
                Object nonGuiObject = fo.getAttribute(NON_GUI);
                boolean toGui = true;
                if (nonGuiObject != null && nonGuiObject instanceof Boolean && ((Boolean)nonGuiObject).booleanValue()) {
                    toGui = false;
                }
                GsfHintsManager.addRule((Rule.AstRule)rule, dest);
                FileObject parent = fo.getParent();
                DefaultMutableTreeNode category = (DefaultMutableTreeNode)dir2node.get(parent);
                if (category == null) {
                    category = new DefaultMutableTreeNode(parent);
                    rootNode.add(category);
                    dir2node.put(parent, category);
                }
                if (!toGui) continue;
                category.add(new DefaultMutableTreeNode(rule, false));
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fo.getPath() + "is not instance of AstRule");
        }
    }

    private static void categorizeSelectionRules(List<Pair<Rule, FileObject>> rules, List<? extends Rule.SelectionRule> dest, FileObject rootFolder, DefaultMutableTreeNode rootNode) {
        HashMap<FileObject, DefaultMutableTreeNode> dir2node = new HashMap<FileObject, DefaultMutableTreeNode>();
        dir2node.put(rootFolder, rootNode);
        for (Pair<Rule, FileObject> pair : rules) {
            Rule rule = pair.getA();
            FileObject fo = pair.getB();
            if (rule instanceof Rule.SelectionRule) {
                GsfHintsManager.addRule((Rule.SelectionRule)rule, dest);
                FileObject parent = fo.getParent();
                DefaultMutableTreeNode category = (DefaultMutableTreeNode)dir2node.get(parent);
                if (category == null) {
                    category = new DefaultMutableTreeNode(parent);
                    rootNode.add(category);
                    dir2node.put(parent, category);
                }
                category.add(new DefaultMutableTreeNode(rule, false));
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fo.getPath() + "is not instance of SelectionRule");
        }
    }

    private static void addRule(Rule.AstRule rule, Map<? super Object, List<Rule.AstRule>> dest) {
        for (Object kind : rule.getKinds()) {
            List<Rule.AstRule> l = dest.get(kind);
            if (l == null) {
                l = new LinkedList<Rule.AstRule>();
                dest.put(kind, l);
            }
            l.add(rule);
        }
    }

    private static void addRule(Rule.ErrorRule rule, Map<? super Object, List<Rule.ErrorRule>> dest) {
        for (Object code : rule.getCodes()) {
            List<Rule.ErrorRule> l = dest.get(code);
            if (l == null) {
                l = new LinkedList<Rule.ErrorRule>();
                dest.put(code, l);
            }
            l.add(rule);
        }
    }

    private static void addRule(Rule.SelectionRule rule, List<? super Rule.SelectionRule> dest) {
        dest.add((Rule.SelectionRule)rule);
    }

    private static Rule instantiateRule(FileObject fileObject) {
        try {
            DataObject dobj = DataObject.find((FileObject)fileObject);
            InstanceCookie ic = (InstanceCookie)dobj.getCookie(InstanceCookie.class);
            Object instance = ic.instanceCreate();
            if (instance instanceof Rule) {
                return (Rule)instance;
            }
            return null;
        }
        catch (IOException e) {
            LOG.log(Level.INFO, null, e);
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.INFO, null, e);
        }
        return null;
    }

    public final ErrorDescription createDescription(Hint desc, RuleContext context, boolean allowDisableEmpty) {
        List<Object> fixList;
        Rule rule = desc.getRule();
        HintSeverity severity = rule instanceof Rule.UserConfigurableRule ? HintsSettings.getSeverity(this, (Rule.UserConfigurableRule)rule) : rule.getDefaultSeverity();
        OffsetRange range = desc.getRange();
        CompilationInfo info = context.compilationInfo;
        if (desc.getFixes() != null && desc.getFixes().size() > 0) {
            fixList = new ArrayList(desc.getFixes().size());
            String sortText = Integer.toString(10000 + desc.getPriority());
            for (HintFix fix : desc.getFixes()) {
                PreviewableFix previewFix;
                fixList.add(new FixWrapper(fix, sortText));
                if (!(fix instanceof PreviewableFix) || !(previewFix = (PreviewableFix)fix).canPreview() || this.isTest) continue;
                fixList.add(new PreviewHintFix(info, previewFix, sortText));
            }
            if (rule instanceof Rule.UserConfigurableRule && !this.isTest) {
                fixList.add(new DisableHintFix(this, context, (Rule.UserConfigurableRule)rule, sortText));
            }
        } else if (allowDisableEmpty && rule instanceof Rule.UserConfigurableRule && !this.isTest) {
            String sortText = Integer.toString(10000 + desc.getPriority());
            fixList = Collections.singletonList(new DisableHintFix(this, context, (Rule.UserConfigurableRule)rule, sortText));
        } else {
            fixList = Collections.emptyList();
        }
        return ErrorDescriptionFactory.createErrorDescription((Severity)severity.toEditorSeverity(), (String)desc.getDescription(), fixList, (FileObject)desc.getFile(), (int)range.getStart(), (int)range.getEnd());
    }

    public final void refreshHints(RuleContext context) {
        List<ErrorDescription> result = GsfHintsManager.getHints(this, context);
        HintsController.setErrors((FileObject)context.compilationInfo.getFileObject(), (String)(context.caretOffset == -1 ? HintsTask.class.getName() : SuggestionsTask.class.getName()), result);
    }

    private static final List<ErrorDescription> getHints(GsfHintsManager hintsManager, RuleContext context) {
        int caretPos = context.caretOffset;
        HintsProvider provider = hintsManager.provider;
        ArrayList descriptions = new ArrayList();
        if (caretPos == -1) {
            provider.computeHints((HintsProvider.HintsManager)hintsManager, context, descriptions);
            ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>(descriptions.size());
            for (Hint desc : descriptions) {
                boolean allowDisable = true;
                ErrorDescription errorDesc = hintsManager.createDescription(desc, context, allowDisable);
                result.add(errorDesc);
            }
            return result;
        }
        provider.computeSuggestions((HintsProvider.HintsManager)hintsManager, context, descriptions, caretPos);
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>(descriptions.size());
        for (Hint desc : descriptions) {
            boolean allowDisable = true;
            ErrorDescription errorDesc = hintsManager.createDescription(desc, context, allowDisable);
            result.add(errorDesc);
        }
        return result;
    }

    static final void refreshHints(CompilationController controller) {
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        Set<String> mimeTypes = controller.getEmbeddedMimeTypes();
        for (String mime : mimeTypes) {
            HintsProvider provider;
            Language language = LanguageRegistry.getInstance().getLanguageByMimeType(mime);
            if (language == null || (provider = language.getHintsProvider()) == null) continue;
            GsfHintsManager hintsManager = language.getHintsManager();
            RuleContext context = hintsManager.createRuleContext(controller, language, -1, -1, -1);
            List<ErrorDescription> hints = GsfHintsManager.getHints(hintsManager, context);
            result.addAll(hints);
        }
        HintsController.setErrors((FileObject)controller.getFileObject(), (String)HintsTask.class.getName(), result);
    }

    public RuleContext createRuleContext(CompilationInfo info, Language language, int caretOffset, int selectionStart, int selectionEnd) {
        RuleContext context = this.provider.createRuleContext();
        context.manager = this;
        context.compilationInfo = info;
        context.caretOffset = caretOffset;
        context.selectionStart = selectionStart;
        context.selectionEnd = selectionEnd;
        context.doc = (BaseDocument)info.getDocument();
        if (context.doc == null) {
            return null;
        }
        Collection embeddedResults = info.getEmbeddedResults(language.getMimeType());
        Collection collection = context.parserResults = embeddedResults != null ? embeddedResults : Collections.EMPTY_LIST;
        if (context.parserResults.size() > 0) {
            context.parserResult = (ParserResult)embeddedResults.iterator().next();
        }
        return context;
    }

    public synchronized OptionsPanelController getOptionsController() {
        if (this.panelController == null) {
            this.panelController = new HintsOptionsPanelController(this);
        }
        return this.panelController;
    }

    public void setTestingRules(Map<?, List<? extends Rule.ErrorRule>> errors, Map<?, List<? extends Rule.AstRule>> hints, Map<?, List<? extends Rule.AstRule>> suggestions, List<Rule.SelectionRule> selectionHints) {
        this.errors = errors;
        this.hints = hints;
        this.suggestions = suggestions;
        this.selectionHints = selectionHints;
        this.isTest = true;
    }

    public Preferences getPreferences(Rule.UserConfigurableRule rule) {
        return HintsSettings.getPreferences(this, rule, null);
    }

    public static class HintsManagerFactory
    extends HintsProvider.Factory {
        public HintsProvider.HintsManager getManagerForMimeType(String mimeType) {
            Language language = LanguageRegistry.getInstance().getLanguageByMimeType(mimeType);
            if (language != null && language.getHintsProvider() != null) {
                return language.getHintsManager();
            }
            return null;
        }
    }
}

