/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.codetemplates;

import java.io.IOException;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateInsertRequest;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateParameter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessor;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CodeCompletionHandler;
import org.netbeans.modules.gsfret.editor.completion.GsfCompletionProvider;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.util.Exceptions;

public class GsfCodeTemplateProcessor
implements CodeTemplateProcessor {
    private CodeTemplateInsertRequest request;
    private CompilationInfo cInfo = null;

    private GsfCodeTemplateProcessor(CodeTemplateInsertRequest request) {
        this.request = request;
    }

    public synchronized void updateDefaultValues() {
        boolean cont = true;
        while (cont) {
            cont = false;
            for (CodeTemplateParameter p : this.request.getMasterParameters()) {
                CodeTemplateParameter param = p;
                String value = this.getProposedValue(param);
                if (value == null || value.equals(param.getValue())) continue;
                param.setValue(value);
                cont = true;
            }
        }
    }

    public void parameterValueChanged(CodeTemplateParameter masterParameter, boolean typingChange) {
        if (typingChange) {
            for (CodeTemplateParameter p : this.request.getMasterParameters()) {
                String value;
                CodeTemplateParameter param = p;
                if (param.isUserModified() || (value = this.getProposedValue(param)) == null || value.equals(param.getValue())) continue;
                param.setValue(value);
            }
        }
    }

    public void release() {
    }

    private String getProposedValue(CodeTemplateParameter param) {
        String variable = param.getName();
        JTextComponent c = this.request.getComponent();
        int caretOffset = c.getCaret().getDot();
        String resolved = this.delegatedResolve(caretOffset, param.getName(), variable, param.getHints());
        return resolved;
    }

    private String delegatedResolve(int caretOffset, String name, String variable, Map params) {
        try {
            if (this.initParsing()) {
                CodeCompletionHandler completer = GsfCompletionProvider.getCompletable(this.cInfo, caretOffset);
                if (completer == null) {
                    return null;
                }
                return completer.resolveTemplateVariable(variable, (org.netbeans.modules.gsf.api.CompilationInfo)this.cInfo, caretOffset, name, params);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    private boolean initParsing() {
        if (this.cInfo == null) {
            BaseDocument doc;
            JTextComponent c = this.request.getComponent();
            Source js = Source.forDocument(c.getDocument());
            if (c.getDocument() instanceof BaseDocument && (doc = (BaseDocument)c.getDocument()).isAtomicLock()) {
                return false;
            }
            if (js != null) {
                try {
                    js.runUserActionTask(new CancellableTask<CompilationController>(){

                        public void cancel() {
                        }

                        public void run(CompilationController controller) throws IOException {
                            controller.toPhase(Phase.RESOLVED);
                            GsfCodeTemplateProcessor.this.cInfo = controller;
                        }
                    }, false);
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }
        return this.cInfo != null;
    }

    public static final class Factory
    implements CodeTemplateProcessorFactory {
        public CodeTemplateProcessor createProcessor(CodeTemplateInsertRequest request) {
            return new GsfCodeTemplateProcessor(request);
        }
    }
}

