/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsfret.source.ActivatedDocumentListener;
import org.netbeans.modules.gsfret.source.SourceAccessor;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.gsfret.source.usages.RepositoryUpdater;
import org.netbeans.modules.gsfret.source.util.LowMemoryNotifierMBeanImpl;
import org.netbeans.napi.gsfret.source.SourceTaskFactoryManager;
import org.openide.ErrorManager;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class GsfModuleInstaller
extends ModuleInstall {
    private static final boolean ENABLE_MBEANS = Boolean.getBoolean("org.netbeans.modules.gsf.enableMBeans");
    private static final RequestProcessor RP = new RequestProcessor("gsf module install", 1);

    public void restored() {
        SourceAccessor.dummy = 1;
        SourceTaskFactoryManager.register();
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        RepositoryUpdater.getDefault();
                        ActivatedDocumentListener.register();
                    }
                });
            }
        });
        if (ENABLE_MBEANS) {
            GsfModuleInstaller.registerMBeans();
        }
    }

    public boolean closing() {
        boolean ret = super.closing();
        RepositoryUpdater.getDefault().close();
        try {
            for (final Language language : LanguageRegistry.getInstance()) {
                if (language.getIndexer() == null) continue;
                ClassIndexManager.writeLock(new ClassIndexManager.ExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        ClassIndexManager.get(language).close();
                        return null;
                    }
                });
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (ENABLE_MBEANS) {
            GsfModuleInstaller.unregisterMBeans();
        }
        return ret;
    }

    private static void registerMBeans() {
        try {
            MBeanServer mgs = ManagementFactory.getPlatformMBeanServer();
            mgs.registerMBean(new LowMemoryNotifierMBeanImpl(), new ObjectName("org.netbeans.modules.gsfret.source:type=LowMemoryNotifier"));
        }
        catch (NotCompliantMBeanException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private static void unregisterMBeans() {
        try {
            MBeanServer mgs = ManagementFactory.getPlatformMBeanServer();
            mgs.unregisterMBean(new ObjectName("org.netbeans.modules.gsfret.source:type=LowMemoryNotifier"));
        }
        catch (MalformedObjectNameException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }
}

