/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.Rectangle;
import java.util.Locale;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.derived.LengthValue;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.render.RenderingContext;

public class PageBox {
    private CalculatedStyle _style;
    private int _top;
    private int _bottom;
    private int _paintingTop;
    private int _paintingBottom;
    private int _pageNo;
    private int _outerPageWidth;
    private PageDimensions _pageDimensions;

    public int getWidth(CssContext cssCtx) {
        this.resolvePageDimensions(cssCtx);
        return this._pageDimensions.getWidth();
    }

    public int getHeight(CssContext cssCtx) {
        this.resolvePageDimensions(cssCtx);
        return this._pageDimensions.getHeight();
    }

    private void resolvePageDimensions(CssContext cssCtx) {
        if (this._pageDimensions == null) {
            CalculatedStyle style = this.getStyle();
            int width = style.isLength(CSSName.FS_PAGE_WIDTH) ? (int)style.getFloatPropertyProportionalTo(CSSName.FS_PAGE_WIDTH, 0.0f, cssCtx) : this.resolveAutoPageWidth(cssCtx);
            int height = style.isLength(CSSName.FS_PAGE_HEIGHT) ? (int)style.getFloatPropertyProportionalTo(CSSName.FS_PAGE_HEIGHT, 0.0f, cssCtx) : this.resolveAutoPageHeight(cssCtx);
            if (style.isIdent(CSSName.FS_PAGE_ORIENTATION, IdentValue.LANDSCAPE)) {
                int temp = width;
                width = height;
                height = temp;
            }
            PageDimensions dim = new PageDimensions();
            dim.setWidth(width);
            dim.setHeight(height);
            this._pageDimensions = dim;
        }
    }

    private boolean isUseLetterSize() {
        Locale l = Locale.getDefault();
        String county = l.getCountry();
        return county.equals("US") || county.equals("CA") || county.equals("MX");
    }

    private int resolveAutoPageWidth(CssContext cssCtx) {
        if (this.isUseLetterSize()) {
            return (int)LengthValue.calcFloatProportionalValue(this.getStyle(), CSSName.FS_PAGE_WIDTH, "8.5in", 8.5f, (short)8, 0.0f, cssCtx);
        }
        return (int)LengthValue.calcFloatProportionalValue(this.getStyle(), CSSName.FS_PAGE_WIDTH, "210mm", 210.0f, (short)7, 0.0f, cssCtx);
    }

    private int resolveAutoPageHeight(CssContext cssCtx) {
        if (this.isUseLetterSize()) {
            return (int)LengthValue.calcFloatProportionalValue(this.getStyle(), CSSName.FS_PAGE_HEIGHT, "11in", 11.0f, (short)8, 0.0f, cssCtx);
        }
        return (int)LengthValue.calcFloatProportionalValue(this.getStyle(), CSSName.FS_PAGE_HEIGHT, "297mm", 297.0f, (short)7, 0.0f, cssCtx);
    }

    public int getContentHeight(CssContext cssCtx) {
        return this.getHeight(cssCtx) - this.getMarginBorderPadding(cssCtx, 3) - this.getMarginBorderPadding(cssCtx, 4);
    }

    public int getContentWidth(CssContext cssCtx) {
        return this.getWidth(cssCtx) - this.getMarginBorderPadding(cssCtx, 1) - this.getMarginBorderPadding(cssCtx, 2);
    }

    public CalculatedStyle getStyle() {
        return this._style;
    }

    public void setStyle(CalculatedStyle style) {
        this._style = style;
    }

    public int getBottom() {
        return this._bottom;
    }

    public int getTop() {
        return this._top;
    }

    public void setTopAndBottom(CssContext cssCtx, int top) {
        this._top = top;
        this._bottom = top + this.getContentHeight(cssCtx);
    }

    public int getPaintingBottom() {
        return this._paintingBottom;
    }

    public void setPaintingBottom(int paintingBottom) {
        this._paintingBottom = paintingBottom;
    }

    public int getPaintingTop() {
        return this._paintingTop;
    }

    public void setPaintingTop(int paintingTop) {
        this._paintingTop = paintingTop;
    }

    public Rectangle getOverallPaintingBounds(CssContext cssCtx, int additionalClearance) {
        return new Rectangle(additionalClearance, this.getPaintingTop(), this.getWidth(cssCtx), this.getPaintingBottom() - this.getPaintingTop());
    }

    public Rectangle getPagedViewClippingBounds(CssContext cssCtx, int additionalClearance) {
        Rectangle result = new Rectangle(additionalClearance + this.getMarginBorderPadding(cssCtx, 1), this.getPaintingTop() + this.getMarginBorderPadding(cssCtx, 3), this.getContentWidth(cssCtx), this.getContentHeight(cssCtx));
        return result;
    }

    public Rectangle getPrintingClippingBounds(CssContext cssCtx) {
        Rectangle result = new Rectangle(this.getMarginBorderPadding(cssCtx, 1), this.getMarginBorderPadding(cssCtx, 3), this.getContentWidth(cssCtx), this.getContentHeight(cssCtx));
        --result.height;
        return result;
    }

    public RectPropertySet getMargin(CssContext cssCtx) {
        return this.getStyle().getMarginRect(this._outerPageWidth, cssCtx);
    }

    public Rectangle getFlowBounds(CssContext cssCtx, String name) {
        CalculatedStyle style = this.getStyle();
        String flow = null;
        if (!style.getStringProperty(CSSName.FS_FLOW_TOP).equals("none") && name.equals(flow = style.getStringProperty(CSSName.FS_FLOW_TOP))) {
            return new Rectangle(0, 0, this.getWidth(cssCtx) - (int)this.getMargin(cssCtx).width(), (int)this.getMargin(cssCtx).top());
        }
        if (!style.getStringProperty(CSSName.FS_FLOW_RIGHT).equals("none") && name.equals(flow = style.getStringProperty(CSSName.FS_FLOW_RIGHT))) {
            return new Rectangle(0, 0, (int)this.getMargin(cssCtx).right(), this.getHeight(cssCtx) - (int)this.getMargin(cssCtx).height());
        }
        if (!style.getStringProperty(CSSName.FS_FLOW_BOTTOM).equals("none") && name.equals(flow = style.getStringProperty(CSSName.FS_FLOW_BOTTOM))) {
            return new Rectangle(0, 0, this.getWidth(cssCtx) - (int)this.getMargin(cssCtx).width(), (int)this.getMargin(cssCtx).bottom());
        }
        if (!style.getStringProperty(CSSName.FS_FLOW_LEFT).equals("none") && name.equals(flow = style.getStringProperty(CSSName.FS_FLOW_LEFT))) {
            return new Rectangle(0, 0, (int)this.getMargin(cssCtx).left(), this.getHeight(cssCtx) - (int)this.getMargin(cssCtx).height());
        }
        return null;
    }

    public void paintAlternateFlows(RenderingContext c, Layer root, short mode) {
        this.paintAlternateFlows(c, root, mode, 0);
    }

    public void paintAlternateFlows(RenderingContext c, Layer root, short mode, int additionalClearance) {
        this.paintTopFlow(c, root, mode, additionalClearance);
        this.paintBottomFlow(c, root, mode, additionalClearance);
        this.paintLeftFlow(c, root, mode, additionalClearance);
        this.paintRightFlow(c, root, mode, additionalClearance);
    }

    private void paintTopFlow(RenderingContext c, Layer root, short mode, int additionalClearance) {
        CalculatedStyle style = this.getStyle();
        String flowName = style.getStringProperty(CSSName.FS_FLOW_TOP);
        if (!flowName.equals("none")) {
            int top;
            int left = additionalClearance + (int)this.getMargin(c).left();
            if (mode == 1) {
                top = this.getPaintingTop();
            } else if (mode == 2) {
                top = 0;
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            this.paintFlow(c, root, flowName, left, top);
        }
    }

    private void paintBottomFlow(RenderingContext c, Layer root, short mode, int additionalClearance) {
        CalculatedStyle style = this.getStyle();
        String flowName = style.getStringProperty(CSSName.FS_FLOW_BOTTOM);
        if (!flowName.equals("none")) {
            int top;
            int left = additionalClearance + (int)this.getMargin(c).left();
            if (mode == 1) {
                top = this.getPaintingBottom() - (int)this.getMargin(c).bottom();
            } else if (mode == 2) {
                top = this.getHeight(c) - (int)this.getMargin(c).bottom();
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            this.paintFlow(c, root, flowName, left, top);
        }
    }

    private void paintLeftFlow(RenderingContext c, Layer root, short mode, int additionalClearance) {
        CalculatedStyle style = this.getStyle();
        String flowName = style.getStringProperty(CSSName.FS_FLOW_LEFT);
        if (!flowName.equals("none")) {
            int top;
            int left = additionalClearance;
            if (mode == 1) {
                top = this.getPaintingTop() + (int)this.getMargin(c).top();
            } else if (mode == 2) {
                top = (int)this.getMargin(c).top();
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            this.paintFlow(c, root, flowName, left, top);
        }
    }

    private void paintRightFlow(RenderingContext c, Layer root, short mode, int additionalClearance) {
        CalculatedStyle style = this.getStyle();
        String flowName = style.getStringProperty(CSSName.FS_FLOW_RIGHT);
        if (!flowName.equals("none")) {
            int top;
            int left = additionalClearance + this.getWidth(c) - (int)this.getMargin(c).right();
            if (mode == 1) {
                top = this.getPaintingTop() + (int)this.getMargin(c).top();
            } else if (mode == 2) {
                top = (int)this.getMargin(c).top();
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            this.paintFlow(c, root, flowName, left, top);
        }
    }

    private void paintFlow(RenderingContext c, Layer root, String flowName, int left, int top) {
        Layer flow = root.getAlternateFlow(flowName);
        if (flow != null) {
            c.getOutputDevice().translate(left, top);
            flow.paint(c, 0, 0, true);
            c.getOutputDevice().translate(-left, -top);
        }
    }

    private Rectangle getBorderEdge(int left, int top, CssContext cssCtx) {
        RectPropertySet margin = this.getMargin(cssCtx);
        Rectangle result = new Rectangle(left + (int)margin.left(), top + (int)margin.top(), this.getWidth(cssCtx) - (int)margin.left() - (int)margin.right(), this.getHeight(cssCtx) - (int)margin.top() - (int)margin.bottom());
        return result;
    }

    public void paintBorder(RenderingContext c, int additionalClearance, short mode) {
        int top = 0;
        if (mode == 1) {
            top = this.getPaintingTop();
        }
        c.getOutputDevice().paintBorder(c, this.getStyle(), this.getBorderEdge(additionalClearance, top, c), 15);
    }

    public int getPageNo() {
        return this._pageNo;
    }

    public void setPageNo(int pageNo) {
        this._pageNo = pageNo;
    }

    public int getOuterPageWidth() {
        return this._outerPageWidth;
    }

    public void setOuterPageWidth(int containingBlockWidth) {
        this._outerPageWidth = containingBlockWidth;
    }

    public int getMarginBorderPadding(CssContext cssCtx, int which) {
        return this.getStyle().getMarginBorderPadding(cssCtx, this.getOuterPageWidth(), which);
    }

    private static final class PageDimensions {
        private int _width;
        private int _height;

        private PageDimensions() {
        }

        public int getHeight() {
            return this._height;
        }

        public void setHeight(int height) {
            this._height = height;
        }

        public int getWidth() {
            return this._width;
        }

        public void setWidth(int width) {
            this._width = width;
        }
    }
}

