/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.ChartModelListener;
import org.netbeans.lib.profiler.ui.charts.PieChart;
import org.netbeans.lib.profiler.ui.charts.PieChartModel;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.SnippetPanel;

public class StatisticsPanel
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.Bundle");
    private static final String SCOPE_LABEL_TEXT = messages.getString("StatisticsPanel_ScopeLabelText");
    private SnippetPanel.Padding snippetsBottomFiller;
    private ArrayList itemPresenters = new ArrayList();
    private ArrayList snippets = new ArrayList();
    private JPanel container;
    private JPanel noSnippetsBottomFiller;
    private NavPanel navPanel;
    private PieChart pieChart;
    private Runnable navigationBackPerformer;
    private Vector listeners = new Vector();

    public StatisticsPanel(HTMLTextArea navArea, PieChart pieChart, Runnable navigationBackPerformer) {
        this.pieChart = pieChart;
        this.navigationBackPerformer = navigationBackPerformer;
        this.initComponents(navArea, pieChart);
        pieChart.getModel().addChartModelListener(new ChartModelListener(){

            @Override
            public void chartDataChanged() {
                StatisticsPanel.this.updateItemPresenters();
            }
        });
    }

    public void addListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void addSnippet(JComponent component) {
        SnippetPanel snippet = new SnippetPanel(component.getName(), component);
        snippet.setOpaque(false);
        this.snippets.add(snippet);
        this.updateSnippets();
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void removeSnippet(JComponent component) {
        for (int i = 0; i < this.snippets.size(); ++i) {
            if (((SnippetPanel)this.snippets.get(i)).getContent() != component) continue;
            this.snippets.remove(i);
            break;
        }
        this.updateSnippets();
    }

    private void initComponents(HTMLTextArea navArea, PieChart pieChart) {
        this.noSnippetsBottomFiller = new JPanel(new FlowLayout(0, 0, 3));
        this.noSnippetsBottomFiller.setOpaque(false);
        this.snippetsBottomFiller = new SnippetPanel.Padding();
        this.container = new Container();
        this.container.setLayout(new GridBagLayout());
        this.navPanel = new NavPanel(navArea);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.container.add((Component)this.navPanel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.insets = new Insets(5, 0, 5, 0);
        this.container.add((Component)new ChartPanel(pieChart), constraints);
        this.updateItemPresenters();
        JScrollPane contentsScrollPane = new JScrollPane(this.container, 20, 31);
        contentsScrollPane.setBorder(BorderFactory.createEmptyBorder());
        contentsScrollPane.getViewport().setOpaque(true);
        contentsScrollPane.getViewport().setBackground(UIUtils.getProfilerResultsBackground());
        this.setLayout(new BorderLayout());
        this.add((Component)contentsScrollPane, "Center");
    }

    private void refreshItemPresenters() {
        for (int i = 0; i < this.itemPresenters.size(); ++i) {
            ((ChartItemPresenter)this.itemPresenters.get(i)).refresh();
        }
    }

    private void repopulateItemPresenters() {
        ChartItemPresenter itemPresenter;
        for (int i = 0; i < this.itemPresenters.size(); ++i) {
            itemPresenter = (ChartItemPresenter)this.itemPresenters.get(i);
            this.container.remove(itemPresenter.nameLabel);
            this.container.remove(itemPresenter.valueLabel);
            this.container.remove(itemPresenter.filler);
        }
        this.itemPresenters.clear();
        for (int i = 0; i < this.pieChart.getModel().getItemCount(); ++i) {
            itemPresenter = new ChartItemPresenter(this.pieChart, i);
            this.itemPresenters.add(itemPresenter);
            int bottomInset = i == this.pieChart.getModel().getItemCount() - 1 ? 16 : 6;
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 2 + i;
            constraints.anchor = 18;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 15, bottomInset, 8);
            this.container.add((Component)itemPresenter.nameLabel, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 2 + i;
            constraints.anchor = 12;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 22, bottomInset, 0);
            this.container.add((Component)itemPresenter.valueLabel, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = 2 + i;
            constraints.anchor = 12;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, bottomInset, 8);
            this.container.add((Component)itemPresenter.filler, constraints);
        }
        this.container.revalidate();
    }

    private void updateItemPresenters() {
        if (this.pieChart.getModel().getItemCount() != this.itemPresenters.size()) {
            this.repopulateItemPresenters();
            this.updateSnippets();
        } else {
            this.refreshItemPresenters();
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner != null && !focusOwner.isShowing()) {
            this.navPanel.requestFocusInWindow();
        }
    }

    private void updateSnippets() {
        for (int i = 0; i < this.snippets.size(); ++i) {
            this.container.remove((JComponent)this.snippets.get(i));
        }
        this.container.remove(this.snippetsBottomFiller);
        this.container.remove(this.noSnippetsBottomFiller);
        for (int i = 0; i < this.snippets.size(); ++i) {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 2 + this.itemPresenters.size() + i + 1;
            constraints.gridwidth = 0;
            constraints.anchor = 18;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.container.add((Component)((JComponent)this.snippets.get(i)), constraints);
        }
        if (this.snippets.size() == 0) {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 2 + this.itemPresenters.size() + 1;
            constraints.weighty = 1.0;
            constraints.gridwidth = 0;
            constraints.anchor = 18;
            constraints.fill = 1;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.container.add((Component)this.noSnippetsBottomFiller, constraints);
        } else {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 2 + this.itemPresenters.size() + this.snippets.size() + 1;
            constraints.weighty = 1.0;
            constraints.gridwidth = 0;
            constraints.anchor = 18;
            constraints.fill = 1;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.container.add((Component)this.snippetsBottomFiller, constraints);
        }
        this.container.revalidate();
    }

    private class NavPanel
    extends JPanel {
        private final Color backgroundColor = new Color(248, 248, 248);
        private final Color focusedBackgroundColor = new Color(230, 230, 230);
        private final MouseListener focusGrabber = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NavPanel.this.requestFocusInWindow();
            }
        };

        public NavPanel(HTMLTextArea navArea) {
            this.initComponents(navArea);
        }

        private void initComponents(HTMLTextArea navArea) {
            this.setBackground(this.backgroundColor);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, new Color(214, 223, 247)), BorderFactory.createEmptyBorder(4, 0, 4, 0)));
            navArea.setHighlighter(null);
            navArea.setShowPopup(false);
            navArea.setBorder(BorderFactory.createEmptyBorder());
            navArea.setOpaque(false);
            navArea.setFocusable(false);
            this.setLayout(new GridBagLayout());
            JLabel scopeLabel = new JLabel(SCOPE_LABEL_TEXT);
            scopeLabel.setFont(UIManager.getFont("Label.font").deriveFont(1));
            scopeLabel.setOpaque(false);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = 18;
            constraints.fill = 0;
            constraints.insets = new Insets(1, 5, 1, 5);
            this.add((Component)scopeLabel, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.anchor = 18;
            constraints.fill = 1;
            constraints.insets = new Insets(1, 0, 1, 5);
            this.add((Component)navArea, constraints);
            this.setFocusable(true);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    NavPanel.this.setBackground(NavPanel.this.focusedBackgroundColor);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    NavPanel.this.setBackground(NavPanel.this.backgroundColor);
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 32) {
                        StatisticsPanel.this.navigationBackPerformer.run();
                    }
                }
            });
            this.addMouseListener(this.focusGrabber);
            scopeLabel.addMouseListener(this.focusGrabber);
            navArea.addMouseListener(this.focusGrabber);
        }
    }

    private class KeyboardAwareLabel
    extends JLabel {
        private String originalText;
        private boolean isMouseOver;

        public KeyboardAwareLabel(final Runnable actionPerformer) {
            this.setOpaque(false);
            this.setFocusable(true);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    KeyboardAwareLabel.this.updateText();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    KeyboardAwareLabel.this.updateText();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    KeyboardAwareLabel.this.requestFocusInWindow();
                    actionPerformer.run();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    KeyboardAwareLabel.this.isMouseOver = true;
                    KeyboardAwareLabel.this.updateText();
                    KeyboardAwareLabel.this.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    KeyboardAwareLabel.this.isMouseOver = false;
                    KeyboardAwareLabel.this.updateText();
                    KeyboardAwareLabel.this.setCursor(Cursor.getDefaultCursor());
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 32) {
                        actionPerformer.run();
                    }
                }
            });
        }

        @Override
        public void setText(String value) {
            this.originalText = value;
            this.updateText();
        }

        private void updateText() {
            this.setForeground(this.isFocusOwner() ? Color.RED : UIManager.getColor("Label.foreground"));
            if (this.isMouseOver) {
                super.setText("<html><nobr><u>" + this.originalText + ":" + "</u></nobr></html>");
            } else {
                super.setText("<html><nobr>" + this.originalText + ":" + "</nobr></html>");
            }
        }
    }

    private class Container
    extends JPanel
    implements Scrollable {
        public Container() {
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
            this.setBackground(UIUtils.getProfilerResultsBackground());
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(250, 500);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 50;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }
    }

    private class ColorIcon
    implements Icon {
        public static final int ICON_SIZE = 9;
        protected Color color;
        protected int height;
        protected int width;

        public ColorIcon(Color color) {
            this(9, 9, color);
        }

        public ColorIcon(int width, int height, Color color) {
            this.width = width;
            this.height = height;
            this.setColor(color);
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, this.width, this.height);
            g.setColor(Color.BLACK);
            g.drawRect(x, y, this.width - 1, this.height - 1);
        }
    }

    private class ChartPanel
    extends JPanel {
        public ChartPanel(PieChart pieChart) {
            this.initComponents(pieChart);
        }

        private void initComponents(final PieChart pieChart) {
            pieChart.setBackground(UIUtils.getProfilerResultsBackground());
            pieChart.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int clickedItem = pieChart.getItemIndexAt(e.getX(), e.getY());
                    for (int i = 0; i < StatisticsPanel.this.listeners.size(); ++i) {
                        ((Listener)StatisticsPanel.this.listeners.get(i)).itemClicked(clickedItem);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    pieChart.resetFocusedItem();
                }
            });
            pieChart.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    int focusedItem = pieChart.getItemIndexAt(e.getX(), e.getY());
                    if (focusedItem != -1 && pieChart.getModel().isSelectable(focusedItem)) {
                        pieChart.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        pieChart.setCursor(Cursor.getDefaultCursor());
                    }
                    pieChart.setFocusedItem(focusedItem);
                }
            });
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(8, 5, 8, 5));
            this.setPreferredSize(new Dimension(240, 220));
            this.setMinimumSize(new Dimension(50, 220));
            this.setLayout(new BorderLayout());
            this.add((Component)pieChart, "Center");
        }
    }

    private class ChartItemPresenter {
        public JLabel valueLabel = new JLabel("");
        public JPanel filler = new JPanel(new FlowLayout(0, 0, 3));
        public KeyboardAwareLabel nameLabel;
        private ColorIcon colorIcon = new ColorIcon(UIUtils.getProfilerResultsBackground());
        private PieChartModel model;
        private int index;

        public ChartItemPresenter(PieChart pieChart, int index) {
            this.model = pieChart.getModel();
            this.index = index;
            this.initComponents();
            this.refresh();
        }

        public void refresh() {
            double percentage = this.model.getItemValueRel(this.index);
            if (percentage == 0.0) {
                this.nameLabel.setVisible(false);
                this.valueLabel.setVisible(false);
            } else {
                this.colorIcon.setColor(this.model.getItemColor(this.index));
                this.nameLabel.setIcon(this.colorIcon);
                this.nameLabel.setText(this.model.getItemName(this.index));
                this.valueLabel.setText(this.getRelValue(percentage));
                this.nameLabel.setVisible(true);
                this.valueLabel.setVisible(true);
            }
        }

        private String getRelValue(double value) {
            int percent = (int)Math.floor(value * 100.0);
            int permille = (int)Math.round(value * 1000.0) - 10 * percent;
            return percent + "." + permille + "%";
        }

        private void initComponents() {
            this.filler.setOpaque(false);
            this.nameLabel = new KeyboardAwareLabel(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < StatisticsPanel.this.listeners.size(); ++i) {
                        ((Listener)StatisticsPanel.this.listeners.get(i)).itemClicked(ChartItemPresenter.this.index);
                    }
                }
            });
            this.valueLabel.setOpaque(false);
            this.valueLabel.setHorizontalAlignment(11);
        }
    }

    public static interface Listener {
        public void itemClicked(int var1);
    }
}

