/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeBacked;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.MethodNameTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.ExtendedTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.JTreeTablePanel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModel;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CPUSelectionHandler;
import org.netbeans.lib.profiler.ui.cpu.ScreenshotProvider;
import org.netbeans.lib.profiler.ui.cpu.SnapshotCPUResultsPanel;
import org.netbeans.lib.profiler.utils.StringUtils;

public class CCTDisplay
extends SnapshotCPUResultsPanel
implements ScreenshotProvider {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.Bundle");
    private static final String METHOD_COLUMN_NAME = messages.getString("CCTDisplay_MethodColumnName");
    private static final String METHOD_COLUMN_TOOLTIP = messages.getString("CCTDisplay_MethodColumnToolTip");
    private static final String CLASS_COLUMN_NAME = messages.getString("CCTDisplay_ClassColumnName");
    private static final String CLASS_COLUMN_TOOLTIP = messages.getString("CCTDisplay_ClassColumnToolTip");
    private static final String PACKAGE_COLUMN_NAME = messages.getString("CCTDisplay_PackageColumnName");
    private static final String PACKAGE_COLUMN_TOOLTIP = messages.getString("CCTDisplay_PackageColumnToolTip");
    private static final String TIME_REL_COLUMN_NAME = messages.getString("CCTDisplay_TimeRelColumnName");
    private static final String TIME_COLUMN_NAME = messages.getString("CCTDisplay_TimeColumnName");
    private static final String TIME_CPU_COLUMN_NAME = messages.getString("CCTDisplay_TimeCpuColumnName");
    private static final String INVOCATIONS_COLUMN_NAME = messages.getString("CCTDisplay_InvocationsColumnName");
    private static final String TIME_REL_COLUMN_TOOLTIP = messages.getString("CCTDisplay_TimeRelColumnToolTip");
    private static final String TIME_COLUMN_TOOLTIP = messages.getString("CCTDisplay_TimeColumnToolTip");
    private static final String TIME_CPU_COLUMN_TOOLTIP = messages.getString("CCTDisplay_TimeCpuColumnToolTip");
    private static final String INVOCATIONS_COLUMN_TOOLTIP = messages.getString("CCTDisplay_InvocationsColumnToolTip");
    private static final String TREETABLE_ACCESS_NAME = messages.getString("CCTDisplay_TreeTableAccessName");
    private static final boolean DEBUG = System.getProperty("org.netbeans.lib.profiler.ui.cpu.CCTDisplay") != null;
    protected JTreeTable treeTable;
    protected JTreeTablePanel treeTablePanel;
    protected boolean sortOrder;
    protected int sortingColumn;
    private AbstractTreeTableModel abstractTreeTableModel;
    private CPUSelectionHandler selectionHandler;
    private EnhancedTreeCellRenderer enhancedTreeCellRenderer = new MethodNameTreeCellRenderer();
    private ExtendedTreeTableModel treeTableModel;
    private ImageIcon leafIcon = new ImageIcon(CCTDisplay.class.getResource("/org/netbeans/lib/profiler/ui/resources/leaf.png"));
    private ImageIcon nodeIcon = new ImageIcon(CCTDisplay.class.getResource("/org/netbeans/lib/profiler/ui/resources/node.png"));
    private JButton cornerButton;
    private int minNamesColumnWidth;

    public CCTDisplay(CPUResUserActionsHandler actionsHandler) {
        this(actionsHandler, null);
    }

    public CCTDisplay(CPUResUserActionsHandler actionsHandler, CPUSelectionHandler selectionHandler) {
        super(actionsHandler);
        this.selectionHandler = selectionHandler;
        this.enhancedTreeCellRenderer.setLeafIcon(this.leafIcon);
        this.enhancedTreeCellRenderer.setClosedIcon(this.nodeIcon);
        this.enhancedTreeCellRenderer.setOpenIcon(this.nodeIcon);
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        this.cornerPopup = new JPopupMenu();
        this.cornerButton = this.createHeaderPopupCornerButton(this.cornerPopup);
        this.setDefaultSorting();
    }

    public void exportData(int exportedFileType, ExportDataDumper eDD, boolean combine, String viewName) {
        this.percentFormat.setMaximumFractionDigits(2);
        this.percentFormat.setMinimumFractionDigits(2);
        PrestimeCPUCCTNodeBacked.setPercentFormat((NumberFormat)this.percentFormat);
        switch (exportedFileType) {
            case 1: {
                eDD.dumpData(this.getCSVHeader(","));
                ((PrestimeCPUCCTNodeBacked)this.abstractTreeTableModel.getRoot()).exportCSVData(",", exportedFileType, eDD);
                if (combine) break;
                eDD.close();
                break;
            }
            case 2: {
                eDD.dumpData(this.getCSVHeader(";"));
                ((PrestimeCPUCCTNodeBacked)this.abstractTreeTableModel.getRoot()).exportCSVData(";", exportedFileType, eDD);
                if (combine) break;
                eDD.close();
                break;
            }
            case 3: {
                eDD.dumpData(this.getXMLHeader(combine, viewName));
                ((PrestimeCPUCCTNodeBacked)this.abstractTreeTableModel.getRoot()).exportXMLData(eDD, "  ");
                if (!combine) {
                    eDD.dumpDataAndClose(this.getXMLFooter(combine));
                    break;
                }
                eDD.dumpData(this.getXMLFooter(combine));
                break;
            }
            case 4: {
                eDD.dumpData(this.getHTMLHeader(viewName));
                ((PrestimeCPUCCTNodeBacked)this.abstractTreeTableModel.getRoot()).exportHTMLData(eDD, 0);
                if (!combine) {
                    eDD.dumpDataAndClose(this.getHTMLFooter(combine));
                    break;
                }
                eDD.dumpData(this.getHTMLFooter(combine));
            }
        }
        this.percentFormat.setMaximumFractionDigits(1);
        this.percentFormat.setMinimumFractionDigits(0);
    }

    private StringBuffer getCSVHeader(String separator) {
        String newLine = "\r\n";
        String quote = "\"";
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.columnCount; ++i) {
            result.append(quote + this.columnNames[i] + quote + separator);
        }
        result.append(newLine);
        return result;
    }

    private StringBuffer getHTMLHeader(String viewName) {
        StringBuffer result = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + viewName + "</TITLE><style type=\"text/css\">pre.method{overflow:auto;width:600;height:30;vertical-align:baseline}pre.parent{overflow:auto;width:400;height:30;vertical-align:baseline}td.method{text-align:left;width:600}td.parent{text-align:left;width:400}td.right{text-align:right;white-space:nowrap}</style></HEAD><BODY><table border=\"1\"><tr>");
        result.append("<th>" + this.columnNames[0] + "</th><th>" + this.columnNames[1] + "</th><th>" + this.columnNames[2] + "</th><th>" + this.columnNames[3] + "</th></tr>");
        return result;
    }

    private StringBuffer getHTMLFooter(boolean combine) {
        if (combine) {
            return new StringBuffer("</TABLE>");
        }
        return new StringBuffer("</TABLE></BODY></HTML>");
    }

    private StringBuffer getXMLHeader(boolean combine, String viewName) {
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + newline + "<ExportedView Name=\"" + viewName + "\" type=\"" + (combine ? "combined" : "tree") + "\">" + newline + "<tree>" + newline);
        return result;
    }

    private StringBuffer getXMLFooter(boolean combine) {
        String newline = System.getProperty("line.separator");
        StringBuffer result = !combine ? new StringBuffer("</tree>" + newline + "</ExportedView>") : new StringBuffer("</tree>" + newline + newline);
        return result;
    }

    @Override
    public int getCurrentThreadId() {
        return -10;
    }

    @Override
    public BufferedImage getCurrentViewScreenshot(boolean onlyVisibleArea) {
        if (this.treeTablePanel == null || this.treeTable == null) {
            return null;
        }
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.treeTablePanel.getScrollPane());
        }
        return UIUtils.createScreenshot(this.treeTable);
    }

    public void setDefaultSorting() {
        this.setSorting(1, false);
    }

    @Override
    public String getDefaultViewName() {
        return "cpu-calltree";
    }

    public void setFindString(String findString) {
        this.treeTable.setFindParameters(findString, 0);
    }

    public String getFindString() {
        return this.treeTable.getFindString();
    }

    public boolean isFindStringDefined() {
        return this.treeTable.isFindStringDefined();
    }

    public Object getResultsViewReference() {
        return this.treeTable;
    }

    public void setSorting(int sColumn, boolean sOrder) {
        if (sColumn == -1) {
            this.setDefaultSorting();
        } else {
            this.sortingColumn = sColumn;
            this.sortOrder = sOrder;
        }
    }

    @Override
    public int getSortingColumn() {
        if (this.treeTable == null || this.treeTableModel == null) {
            return -1;
        }
        return this.treeTableModel.getRealColumn(this.treeTable.getSortingColumn());
    }

    @Override
    public boolean getSortingOrder() {
        if (this.treeTable == null) {
            return false;
        }
        return this.treeTable.getSortingOrder();
    }

    public void addResultsViewFocusListener(FocusListener listener) {
        this.treeTable.addFocusListener(listener);
    }

    public boolean findFirst() {
        return this.treeTable.findFirst();
    }

    public boolean findNext() {
        return this.treeTable.findNext();
    }

    public boolean findPrevious() {
        return this.treeTable.findPrevious();
    }

    @Override
    public boolean fitsVisibleArea() {
        return !this.treeTablePanel.getScrollPane().getVerticalScrollBar().isEnabled();
    }

    @Override
    public void prepareResults() {
        int currentColumnCount;
        int n = currentColumnCount = this.snapshot.isCollectingTwoTimeStamps() ? 5 : 4;
        if (DEBUG) {
            ++this.columnCount;
        }
        if (this.columnCount != currentColumnCount) {
            this.initColumnsData();
        } else if (this.treeTable != null) {
            this.saveColumnsData();
        }
        if (this.treeTable != null) {
            this.sortingColumn = this.treeTable.getSortingColumn();
        }
        this.reset();
        this.initFirstColumnName();
        this.abstractTreeTableModel = new AbstractTreeTableModel((CCTNode)this.snapshot.getRootNode(this.currentView), this.sortingColumn, this.sortOrder){

            @Override
            public int getColumnCount() {
                return CCTDisplay.this.columnCount;
            }

            @Override
            public String getColumnName(int column) {
                return CCTDisplay.this.columnNames[column];
            }

            @Override
            public Class getColumnClass(int column) {
                if (column == 0) {
                    return TreeTableModel.class;
                }
                return Object.class;
            }

            @Override
            public Object getValueAt(Object node, int column) {
                if (!CCTDisplay.this.snapshot.isCollectingTwoTimeStamps() && column > 2) {
                    ++column;
                }
                PrestimeCPUCCTNode pNode = (PrestimeCPUCCTNode)node;
                switch (column) {
                    case 0: {
                        return pNode;
                    }
                    case 1: {
                        return this.getNodeTimeRel(pNode);
                    }
                    case 2: {
                        return this.getNodeTime(pNode);
                    }
                    case 3: {
                        return this.getNodeSecondaryTime(pNode);
                    }
                    case 4: {
                        return this.getNodeInvocations(pNode);
                    }
                    case 5: {
                        return this.getNodeMethodId(pNode);
                    }
                }
                return null;
            }

            @Override
            public String getColumnToolTipText(int col) {
                return CCTDisplay.this.columnToolTips[col];
            }

            private Float getNodeTimeRel(PrestimeCPUCCTNode pNode) {
                return new Float(pNode.getTotalTime0InPerCent());
            }

            private String getNodeTime(PrestimeCPUCCTNode pNode) {
                return StringUtils.mcsTimeToString((long)pNode.getTotalTime0()) + " ms (" + CCTDisplay.this.percentFormat.format(pNode.getTotalTime0InPerCent() / 100.0f) + ")";
            }

            private String getNodeWaitTime(PrestimeCPUCCTNode pNode) {
                return StringUtils.mcsTimeToString((long)pNode.getWaitTime0()) + " ms";
            }

            private String getNodeSleepTime(PrestimeCPUCCTNode pNode) {
                return StringUtils.mcsTimeToString((long)pNode.getSleepTime0()) + " ms";
            }

            private String getNodeSecondaryTime(PrestimeCPUCCTNode pNode) {
                return StringUtils.mcsTimeToString((long)pNode.getTotalTime1()) + " ms";
            }

            private Integer getNodeInvocations(PrestimeCPUCCTNode pNode) {
                return new Integer(pNode.getNCalls());
            }

            private Integer getNodeMethodId(PrestimeCPUCCTNode pNode) {
                return new Integer(pNode.getMethodId());
            }

            @Override
            public void sortByColumn(int column, boolean order) {
                CCTDisplay.this.sortOrder = order;
                if (!CCTDisplay.this.snapshot.isCollectingTwoTimeStamps() && column > 2) {
                    ++column;
                }
                PrestimeCPUCCTNode pRoot = (PrestimeCPUCCTNode)this.root;
                switch (column) {
                    case 0: {
                        pRoot.sortChildren(1, order);
                        break;
                    }
                    case 1: {
                        pRoot.sortChildren(2, order);
                        break;
                    }
                    case 2: {
                        pRoot.sortChildren(2, order);
                        break;
                    }
                    case 3: {
                        pRoot.sortChildren(3, order);
                        break;
                    }
                    case 4: {
                        pRoot.sortChildren(4, order);
                    }
                }
            }

            @Override
            public boolean getInitialSorting(int column) {
                return column == 0;
            }
        };
        this.treeTableModel = new ExtendedTreeTableModel(this.abstractTreeTableModel);
        if (this.columnsVisibility != null) {
            this.treeTableModel.setColumnsVisibility(this.columnsVisibility);
        }
        this.treeTable = new JTreeTable(this.treeTableModel){

            @Override
            public void doLayout() {
                int columnsWidthsSum = 0;
                int realFirstColumn = -1;
                TableColumnModel colModel = this.getColumnModel();
                for (int i = 0; i < CCTDisplay.this.treeTableModel.getColumnCount(); ++i) {
                    int index = CCTDisplay.this.treeTableModel.getRealColumn(i);
                    if (index == 0) {
                        realFirstColumn = i;
                        continue;
                    }
                    columnsWidthsSum += colModel.getColumn(i).getPreferredWidth();
                }
                if (realFirstColumn != -1) {
                    colModel.getColumn(realFirstColumn).setPreferredWidth(Math.max(this.getWidth() - columnsWidthsSum, CCTDisplay.this.minNamesColumnWidth));
                }
                super.doLayout();
            }
        };
        this.treeTable.getAccessibleContext().setAccessibleName(TREETABLE_ACCESS_NAME);
        this.treeTable.setRowSelectionAllowed(true);
        this.treeTable.setSelectionMode(0);
        this.treeTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.treeTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.treeTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.treeTable.setShowHorizontalLines(false);
        this.treeTable.setShowVerticalLines(true);
        this.treeTable.setRowMargin(0);
        this.treeTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.treeTable.getTree().setRootVisible(false);
        this.treeTable.getTree().setShowsRootHandles(true);
        this.treeTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.treeTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CCTDisplay.this.performDefaultAction();
            }
        });
        HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(0));
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.treeTable.setFocusTraversalKeys(0, keys);
        keys = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(1));
        keys.add(KeyStroke.getKeyStroke(9, 1));
        this.treeTable.setFocusTraversalKeys(1, keys);
        this.setColumnsData();
        UIUtils.autoExpandRoot(this.treeTable.getTree(), 2);
        UIUtils.makeTreeAutoExpandable(this.treeTable.getTree(), 2);
        this.treeTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int selectedRow;
                if ((e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) && (selectedRow = CCTDisplay.this.treeTable.getSelectedRow()) != -1) {
                    CCTDisplay.this.popupPath = CCTDisplay.this.treeTable.getTree().getPathForRow(selectedRow);
                    PrestimeCPUCCTNode node = (PrestimeCPUCCTNode)CCTDisplay.this.popupPath.getLastPathComponent();
                    CCTDisplay.this.enableDisablePopup(node);
                    Rectangle cellRect = CCTDisplay.this.treeTable.getCellRect(selectedRow, 0, false);
                    CCTDisplay.this.callGraphPopupMenu.show(e.getComponent(), cellRect.x + CCTDisplay.this.treeTable.getSize().width > 50 ? 50 : 5, cellRect.y);
                }
            }
        });
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getModifiers() == 4) {
                    CCTDisplay.this.popupPath = CCTDisplay.this.treeTable.getTree().getPathForRow(CCTDisplay.this.treeTable.rowAtPoint(e.getPoint()));
                    if (CCTDisplay.this.popupPath != null) {
                        CCTDisplay.this.treeTable.getTree().setSelectionPath(CCTDisplay.this.popupPath);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                CCTDisplay.this.popupPath = CCTDisplay.this.treeTable.getTree().getPathForRow(CCTDisplay.this.treeTable.rowAtPoint(e.getPoint()));
                if (CCTDisplay.this.popupPath == null) {
                    if (e.getModifiers() == 4) {
                        CCTDisplay.this.treeTable.getTree().clearSelection();
                    }
                } else {
                    PrestimeCPUCCTNode node = (PrestimeCPUCCTNode)CCTDisplay.this.popupPath.getLastPathComponent();
                    CCTDisplay.this.enableDisablePopup(node);
                    if (e.getModifiers() == 4) {
                        CCTDisplay.this.callGraphPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    } else if (e.getModifiers() == 16 && e.getClickCount() == 2 && CCTDisplay.this.treeTableModel.isLeaf(CCTDisplay.this.popupPath.getPath()[CCTDisplay.this.popupPath.getPath().length - 1])) {
                        CCTDisplay.this.showSourceForMethod(CCTDisplay.this.popupPath);
                    }
                }
            }
        });
        this.treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = CCTDisplay.this.treeTable.getSelectedRow();
                if (selectedRow == -1) {
                    return;
                }
                CCTDisplay.this.popupPath = CCTDisplay.this.treeTable.getTree().getPathForRow(selectedRow);
                PrestimeCPUCCTNode node = (PrestimeCPUCCTNode)CCTDisplay.this.popupPath.getLastPathComponent();
                if (CCTDisplay.this.selectionHandler != null) {
                    CCTDisplay.this.selectionHandler.methodSelected(node.getThreadId(), node.getMethodId(), CCTDisplay.this.currentView);
                }
            }
        });
        this.treeTablePanel = new JTreeTablePanel(this.treeTable);
        this.treeTablePanel.setCorner("UPPER_RIGHT_CORNER", this.cornerButton);
        this.add((Component)this.treeTablePanel, "Center");
    }

    public void removeResultsViewFocusListener(FocusListener listener) {
        this.treeTable.removeFocusListener(listener);
    }

    @Override
    public void requestFocus() {
        if (this.treeTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CCTDisplay.this.treeTable.requestFocus();
                }
            });
        }
    }

    @Override
    public void reset() {
        if (this.treeTablePanel != null) {
            this.remove(this.treeTablePanel);
            this.treeTablePanel = null;
        }
        this.treeTable = null;
        this.abstractTreeTableModel = null;
        this.treeTableModel = null;
    }

    public boolean silentlyFindFirst() {
        return this.treeTable.silentlyFindFirst();
    }

    @Override
    protected String getSelectedMethodName() {
        if (this.treeTable == null || this.treeTableModel == null) {
            return null;
        }
        if (this.treeTable.getSelectedRow() == -1) {
            return null;
        }
        PrestimeCPUCCTNode pNode = (PrestimeCPUCCTNode)this.treeTable.getTree().getSelectionPath().getLastPathComponent();
        if (pNode.isSelfTimeNode()) {
            pNode = (PrestimeCPUCCTNode)pNode.getParent();
        }
        if (pNode.isThreadNode()) {
            pNode = (PrestimeCPUCCTNode)pNode.getChildren()[0];
        }
        return this.treeTableModel.getValueAt(pNode, 0).toString();
    }

    @Override
    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.columnCount; ++i) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(this.columnNames[i]);
            menuItem.setActionCommand(new Integer(i).toString());
            this.addMenuItemListener(menuItem);
            if (this.treeTable != null) {
                menuItem.setState(this.treeTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    menuItem.setEnabled(false);
                }
            } else {
                menuItem.setState(true);
            }
            this.cornerPopup.add(menuItem);
        }
        this.cornerPopup.pack();
    }

    private void setColumnsData() {
        TableColumnModel colModel = this.treeTable.getColumnModel();
        this.treeTable.setTreeCellRenderer(this.enhancedTreeCellRenderer);
        colModel.getColumn(0).setPreferredWidth(this.minNamesColumnWidth);
        for (int i = 0; i < this.treeTableModel.getColumnCount(); ++i) {
            int index = this.treeTableModel.getRealColumn(i);
            if (index == 0) continue;
            colModel.getColumn(i).setPreferredWidth(this.columnWidths[index - 1]);
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[index]);
        }
    }

    private void addMenuItemListener(JCheckBoxMenuItem menuItem) {
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean sortResults = false;
                int column = Integer.parseInt(e.getActionCommand());
                CCTDisplay.this.sortingColumn = CCTDisplay.this.treeTable.getSortingColumn();
                int realSortingColumn = CCTDisplay.this.treeTableModel.getRealColumn(CCTDisplay.this.sortingColumn);
                boolean isColumnVisible = CCTDisplay.this.treeTableModel.isRealColumnVisible(column);
                if (isColumnVisible && column == realSortingColumn) {
                    CCTDisplay.this.sortingColumn = CCTDisplay.this.sortingColumn + 1 == CCTDisplay.this.treeTableModel.getColumnCount() ? CCTDisplay.this.sortingColumn - 1 : CCTDisplay.this.sortingColumn + 1;
                    realSortingColumn = CCTDisplay.this.treeTableModel.getRealColumn(CCTDisplay.this.sortingColumn);
                    sortResults = true;
                }
                CCTDisplay.this.treeTableModel.setRealColumnVisibility(column, !isColumnVisible);
                CCTDisplay.this.treeTable.createDefaultColumnsFromModel();
                CCTDisplay.this.treeTable.updateTreeTableHeader();
                CCTDisplay.this.sortingColumn = CCTDisplay.this.treeTableModel.getVirtualColumn(realSortingColumn);
                if (sortResults) {
                    CCTDisplay.this.sortOrder = CCTDisplay.this.treeTableModel.getInitialSorting(CCTDisplay.this.sortingColumn);
                    CCTDisplay.this.treeTableModel.sortByColumn(CCTDisplay.this.sortingColumn, CCTDisplay.this.sortOrder);
                    CCTDisplay.this.treeTable.updateTreeTable();
                }
                CCTDisplay.this.treeTable.setSortingColumn(CCTDisplay.this.sortingColumn);
                CCTDisplay.this.treeTable.setSortingOrder(CCTDisplay.this.sortOrder);
                CCTDisplay.this.treeTable.getTableHeader().repaint();
                CCTDisplay.this.setColumnsData();
            }
        });
    }

    private void enableDisablePopup(PrestimeCPUCCTNode node) {
        this.popupShowSource.setEnabled(this.isShowSourceAvailable() && node.getThreadId() != -1 && node.getMethodId() > 0);
        this.popupShowSubtree.setEnabled(node.getThreadId() != -1 && node.getMethodId() > 0);
        this.popupShowReverse.setEnabled(node.getThreadId() != -1 && node.getMethodId() > 0);
        this.popupAddToRoots.setEnabled(this.isAddToRootsAvailable() && node.getThreadId() != -1 && node.getMethodId() > 0);
        this.popupFind.setEnabled(node.getThreadId() != -1 && node.getMethodId() > 0);
        if (this.selectionHandler != null) {
            this.selectionHandler.methodSelected(node.getThreadId(), node.getMethodId(), this.currentView);
        }
    }

    private void initColumnsData() {
        int n = this.columnCount = this.snapshot.isCollectingTwoTimeStamps() ? 5 : 4;
        if (DEBUG) {
            ++this.columnCount;
        }
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnsVisibility = null;
        int idx = 0;
        this.columnNames = new String[this.columnCount];
        this.columnNames[idx++] = "";
        this.columnNames[idx++] = TIME_REL_COLUMN_NAME;
        this.columnNames[idx++] = TIME_COLUMN_NAME;
        if (this.snapshot.isCollectingTwoTimeStamps()) {
            this.columnNames[idx++] = TIME_CPU_COLUMN_NAME;
        }
        this.columnNames[idx++] = INVOCATIONS_COLUMN_NAME;
        if (DEBUG) {
            this.columnNames[idx++] = "JMethodID";
        }
        idx = 0;
        this.columnToolTips = new String[this.columnCount];
        this.columnToolTips[idx++] = "";
        this.columnToolTips[idx++] = TIME_REL_COLUMN_TOOLTIP;
        this.columnToolTips[idx++] = TIME_COLUMN_TOOLTIP;
        if (this.snapshot.isCollectingTwoTimeStamps()) {
            this.columnToolTips[idx++] = TIME_CPU_COLUMN_TOOLTIP;
        }
        this.columnToolTips[idx++] = INVOCATIONS_COLUMN_TOOLTIP;
        if (DEBUG) {
            this.columnToolTips[idx++] = "JMethodID for the method";
        }
        int maxWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 12;
        CustomBarCellRenderer customBarCellRenderer = new CustomBarCellRenderer(0L, 100L);
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnRenderers[0] = null;
        this.columnWidths[0] = maxWidth;
        this.columnRenderers[1] = customBarCellRenderer;
        this.columnWidths[1] = maxWidth;
        this.columnRenderers[2] = labelBracketTableCellRenderer;
        for (int i = 3; i < this.columnCount; ++i) {
            this.columnWidths[i - 1] = maxWidth;
            this.columnRenderers[i] = labelTableCellRenderer;
        }
    }

    private void initFirstColumnName() {
        switch (this.currentView) {
            case 0: {
                this.columnNames[0] = METHOD_COLUMN_NAME;
                this.columnToolTips[0] = METHOD_COLUMN_TOOLTIP;
                break;
            }
            case 1: {
                this.columnNames[0] = CLASS_COLUMN_NAME;
                this.columnToolTips[0] = CLASS_COLUMN_TOOLTIP;
                break;
            }
            case 2: {
                this.columnNames[0] = PACKAGE_COLUMN_NAME;
                this.columnToolTips[0] = PACKAGE_COLUMN_TOOLTIP;
            }
        }
        if (this.treeTable != null) {
            this.treeTable.getTableHeader().repaint();
        }
    }

    private void saveColumnsData() {
        TableColumnModel colModel = this.treeTable.getColumnModel();
        for (int i = 0; i < this.treeTableModel.getColumnCount(); ++i) {
            int index = this.treeTableModel.getRealColumn(i);
            if (index == 0) continue;
            this.columnWidths[index - 1] = colModel.getColumn(i).getPreferredWidth();
        }
        this.columnsVisibility = null;
        this.columnsVisibility = this.treeTableModel.getColumnsVisibility();
    }
}

