/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts.xy;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.RoundBorder;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipModel;

public class ProfilerXYTooltipPainter
extends JPanel {
    private JLabel caption;
    private JLabel[] valuePainters;
    private JLabel[] unitsPainters;
    private JLabel[] extraValuePainters;
    private JLabel[] extraUnitsPainters;
    private ProfilerXYTooltipModel model;
    private boolean initialized;

    public ProfilerXYTooltipPainter(float lineWidth, Color lineColor, Color fillColor, ProfilerXYTooltipModel model) {
        this.model = model;
        this.initialized = false;
        RoundBorder rb = new RoundBorder(lineWidth, lineColor, fillColor, 10, 7);
        Border eb = BorderFactory.createEmptyBorder(0, 5, 0, 5);
        this.setBorder(BorderFactory.createCompoundBorder((Border)rb, eb));
    }

    public void update(List<ItemSelection> selectedItems) {
        if (!this.initialized) {
            this.initComponents();
        }
        int rowsCount = this.model.getRowsCount();
        if (selectedItems.size() != rowsCount) {
            throw new IllegalStateException("Rows and selected items don't match");
        }
        XYItemSelection selection = (XYItemSelection)selectedItems.get(0);
        long timestamp = selection.getItem().getXValue(selection.getValueIndex());
        this.caption.setText(this.model.getTimeValue(timestamp));
        for (int i = 0; i < rowsCount; ++i) {
            XYItemSelection sel = (XYItemSelection)selectedItems.get(i);
            long itemValue = sel.getItem().getYValue(sel.getValueIndex());
            this.valuePainters[i].setText(this.model.getRowValue(i, itemValue));
            this.unitsPainters[i].setText(this.model.getRowUnits(i, itemValue));
        }
        int extraRowsCount = this.model.getExtraRowsCount();
        for (int i = 0; i < extraRowsCount; ++i) {
            this.extraValuePainters[i].setText(this.model.getExtraRowValue(i));
            this.extraUnitsPainters[i].setText(this.model.getExtraRowUnits(i));
        }
    }

    private void initComponents() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.caption = new JLabel();
        float defaultFontSize = this.caption.getFont().getSize2D();
        this.caption.setFont(this.caption.getFont().deriveFont(defaultFontSize - 1.0f));
        this.caption.setForeground(Color.DARK_GRAY);
        this.caption.setOpaque(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.caption, constraints);
        int count = this.model.getRowsCount();
        this.valuePainters = new JLabel[count];
        this.unitsPainters = new JLabel[count];
        for (int i = 0; i < count; ++i) {
            JLabel unitLabel;
            JLabel valueLabel;
            JLabel itemLabel = new JLabel();
            itemLabel.setText(this.model.getRowName(i));
            itemLabel.setFont(itemLabel.getFont().deriveFont(defaultFontSize + 1.0f));
            itemLabel.setForeground(this.model.getRowColor(i));
            itemLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = i + 1;
            constraints.gridwidth = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)itemLabel, constraints);
            this.valuePainters[i] = valueLabel = new JLabel();
            valueLabel.setFont(itemLabel.getFont().deriveFont(1, defaultFontSize + 1.0f));
            valueLabel.setForeground(this.model.getRowColor(i));
            valueLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = i + 1;
            constraints.gridwidth = 1;
            constraints.anchor = 12;
            constraints.insets = new Insets(0, 8, 0, 0);
            this.add((Component)valueLabel, constraints);
            this.unitsPainters[i] = unitLabel = new JLabel();
            unitLabel.setFont(unitLabel.getFont().deriveFont(defaultFontSize + 1.0f));
            unitLabel.setForeground(this.model.getRowColor(i));
            unitLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = i + 1;
            constraints.gridwidth = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(0, 4, 0, 0);
            this.add((Component)unitLabel, constraints);
            JPanel valueSpacer = new JPanel(null);
            valueSpacer.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 3;
            constraints.gridy = i + 1;
            constraints.weightx = 1.0;
            constraints.gridwidth = 0;
            constraints.anchor = 12;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)valueSpacer, constraints);
        }
        int extraCount = this.model.getExtraRowsCount();
        if (extraCount > 0) {
            JPanel separator = new JPanel(null){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, 1);
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            separator.setBackground(Color.GRAY);
            separator.setOpaque(true);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = count + 1;
            constraints.weighty = 1.0;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 18;
            constraints.insets = new Insets(7, 0, 7, 0);
            this.add((Component)separator, constraints);
        }
        this.extraValuePainters = new JLabel[extraCount];
        this.extraUnitsPainters = new JLabel[extraCount];
        for (int i = 0; i < extraCount; ++i) {
            JLabel extraUnitLabel;
            JLabel extraValueLabel;
            JLabel extraItemLabel = new JLabel();
            extraItemLabel.setText(this.model.getExtraRowName(i));
            extraItemLabel.setFont(extraItemLabel.getFont().deriveFont(defaultFontSize - 1.0f));
            extraItemLabel.setForeground(this.model.getRowColor(i));
            extraItemLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = count + i + 2;
            constraints.gridwidth = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)extraItemLabel, constraints);
            this.extraValuePainters[i] = extraValueLabel = new JLabel();
            extraValueLabel.setFont(extraItemLabel.getFont().deriveFont(1, defaultFontSize - 1.0f));
            extraValueLabel.setForeground(this.model.getExtraRowColor(i));
            extraValueLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = count + i + 2;
            constraints.gridwidth = 1;
            constraints.anchor = 12;
            constraints.insets = new Insets(0, 8, 0, 0);
            this.add((Component)extraValueLabel, constraints);
            this.extraUnitsPainters[i] = extraUnitLabel = new JLabel();
            extraUnitLabel.setFont(extraUnitLabel.getFont().deriveFont(defaultFontSize - 1.0f));
            extraUnitLabel.setForeground(this.model.getExtraRowColor(i));
            extraUnitLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = count + i + 2;
            constraints.gridwidth = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(0, 4, 0, 0);
            this.add((Component)extraUnitLabel, constraints);
            JPanel extraValueSpacer = new JPanel(null);
            extraValueSpacer.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 3;
            constraints.gridy = count + i + 2;
            constraints.weightx = 1.0;
            constraints.gridwidth = 0;
            constraints.anchor = 12;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)extraValueSpacer, constraints);
        }
        this.initialized = true;
    }
}

