/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf.embedding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.html.editor.gsf.embedding.CssEmbeddingProvider;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.WebUtils;

public class CssHtmlTranslator
implements CssEmbeddingProvider.Translator {
    private static final Logger LOGGER = Logger.getLogger(CssHtmlTranslator.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    public static final String CSS_MIME_TYPE = "text/x-css";
    public static final String HTML_MIME_TYPE = "text/html";
    private static final Pattern CLASSES_LIST_PATTERN = Pattern.compile("[^\\s,]*");
    static final Pattern CDATA_FILTER_PATTERN = Pattern.compile(".*<!\\[CDATA\\[\\s*(\\*/)?\\s*(<!--)?(.*?)(-->)?\\s*(/\\*)?\\s*]]>.*", 40);
    static final int CDATA_BODY_GROUP_INDEX = 3;
    protected static final String END_OF_LAST_SEQUENCE = "end_of_last_sequence";
    protected static final String IN_STYLE = "in_style";
    protected static final String IN_INLINED_STYLE = "in_inlined_style";
    protected static final String CURRENT_TAG = "current_tag";
    protected static final String CURRENT_ATTR = "current_attr";
    private static final String QUTE_CUT = "quote_cut";
    private static final String LINK_TAG_NAME = "link";
    private static final String HREF_ATTR_NAME = "href";
    private static final String HREF_ATTR_REL = "rel";
    private static final String HREF_ATTR_TYPE = "type";

    @Override
    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        TokenHierarchy th = snapshot.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(HTMLTokenId.language());
        HashMap<String, Object> state = new HashMap<String, Object>(6);
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        this.extractCssFromHTML(snapshot, (TokenSequence<HTMLTokenId>)ts, state, embeddings);
        return embeddings;
    }

    protected void extractCssFromHTML(Snapshot snapshot, TokenSequence<HTMLTokenId> ts, HashMap<String, Object> state, List<Embedding> embeddings) {
        while (ts.moveNext()) {
            String valueCssType;
            Token htmlToken = ts.token();
            TokenId htmlId = htmlToken.id();
            if (htmlId == HTMLTokenId.STYLE) {
                state.put(IN_STYLE, Boolean.TRUE);
                int sourceStart = ts.offset();
                int length = htmlToken.length();
                Matcher matcher = CDATA_FILTER_PATTERN.matcher(htmlToken.text());
                if (matcher.matches()) {
                    sourceStart += matcher.start(3);
                    length = matcher.end(3) - matcher.start(3);
                }
                embeddings.add(snapshot.create(sourceStart, length, CSS_MIME_TYPE));
                continue;
            }
            state.remove(IN_STYLE);
            if (state.get(IN_INLINED_STYLE) != null) {
                if (htmlId == HTMLTokenId.VALUE_CSS) {
                    int sourceStart = ts.offset();
                    CharSequence text = htmlToken.text();
                    int tokenLength = htmlToken.length();
                    if (CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)"\"") || CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)"'")) {
                        --tokenLength;
                    }
                    embeddings.add(snapshot.create(sourceStart, tokenLength, CSS_MIME_TYPE));
                } else {
                    state.remove(IN_INLINED_STYLE);
                    int sourceStart = ts.offset();
                    if (state.get(QUTE_CUT) != null) {
                        --sourceStart;
                    }
                    state.remove(QUTE_CUT);
                    embeddings.add(snapshot.create((CharSequence)";\n}\n", CSS_MIME_TYPE));
                }
            }
            if (htmlId == HTMLTokenId.TAG_OPEN) {
                state.put(CURRENT_TAG, ((Object)htmlToken.text()).toString());
                continue;
            }
            if (htmlId == HTMLTokenId.TAG_CLOSE_SYMBOL || htmlId == HTMLTokenId.TEXT) {
                state.remove(CURRENT_TAG);
                continue;
            }
            if (htmlId == HTMLTokenId.ARGUMENT) {
                state.put(CURRENT_ATTR, ((Object)htmlToken.text()).toString());
                continue;
            }
            if (htmlId == HTMLTokenId.VALUE) {
                String currentTag = (String)state.get(CURRENT_TAG);
                String currentAttr = (String)state.get(CURRENT_ATTR);
                if (currentTag == null || currentAttr == null) continue;
                boolean isLinkTag = LINK_TAG_NAME.equalsIgnoreCase(currentTag.toLowerCase(Locale.ENGLISH));
                boolean isHrefAttr = HREF_ATTR_NAME.equals(currentAttr.toLowerCase(Locale.ENGLISH));
                if (!isLinkTag || !isHrefAttr) continue;
                String unquotedValue = WebUtils.unquotedValue((CharSequence)((Object)htmlToken.text()).toString().toString());
                StringBuilder buf = new StringBuilder();
                buf.append("@import \"");
                buf.append(unquotedValue);
                buf.append("\";");
                embeddings.add(0, snapshot.create((CharSequence)buf, CSS_MIME_TYPE));
                continue;
            }
            if (htmlId != HTMLTokenId.VALUE_CSS) continue;
            int sourceStart = ts.offset();
            String text = ((Object)htmlToken.text()).toString();
            if (text.startsWith("\"") || text.startsWith("'")) {
                ++sourceStart;
                text = text.substring(1);
            }
            int sourceEnd = sourceStart + text.length();
            if (text.endsWith("\"") || text.endsWith("'")) {
                --sourceEnd;
                state.put(QUTE_CUT, Boolean.TRUE);
                text = text.substring(0, text.length() - 1);
            }
            if ((valueCssType = (String)htmlToken.getProperty((Object)"valueCssType")) != null) {
                if (text.indexOf(".") != -1 || text.indexOf(":") != -1) continue;
                embeddings.add(snapshot.create((CharSequence)"\n ", CSS_MIME_TYPE));
                String prefix = "class".equals(valueCssType) ? " ." : " #";
                Matcher matcher = CLASSES_LIST_PATTERN.matcher(text);
                boolean classExists = false;
                while (matcher.find()) {
                    int end;
                    int start = matcher.start();
                    if (start == (end = matcher.end())) continue;
                    embeddings.add(snapshot.create((CharSequence)prefix, CSS_MIME_TYPE));
                    int start_in_document = sourceStart + start;
                    int lenght = end - start;
                    embeddings.add(snapshot.create(start_in_document, lenght, CSS_MIME_TYPE));
                    classExists = true;
                }
                if (!classExists) {
                    embeddings.add(snapshot.create((CharSequence)prefix, CSS_MIME_TYPE));
                    embeddings.add(snapshot.create(sourceStart, 0, CSS_MIME_TYPE));
                }
                embeddings.add(snapshot.create((CharSequence)"{}", CSS_MIME_TYPE));
                continue;
            }
            embeddings.add(snapshot.create((CharSequence)"\n SELECTOR {\n\t", CSS_MIME_TYPE));
            embeddings.add(snapshot.create(sourceStart, sourceEnd - sourceStart, CSS_MIME_TYPE));
            state.put(IN_INLINED_STYLE, Boolean.TRUE);
        }
    }
}

