/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.hbm2x.AbstractExporter;

public class Hbm2DDLExporter
extends AbstractExporter {
    protected boolean exportToDatabase = true;
    protected boolean scriptToConsole = true;
    protected boolean schemaUpdate = false;
    protected String delimiter = ";";
    protected boolean drop = false;
    protected boolean create = true;
    protected boolean format = false;
    protected String outputFileName = null;
    protected boolean haltOnError = false;

    public Hbm2DDLExporter() {
    }

    public Hbm2DDLExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
    }

    protected boolean setupBoolProperty(String property, boolean defaultVal) {
        if (!this.getProperties().containsKey(property)) {
            return defaultVal;
        }
        return Boolean.parseBoolean(this.getProperties().getProperty(property));
    }

    protected void setupContext() {
        this.exportToDatabase = this.setupBoolProperty("exportToDatabase", this.exportToDatabase);
        this.scriptToConsole = this.setupBoolProperty("scriptToConsole", this.scriptToConsole);
        this.schemaUpdate = this.setupBoolProperty("schemaUpdate", this.schemaUpdate);
        this.delimiter = this.getProperties().getProperty("delimiter", this.delimiter);
        this.drop = this.setupBoolProperty("drop", this.drop);
        this.create = this.setupBoolProperty("create", this.create);
        this.format = this.setupBoolProperty("format", this.format);
        this.outputFileName = this.getProperties().getProperty("outputFileName", this.outputFileName);
        this.haltOnError = this.setupBoolProperty("haltOnError", this.haltOnError);
        super.setupContext();
    }

    protected void cleanUpContext() {
        super.cleanUpContext();
    }

    protected void doStart() {
        Configuration configuration = this.getConfiguration();
        if (this.schemaUpdate) {
            SchemaUpdate update = new SchemaUpdate(configuration);
            update.execute(this.scriptToConsole, this.exportToDatabase);
        } else {
            SchemaExport export = new SchemaExport(configuration);
            if (null != this.outputFileName) {
                export.setOutputFile(new File(this.getOutputDirectory(), this.outputFileName).toString());
            }
            if (null != this.delimiter) {
                export.setDelimiter(this.delimiter);
            }
            export.setHaltOnError(this.haltOnError);
            export.setFormat(this.format);
            if (this.drop && this.create) {
                export.create(this.scriptToConsole, this.exportToDatabase);
            } else {
                export.execute(this.scriptToConsole, this.exportToDatabase, this.drop, this.create);
            }
            if (!export.getExceptions().isEmpty()) {
                int i = 1;
                Iterator iterator = export.getExceptions().iterator();
                while (iterator.hasNext()) {
                    Throwable element = (Throwable)iterator.next();
                    this.log.warn((Object)("Error #" + i + ": "), element);
                    ++i;
                }
                this.log.error((Object)(i - 1 + " occurred while performing Hbm2DDLExporter."));
                if (this.haltOnError) {
                    throw new BuildException("Errors while performing Hbm2DDLExporter");
                }
            }
        }
    }

    public void setExport(boolean export) {
        this.exportToDatabase = export;
    }

    public void setUpdate(boolean update) {
        this.schemaUpdate = update;
    }

    public void setConsole(boolean console) {
        this.scriptToConsole = console;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public void setOutputFileName(String fileName) {
        this.outputFileName = fileName;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setHaltonerror(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }
}

