/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.project.libraries.LibraryDeclarationConvertor;
import org.netbeans.modules.project.libraries.LibraryDeclarationHandler;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class LibraryDeclarationParser
implements ContentHandler,
EntityResolver {
    private StringBuffer buffer;
    private LibraryDeclarationConvertor parslet;
    private LibraryDeclarationHandler handler;
    private Stack<Object[]> context;

    public LibraryDeclarationParser(LibraryDeclarationHandler handler, LibraryDeclarationConvertor parslet) {
        this.parslet = parslet;
        this.handler = handler;
        this.buffer = new StringBuffer(111);
        this.context = new Stack();
    }

    @Override
    public final void setDocumentLocator(Locator locator) {
    }

    @Override
    public final void startDocument() throws SAXException {
    }

    @Override
    public final void endDocument() throws SAXException {
    }

    @Override
    public final void startElement(String ns, String name, String qname, Attributes attrs) throws SAXException {
        this.dispatch(true);
        this.context.push(new Object[]{qname, new AttributesImpl(attrs)});
        if ("volume".equals(qname)) {
            this.handler.start_volume(attrs);
        } else if ("library".equals(qname)) {
            this.handler.start_library(attrs);
        }
    }

    @Override
    public final void endElement(String ns, String name, String qname) throws SAXException {
        this.dispatch(false);
        this.context.pop();
        if ("volume".equals(qname)) {
            this.handler.end_volume();
        } else if ("library".equals(qname)) {
            this.handler.end_library();
        }
    }

    @Override
    public final void characters(char[] chars, int start, int len) throws SAXException {
        this.buffer.append(chars, start, len);
    }

    @Override
    public final void ignorableWhitespace(char[] chars, int start, int len) throws SAXException {
    }

    @Override
    public final void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public final void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public final void skippedEntity(String name) throws SAXException {
    }

    private void dispatch(boolean fireOnlyIfMixed) throws SAXException {
        if (fireOnlyIfMixed && this.buffer.length() == 0) {
            return;
        }
        Object[] ctx = this.context.peek();
        String here = (String)ctx[0];
        Attributes attrs = (Attributes)ctx[1];
        if ("description".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_description(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("type".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_type(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("resource".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_resource(this.parslet.parseResource(this.buffer.length() == 0 ? null : this.buffer.toString()), attrs);
        } else if ("name".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_name(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("localizing-bundle".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_localizingBundle(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        }
        this.buffer.delete(0, this.buffer.length());
    }

    public void parse(InputSource input) throws SAXException, ParserConfigurationException, IOException {
        LibraryDeclarationParser.parse(input, this);
    }

    public void parse(URL url) throws SAXException, ParserConfigurationException, IOException {
        LibraryDeclarationParser.parse(new InputSource(url.toExternalForm()), this);
    }

    public static void parse(InputSource input, LibraryDeclarationHandler handler, LibraryDeclarationConvertor parslet) throws SAXException, ParserConfigurationException, IOException {
        LibraryDeclarationParser.parse(input, new LibraryDeclarationParser(handler, parslet));
    }

    public static void parse(URL url, LibraryDeclarationHandler handler, LibraryDeclarationConvertor parslet) throws SAXException, ParserConfigurationException, IOException {
        LibraryDeclarationParser.parse(new InputSource(url.toExternalForm()), handler, parslet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parse(InputSource input, LibraryDeclarationParser recognizer) throws SAXException, ParserConfigurationException, IOException {
        try {
            XMLReader parser = XMLUtil.createXMLReader((boolean)false, (boolean)false);
            parser.setContentHandler(recognizer);
            parser.setErrorHandler(recognizer.getDefaultErrorHandler());
            parser.setEntityResolver(recognizer);
            parser.parse(input);
        }
        finally {
            if (!recognizer.context.empty()) {
                recognizer.context.clear();
            }
            if (recognizer.buffer.length() > 0) {
                recognizer.buffer.delete(0, recognizer.buffer.length());
            }
        }
    }

    protected ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException ex) throws SAXException {
                throw ex;
            }

            @Override
            public void fatalError(SAXParseException ex) throws SAXException {
                throw ex;
            }

            @Override
            public void warning(SAXParseException ex) throws SAXException {
            }
        };
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if ("-//NetBeans//DTD Library Declaration 1.0//EN".equals(publicId)) {
            ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
            return new InputSource(is);
        }
        return null;
    }
}

