/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen.device;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.netbeans.modules.vmd.api.io.PopupUtil;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.api.model.common.AcceptSupport;
import org.netbeans.modules.vmd.api.model.common.DesignComponentDataFlavorSupport;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsSupport;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayDataFlavorSupport;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.injector.ScreenInjectorPresenter;
import org.netbeans.modules.vmd.screen.MainPanel;
import org.netbeans.modules.vmd.screen.ScreenAccessController;
import org.netbeans.modules.vmd.screen.device.DevicePanel;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class TopPanel
extends JPanel {
    private static final Color COLOR_SELECTION_DRAW = MainPanel.SELECT_COLOR;
    private static final Color COLOR_HOVER_DRAW = MainPanel.HOVER_COLOR;
    private static final Color COLOR_DRAW_DND_LINE = new Color(36, 76, 114);
    private static final Stroke STROKE = new BasicStroke(2.0f);
    private static final Stroke STROKE_DND_LINE = new BasicStroke(3.0f, 2, 0, 2.0f, new float[]{5.0f, 10.0f}, 0.0f);
    private static final Image IMAGE_INJECT = ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/screen/resources/inject.png");
    private DevicePanel devicePanel;
    private List<SelectionShape> selectionShapes = Collections.emptyList();
    private ScreenDeviceInfo.Edge horizontalPosition;
    private ScreenDeviceInfo.Edge verticalPosition;
    private Point lastHoverPoint = null;
    private SelectionShape hoverShape = null;
    private DragSource dragSource;
    private DesignComponent dragedComponent;
    private boolean innerDragingInProgress;

    public TopPanel(final DevicePanel devicePanel) {
        this.devicePanel = devicePanel;
        this.setOpaque(false);
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, new DragGestureListener(){

            @Override
            public void dragGestureRecognized(final DragGestureEvent dgEvent) {
                devicePanel.getController().getDocument().getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        TopPanel.this.dragedComponent = devicePanel.getDesignComponentAt(dgEvent.getDragOrigin());
                        if (TopPanel.this.dragedComponent == null) {
                            return;
                        }
                        ScreenDisplayPresenter presenter = (ScreenDisplayPresenter)TopPanel.this.dragedComponent.getPresenter(ScreenDisplayPresenter.class);
                        if (presenter == null || !presenter.isDraggable()) {
                            TopPanel.this.innerDragingInProgress = false;
                            return;
                        }
                        TopPanel.this.dragSource.startDrag(dgEvent, null, new ScreenDisplaylTransferable(TopPanel.this.dragedComponent), null);
                    }
                });
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (TopPanel.this.injectorWindow(e, true)) {
                    return;
                }
                TopPanel.this.select(e);
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    TopPanel.this.editProperty(e);
                }
                if (e.isPopupTrigger()) {
                    TopPanel.this.popupMenu(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (TopPanel.this.injectorWindow(e, false)) {
                    return;
                }
                TopPanel.this.select(e);
                if (e.isPopupTrigger()) {
                    TopPanel.this.popupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TopPanel.this.injectorWindow(e, false)) {
                    return;
                }
                TopPanel.this.select(e);
                if (e.isPopupTrigger()) {
                    TopPanel.this.popupMenu(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TopPanel.this.hover(e.getPoint());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TopPanel.this.hover(e.getPoint());
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                TopPanel.this.hover(e.getPoint());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                TopPanel.this.hover(e.getPoint());
            }
        });
        this.setDropTarget(new DropTarget(this, new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                if (dtde.getTransferable().isDataFlavorSupported(ScreenDisplayDataFlavorSupport.HORIZONTAL_POSITION_DATA_FLAVOR)) {
                    TopPanel.this.innerDragingInProgress = true;
                }
                TopPanel.this.updatePosition(dtde.getLocation());
                AcceptSuggestion suggestion = TopPanel.this.getSugestion(dtde.getTransferable());
                if (TopPanel.this.isAcceptable(dtde.getLocation(), dtde.getTransferable(), suggestion)) {
                    dtde.acceptDrag(3);
                } else {
                    dtde.rejectDrag();
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
                TopPanel.this.updatePosition(dtde.getLocation());
                AcceptSuggestion suggestion = TopPanel.this.getSugestion(dtde.getTransferable());
                if (TopPanel.this.isAcceptable(dtde.getLocation(), dtde.getTransferable(), suggestion)) {
                    dtde.acceptDrag(3);
                    TopPanel.this.hoverDnD(dtde.getLocation());
                } else {
                    TopPanel.this.hover(dtde.getLocation());
                    dtde.rejectDrag();
                }
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
                TopPanel.this.updatePosition(dtde.getLocation());
                AcceptSuggestion suggestion = TopPanel.this.getSugestion(dtde.getTransferable());
                if (TopPanel.this.isAcceptable(dtde.getLocation(), dtde.getTransferable(), suggestion)) {
                    dtde.acceptDrag(3);
                } else {
                    dtde.rejectDrag();
                }
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
                TopPanel.this.innerDragingInProgress = false;
                TopPanel.this.hover(TopPanel.this.lastHoverPoint);
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                TopPanel.this.updatePosition(dtde.getLocation());
                AcceptSuggestion suggestion = TopPanel.this.getSugestion(dtde.getTransferable());
                if (TopPanel.this.isAcceptable(dtde.getLocation(), dtde.getTransferable(), suggestion)) {
                    TopPanel.this.accept(dtde.getLocation(), dtde.getTransferable(), suggestion);
                    dtde.acceptDrop(3);
                } else {
                    dtde.rejectDrop();
                }
                TopPanel.this.innerDragingInProgress = false;
                TopPanel.this.hover(dtde.getLocation());
            }
        }));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gr = (Graphics2D)g;
        Stroke previousStroke = gr.getStroke();
        gr.setStroke(STROKE);
        for (SelectionShape shape : this.selectionShapes) {
            gr.translate(shape.x, shape.y);
            gr.setColor(COLOR_SELECTION_DRAW);
            gr.draw(shape.shape);
            gr.translate(-shape.x, -shape.y);
        }
        if (this.hoverShape != null) {
            gr.translate(this.hoverShape.x, this.hoverShape.y);
            if (this.innerDragingInProgress) {
                int y2;
                int x2;
                int y1;
                gr.translate(-this.hoverShape.x, -this.hoverShape.y);
                gr.setColor(COLOR_DRAW_DND_LINE);
                gr.setStroke(STROKE_DND_LINE);
                gr.setColor(COLOR_DRAW_DND_LINE);
                int space = 3;
                if (this.verticalPosition == ScreenDeviceInfo.Edge.BOTTOM) {
                    int x1 = this.hoverShape.x + space;
                    y1 = this.hoverShape.y + (int)this.hoverShape.shape.getBounds().getHeight();
                    x2 = this.hoverShape.x + (int)this.hoverShape.shape.getBounds().getWidth() - space;
                    y2 = this.hoverShape.y + (int)this.hoverShape.shape.getBounds().getHeight();
                    gr.drawLine(x1, y1, x2, y2);
                } else if (this.verticalPosition == ScreenDeviceInfo.Edge.TOP) {
                    int x1 = this.hoverShape.x + space;
                    y1 = this.hoverShape.y;
                    x2 = this.hoverShape.x + (int)this.hoverShape.shape.getBounds().getWidth() - space;
                    y2 = this.hoverShape.y;
                    gr.drawLine(x1, y1, x2, y2);
                }
            } else {
                gr.setColor(COLOR_HOVER_DRAW);
                gr.draw(this.hoverShape.shape);
                gr.translate(-this.hoverShape.x, -this.hoverShape.y);
            }
        }
        gr.setStroke(previousStroke);
        for (SelectionShape shape : this.selectionShapes) {
            if (!shape.enableInjector) continue;
            gr.translate(shape.x, shape.y);
            Rectangle rectangle = shape.shape.getBounds();
            gr.drawImage(IMAGE_INJECT, rectangle.x + rectangle.width - 20, rectangle.y - 8, null);
            gr.translate(-shape.x, -shape.y);
        }
    }

    public void reload() {
        ScreenAccessController controller = this.devicePanel.getController();
        DesignComponent editedScreen = controller.getEditedScreen();
        ArrayList<SelectionShape> newSelectionShapes = new ArrayList<SelectionShape>();
        this.reloadSelectionShapes(newSelectionShapes, editedScreen);
        this.selectionShapes = newSelectionShapes;
        this.repaint();
    }

    private void reloadSelectionShapes(ArrayList<SelectionShape> newSelectionShapes, DesignComponent component) {
        Shape shape;
        ScreenDisplayPresenter presenter;
        ScreenDisplayPresenter screenDisplayPresenter = presenter = component != null ? (ScreenDisplayPresenter)component.getPresenter(ScreenDisplayPresenter.class) : null;
        if (presenter == null) {
            return;
        }
        Collection selectedComponents = this.devicePanel.getController().getDocument().getSelectedComponents();
        if (selectedComponents.contains(component) && (shape = presenter.getSelectionShape()) != null) {
            Point point = this.devicePanel.calculateTranslation(presenter.getView(), presenter.getLocation());
            boolean containsInjector = false;
            for (ScreenInjectorPresenter injector : component.getPresenters(ScreenInjectorPresenter.class)) {
                if (!injector.isEnabled()) continue;
                containsInjector = true;
                break;
            }
            newSelectionShapes.add(new SelectionShape(point.x, point.y, shape, component.getComponentID(), containsInjector));
        }
        for (DesignComponent child : presenter.getChildren()) {
            this.reloadSelectionShapes(newSelectionShapes, child);
        }
    }

    public void select(final MouseEvent e) {
        final DesignDocument document = this.devicePanel.getController().getDocument();
        if (document == null) {
            return;
        }
        document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent component = TopPanel.this.devicePanel.getDesignComponentAt(e.getPoint());
                if ((e.getModifiers() & 2) == 2) {
                    if (component != null) {
                        ArrayList<DesignComponent> list = new ArrayList<DesignComponent>(document.getSelectedComponents());
                        if (!list.remove(component)) {
                            list.add(component);
                        }
                        document.setSelectedComponents("screen", list);
                    }
                } else if (component == null) {
                    document.setSelectedComponents("screen", Collections.emptySet());
                } else if (!document.getSelectedComponents().contains(component)) {
                    if (component.getPresenter(ScreenDisplayPresenter.class) != null) {
                        ((ScreenDisplayPresenter)component.getPresenter(ScreenDisplayPresenter.class)).getView().requestFocusInWindow();
                    }
                    document.setSelectedComponents("screen", Collections.singleton(component));
                }
            }
        });
    }

    private void hover(final Point point) {
        this.lastHoverPoint = point != null ? point : null;
        DesignDocument document = this.devicePanel.getController().getDocument();
        if (this.lastHoverPoint != null && document != null) {
            document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    Collection<Object> properties;
                    DesignComponent component = TopPanel.this.devicePanel.getDesignComponentAt(TopPanel.this.lastHoverPoint);
                    ScreenDisplayPresenter presenter = component != null ? (ScreenDisplayPresenter)component.getPresenter(ScreenDisplayPresenter.class) : null;
                    Collection<Object> collection = properties = presenter != null ? presenter.getPropertyDescriptors() : Collections.emptySet();
                    if (properties == null) {
                        return;
                    }
                    for (ScreenPropertyDescriptor screenPropertyDescriptor : properties) {
                        Point editorOrigin = TopPanel.this.devicePanel.calculateTranslation(screenPropertyDescriptor.getRelatedView(), screenPropertyDescriptor.getViewLocation());
                        Shape shape = screenPropertyDescriptor.getSelectionShape();
                        if (!shape.contains(new Point(point.x - editorOrigin.x, point.y - editorOrigin.y))) continue;
                        TopPanel.this.hoverShape = new SelectionShape(editorOrigin.x, editorOrigin.y, shape, Long.MIN_VALUE, false);
                        return;
                    }
                    if (presenter != null) {
                        Point point2 = TopPanel.this.devicePanel.calculateTranslation(presenter.getView(), presenter.getLocation());
                        Shape shape = presenter.getSelectionShape();
                        if (shape != null) {
                            TopPanel.this.hoverShape = new SelectionShape(point2.x, point2.y, shape, component.getComponentID(), false);
                            return;
                        }
                    }
                    TopPanel.this.hoverShape = null;
                }
            });
        }
        this.repaint();
    }

    private void hoverDnD(final Point point) {
        this.lastHoverPoint = point != null ? point : null;
        DesignDocument document = this.devicePanel.getController().getDocument();
        if (this.lastHoverPoint != null && document != null) {
            document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    DesignComponent component = TopPanel.this.devicePanel.getDesignComponentAt(TopPanel.this.lastHoverPoint);
                    ScreenDisplayPresenter presenter = component != null ? (ScreenDisplayPresenter)component.getPresenter(ScreenDisplayPresenter.class) : null;
                    Point editorOrigin = TopPanel.this.devicePanel.calculateTranslation(presenter.getView(), presenter.getLocation());
                    Shape shape = presenter.getSelectionShape();
                    if (shape != null && shape.contains(new Point(point.x - editorOrigin.x, point.y - editorOrigin.y))) {
                        TopPanel.this.hoverShape = new SelectionShape(editorOrigin.x, editorOrigin.y, shape, Long.MIN_VALUE, false);
                        return;
                    }
                    TopPanel.this.hoverShape = null;
                }
            });
        }
        this.repaint();
    }

    private void updatePosition(final Point point) {
        DesignDocument document = this.devicePanel.getController().getDocument();
        if (document != null) {
            document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    ScreenDisplayPresenter presenter;
                    if (point == null) {
                        return;
                    }
                    DesignComponent component = TopPanel.this.devicePanel.getDesignComponentAt(point);
                    ScreenDisplayPresenter screenDisplayPresenter = presenter = component != null ? (ScreenDisplayPresenter)component.getPresenter(ScreenDisplayPresenter.class) : null;
                    if (presenter == null) {
                        return;
                    }
                    Point editorOrigin = TopPanel.this.devicePanel.calculateTranslation(presenter.getView(), presenter.getLocation());
                    double halfVertical = presenter.getView().getHeight() / 2;
                    double halfHorizontal = presenter.getView().getWidth() / 2;
                    if (editorOrigin.getY() + halfVertical > point.getY()) {
                        TopPanel.this.verticalPosition = ScreenDeviceInfo.Edge.TOP;
                    } else if (editorOrigin.getY() + halfVertical < point.getY()) {
                        TopPanel.this.verticalPosition = ScreenDeviceInfo.Edge.BOTTOM;
                    }
                    if (editorOrigin.getX() + halfHorizontal > point.getX()) {
                        TopPanel.this.horizontalPosition = ScreenDeviceInfo.Edge.LEFT;
                    } else if (editorOrigin.getX() + halfHorizontal < point.getX()) {
                        TopPanel.this.horizontalPosition = ScreenDeviceInfo.Edge.RIGHT;
                    }
                }
            });
        }
    }

    public boolean isAcceptable(final Point point, final Transferable transferable, final AcceptSuggestion suggestion) {
        DesignDocument document = this.devicePanel.getController().getDocument();
        if (document == null) {
            return false;
        }
        final boolean[] ret = new boolean[1];
        document.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent component = TopPanel.this.devicePanel.getDesignComponentAt(point);
                ret[0] = AcceptSupport.isAcceptable((DesignComponent)component, (Transferable)transferable, (AcceptSuggestion)suggestion);
            }
        });
        return ret[0];
    }

    public void accept(final Point point, final Transferable transferable, final AcceptSuggestion suggestion) {
        DesignDocument document = this.devicePanel.getController().getDocument();
        if (document == null) {
            return;
        }
        document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent component = TopPanel.this.devicePanel.getDesignComponentAt(point);
                ComponentProducer.Result result = AcceptSupport.accept((DesignComponent)component, (Transferable)transferable, (AcceptSuggestion)suggestion);
                AcceptSupport.selectComponentProducerResult((ComponentProducer.Result)result);
            }
        });
    }

    public void popupMenu(final MouseEvent e) {
        DesignDocument document = this.devicePanel.getController().getDocument();
        if (document == null) {
            return;
        }
        document.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent component = TopPanel.this.devicePanel.getDesignComponentAt(e.getPoint());
                if (component == null) {
                    return;
                }
                JPopupMenu menu = Utilities.actionsToPopup((Action[])ActionsSupport.createActionsArray((DesignComponent)component), (Component)TopPanel.this);
                menu.show(TopPanel.this, e.getX(), e.getY());
            }
        });
    }

    private boolean injectorWindow(MouseEvent e, boolean invoke) {
        for (SelectionShape shape : this.selectionShapes) {
            if (!shape.enableInjector) continue;
            Rectangle bounds = shape.shape.getBounds();
            if (!new Rectangle(bounds.x + bounds.width - 20, bounds.y - 8, 16, 16).contains(e.getX() - shape.x, e.getY() - shape.y)) continue;
            if (invoke) {
                this.invokeInjectorWindow(shape.componentID, shape.x + bounds.x + bounds.width - 20, shape.y + bounds.y + 8);
            }
            return true;
        }
        return false;
    }

    private void invokeInjectorWindow(final long componentID, int x, int y) {
        final DesignDocument document = this.devicePanel.getController().getDocument();
        if (document == null) {
            return;
        }
        final ArrayList views = new ArrayList();
        document.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent component = document.getComponentByUID(componentID);
                ArrayList list = new ArrayList(component.getPresenters(ScreenInjectorPresenter.class));
                DocumentSupport.sortPresentersByOrder(list);
                for (ScreenInjectorPresenter presenter : list) {
                    JComponent view;
                    if (!presenter.isEnabled() || (view = presenter.getViewComponent()) == null) continue;
                    views.add(view);
                }
            }
        });
        if (views.isEmpty()) {
            return;
        }
        JPanel pane = new JPanel();
        pane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
        pane.setLayout(new GridBagLayout());
        for (JComponent view : views) {
            pane.add((Component)view, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 6));
        }
        Point screen = this.getLocationOnScreen();
        PopupUtil.showPopup((JComponent)pane, (String)NbBundle.getMessage(TopPanel.class, (String)"TITLE_ActionsMenu"), (int)(screen.x + x), (int)(screen.y + y), (boolean)true);
    }

    private void editProperty(final MouseEvent e) {
        DesignDocument document = this.devicePanel.getController().getDocument();
        if (document == null) {
            return;
        }
        document.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                ScreenDisplayPresenter presenter;
                DesignComponent component = TopPanel.this.devicePanel.getDesignComponentAt(e.getPoint());
                ScreenDisplayPresenter screenDisplayPresenter = presenter = component != null ? (ScreenDisplayPresenter)component.getPresenter(ScreenDisplayPresenter.class) : null;
                if (presenter == null) {
                    return;
                }
                Collection<ScreenPropertyDescriptor> properties = presenter.getPropertyDescriptors();
                if (properties == null) {
                    return;
                }
                for (ScreenPropertyDescriptor property : properties) {
                    JComponent relatedView = property.getRelatedView();
                    Point viewLocation = property.getViewLocation();
                    Shape shape = property.getSelectionShape();
                    Point editorOrigin = TopPanel.this.devicePanel.calculateTranslation(relatedView, viewLocation);
                    if (!shape.contains(new Point(e.getX() - editorOrigin.x, e.getY() - editorOrigin.y))) continue;
                    Rectangle bounds = shape.getBounds();
                    JComponent editorView = property.getEditor().createEditorComponent(property);
                    if (editorView == null) {
                        return;
                    }
                    Insets insets = property.getEditor().getEditorComponentInsets(editorView);
                    bounds.x -= insets.left;
                    bounds.width += insets.left + insets.right;
                    bounds.y -= insets.top;
                    bounds.height += insets.top + insets.bottom;
                    editorView.setPreferredSize(bounds.getSize());
                    Point relatedViewLocationOnScreen = relatedView.getLocationOnScreen();
                    bounds.translate(relatedViewLocationOnScreen.x, relatedViewLocationOnScreen.y);
                    PopupUtil.showPopup((JComponent)editorView, (String)NbBundle.getMessage(TopPanel.class, (String)"TITLE_EditorMenu"), (int)bounds.x, (int)bounds.y, (boolean)true);
                }
            }
        });
    }

    private AcceptSuggestion getSugestion(final Transferable transferable) {
        final ScreenDisplayPresenter[] displayPresenterWrapper = new ScreenDisplayPresenter[1];
        if (!transferable.isDataFlavorSupported(DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR)) {
            return null;
        }
        this.devicePanel.getController().getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                try {
                    DesignComponent component = (DesignComponent)transferable.getTransferData(DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR);
                    displayPresenterWrapper[0] = (ScreenDisplayPresenter)component.getPresenter(ScreenDisplayPresenter.class);
                }
                catch (UnsupportedFlavorException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        if (displayPresenterWrapper[0] == null) {
            return null;
        }
        return displayPresenterWrapper[0].createSuggestion(transferable);
    }

    private class ScreenDisplaylTransferable
    implements Transferable {
        private List DATA_FLAVORS = Arrays.asList(DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR, ScreenDisplayDataFlavorSupport.HORIZONTAL_POSITION_DATA_FLAVOR, ScreenDisplayDataFlavorSupport.VERTICAL_POSITION_DATA_FLAVOR);
        private WeakReference<DesignComponent> component;

        public ScreenDisplaylTransferable(DesignComponent component) {
            this.component = new WeakReference<DesignComponent>(component);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return (DataFlavor[])this.DATA_FLAVORS.toArray();
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.DATA_FLAVORS.contains(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor == DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR) {
                return this.component.get();
            }
            if (flavor == ScreenDisplayDataFlavorSupport.HORIZONTAL_POSITION_DATA_FLAVOR) {
                return TopPanel.this.horizontalPosition;
            }
            if (flavor == ScreenDisplayDataFlavorSupport.VERTICAL_POSITION_DATA_FLAVOR) {
                return TopPanel.this.verticalPosition;
            }
            return null;
        }
    }

    private static class SelectionShape {
        private int x;
        private int y;
        private Shape shape;
        private long componentID;
        private boolean enableInjector;

        public SelectionShape(int x, int y, Shape shape, long componentID, boolean enableInjector) {
            this.x = x;
            this.y = y;
            this.shape = shape;
            this.componentID = componentID;
            this.enableInjector = enableInjector;
        }
    }
}

