/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.modules.profiler.ProfilerIDESettings;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.ProfilingSettingsManager;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.netbeans.modules.profiler.utilities.queries.SettingsFolderQuery;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class IDEUtils {
    private static final String CREATE_NEW_CONFIGURATION_HINT = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_CreateNewConfigurationHint");
    private static final String SELECT_SETTINGS_CONFIGURATION_LABEL_TEXT = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_SelectSettingsConfigurationLabelText");
    private static final String SELECT_SETTINGS_CONFIGURATION_DIALOG_CAPTION = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_SelectSettingsConfigurationDialogCaption");
    private static final String INVALID_PLATFORM_PROJECT_MSG = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_InvalidPlatformProjectMsg");
    private static final String INVALID_PLATFORM_PROFILER_MSG = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_InvalidPlatformProfilerMsg");
    private static final String INVALID_TARGET_JVM_EXEFILE_ERROR = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_InvalidTargetJVMExeFileError");
    private static final String ERROR_CONVERTING_PROFILING_SETTINGS_MESSAGE = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_ErrorConvertingProfilingSettingsMessage");
    private static final String LIST_ACCESS_NAME = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_ListAccessName");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_OkButtonText");
    private static final String SETTINGS_FOR_ATTR = "settingsFor";
    private static final RequestProcessor profilerRequestProcessor = new RequestProcessor("Profiler Request Processor", 1);
    private static final ErrorManager profilerErrorManager = ErrorManager.getDefault().getInstance("org.netbeans.modules.profiler");

    public static String getAntProfilerStartArgument15(int port, int architecture) {
        return IDEUtils.getAntProfilerStartArgument(port, architecture, "jdk15");
    }

    public static String getAntProfilerStartArgument16(int port, int architecture) {
        return IDEUtils.getAntProfilerStartArgument(port, architecture, "jdk16");
    }

    public static String getAntProfilerStartArgument17(int port, int architecture) {
        return IDEUtils.getAntProfilerStartArgument(port, architecture, "jdk17");
    }

    public static String getHelpDir() {
        Iterator suffixesIterator = NbBundle.getLocalizingSuffixes();
        File localizedHelpDir = null;
        while (suffixesIterator.hasNext() && localizedHelpDir == null) {
            localizedHelpDir = InstalledFileLocator.getDefault().locate("docs/profiler" + suffixesIterator.next(), "org.netbeans.modules.profiler", false);
        }
        if (localizedHelpDir == null) {
            return null;
        }
        return localizedHelpDir.getPath();
    }

    public static JavaPlatform getJavaPlatformByName(String platformName) {
        if (platformName != null) {
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(platformName, null);
            for (int i = 0; i < platforms.length; ++i) {
                JavaPlatform platform = platforms[i];
                if (platformName == null || !platform.getDisplayName().equals(platformName)) continue;
                return platform;
            }
        }
        return null;
    }

    public static String getLibsDir() {
        File dir = InstalledFileLocator.getDefault().locate("lib/jfluid-server.jar", "org.netbeans.lib.profiler", false);
        if (dir == null) {
            return null;
        }
        return dir.getParentFile().getPath();
    }

    public static Component getMainWindow() {
        return WindowManager.getDefault().getMainWindow();
    }

    public static int getPlatformArchitecture(JavaPlatform platform) {
        assert (platform != null) : "Platform may not be NULL";
        Map props = platform.getSystemProperties();
        String arch = (String)props.get("sun.arch.data.model");
        if (arch == null) {
            return 32;
        }
        return Integer.parseInt(arch);
    }

    public static int getPlatformJDKMinor(JavaPlatform platform) {
        assert (platform != null) : "Platform may not be NULL";
        Map props = platform.getSystemProperties();
        String ver = (String)props.get("java.version");
        return Platform.getJDKMinorNumber((String)ver);
    }

    public static String getPlatformJDKVersion(JavaPlatform platform) {
        assert (platform != null) : "Platform may not be NULL";
        Map props = platform.getSystemProperties();
        String ver = (String)props.get("java.version");
        if (ver == null) {
            return null;
        }
        if (ver.startsWith("1.5")) {
            return "jdk15";
        }
        if (ver.startsWith("1.6")) {
            return "jdk16";
        }
        if (ver.startsWith("1.7")) {
            return "jdk17";
        }
        return null;
    }

    public static String getPlatformJavaFile(JavaPlatform platform) {
        assert (platform != null) : "Platform may not be NULL";
        FileObject fo = platform.findTool("java");
        if (fo == null) {
            if (ProfilerIDESettings.getInstance().getJavaPlatformForProfiling() == null) {
                Profiler.getDefault().displayError(MessageFormat.format(INVALID_PLATFORM_PROJECT_MSG, platform.getDisplayName()));
            } else {
                Profiler.getDefault().displayError(MessageFormat.format(INVALID_PLATFORM_PROFILER_MSG, platform.getDisplayName()));
            }
            return null;
        }
        String jvmExe = null;
        try {
            File file = FileUtil.toFile((FileObject)fo);
            jvmExe = file.getAbsolutePath();
            MiscUtils.checkFileForName((String)jvmExe);
        }
        catch (Exception e) {
            ErrorManager.getDefault().annotate((Throwable)e, MessageFormat.format(INVALID_TARGET_JVM_EXEFILE_ERROR, jvmExe, e.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)e);
        }
        return jvmExe;
    }

    public static RequestProcessor getProfilerRequestProcessor() {
        return profilerRequestProcessor;
    }

    public static Project getProjectFromSettingsFolder(FileObject settingsFolder) {
        FileObject d;
        Object o = settingsFolder.getAttribute(SETTINGS_FOR_ATTR);
        if (o instanceof URL && (d = URLMapper.findFileObject((URL)((URL)o))) != null && d.isFolder()) {
            try {
                return ProjectManager.getDefault().findProject(d);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        Project p = FileOwnerQuery.getOwner((FileObject)settingsFolder);
        try {
            if (p != null && IDEUtils.getProjectSettingsFolder(p, false) == settingsFolder) {
                return p;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public static FileObject getProjectSettingsFolder(Project project, boolean create) throws IOException {
        if (project == null) {
            return IDEUtils.getSettingsFolder(true);
        }
        FileObject nbproject = project.getProjectDirectory().getFileObject("nbproject");
        FileObject d = nbproject != null ? (create ? FileUtil.createFolder((FileObject)nbproject, (String)"private/profiler") : nbproject.getFileObject("private/profiler")) : ProjectUtils.getCacheDirectory((Project)project, IDEUtils.class);
        if (d != null) {
            d.setAttribute(SETTINGS_FOR_ATTR, (Object)project.getProjectDirectory().getURL());
        }
        return d;
    }

    public static FileObject getSettingsFolder(boolean create) throws IOException {
        return SettingsFolderQuery.getDefault().getSettingsFolder(create);
    }

    public static TopComponent getTopComponent(Component temp) {
        while (!(temp instanceof TopComponent)) {
            if ((temp = temp.getParent()) != null) continue;
            return null;
        }
        return (TopComponent)temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertPropertiesToXML(FileObject propertiesFO, FileObject xmlFO) {
        FileLock propertiesFOLock = null;
        FileLock xmlFOLock = null;
        try {
            propertiesFOLock = propertiesFO.lock();
            InputStream fis = propertiesFO.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(fis);
            Properties properties = new Properties();
            properties.load(bis);
            bis.close();
            fis.close();
            xmlFOLock = xmlFO.lock();
            OutputStream fos = xmlFO.getOutputStream(xmlFOLock);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            properties.storeToXML(bos, "");
            bos.close();
            fos.close();
            propertiesFO.delete(propertiesFOLock);
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(ERROR_CONVERTING_PROFILING_SETTINGS_MESSAGE, FileUtil.toFile((FileObject)propertiesFO).getPath(), FileUtil.toFile((FileObject)xmlFO).getPath(), e.getMessage()), 2));
        }
        finally {
            if (propertiesFOLock != null) {
                propertiesFOLock.releaseLock();
            }
            if (xmlFOLock != null) {
                xmlFOLock.releaseLock();
            }
        }
    }

    public static Properties duplicateProperties(Properties props) {
        Properties ret = new Properties();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ret.setProperty(key, props.getProperty(key));
        }
        return ret;
    }

    public static ProgressHandle indeterminateProgress(String title, final int timeout) {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)title);
        IDEUtils.runInEventDispatchThreadAndWait(new Runnable(){

            @Override
            public void run() {
                ph.setInitialDelay(timeout);
                ph.start();
            }
        });
        return ph;
    }

    public static void runInEventDispatchThread(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static void runInEventDispatchThreadAndWait(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InvocationTargetException e) {
                profilerErrorManager.notify((Throwable)e);
            }
            catch (InterruptedException e) {
                profilerErrorManager.notify((Throwable)e);
            }
        }
    }

    public static void runInProfilerRequestProcessor(Runnable r) {
        profilerRequestProcessor.post(r);
    }

    public static ProfilingSettings selectSettings(Project project, int type, ProfilingSettings[] availableSettings, ProfilingSettings settingsToSelect) {
        int selectedIndex;
        Object[] settings = new Object[availableSettings.length + 1];
        for (int i = 0; i < availableSettings.length; ++i) {
            settings[i] = availableSettings[i];
        }
        settings[availableSettings.length] = CREATE_NEW_CONFIGURATION_HINT;
        JLabel label = new JLabel(SELECT_SETTINGS_CONFIGURATION_LABEL_TEXT);
        final JButton okButton = new JButton(OK_BUTTON_TEXT);
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(450, 250));
        panel.setBorder(new EmptyBorder(12, 12, 12, 12));
        panel.setLayout(new BorderLayout(0, 5));
        panel.add((Component)label, "North");
        final JList<Object> list = new JList<Object>(settings);
        label.setLabelFor(list);
        list.getAccessibleContext().setAccessibleName(LIST_ACCESS_NAME);
        list.setSelectionMode(0);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                okButton.setEnabled(list.getSelectedIndex() != -1);
            }
        });
        if (settingsToSelect != null) {
            list.setSelectedValue(settingsToSelect, true);
        } else {
            list.setSelectedIndex(0);
        }
        panel.add((Component)new JScrollPane(list), "Center");
        DialogDescriptor dd = new DialogDescriptor((Object)panel, SELECT_SETTINGS_CONFIGURATION_DIALOG_CAPTION, true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
        Dialog d = ProfilerDialogs.createDialog(dd);
        d.setVisible(true);
        if (dd.getValue() == okButton && (selectedIndex = list.getSelectedIndex()) != -1) {
            if (selectedIndex < settings.length - 1) {
                ProfilingSettings selectedSettings = (ProfilingSettings)settings[selectedIndex];
                selectedSettings.setProfilingType(type);
                return selectedSettings;
            }
            ProfilingSettings newSettings = ProfilingSettingsManager.getDefault().createNewSettings(type, availableSettings);
            if (newSettings == null) {
                return null;
            }
            newSettings.setProfilingType(type);
            return newSettings;
        }
        return null;
    }

    private static String getAntProfilerStartArgument(int port, int architecture, String jdkVersion) {
        String ld = IDEUtils.getLibsDir();
        return "-agentpath:" + Platform.getAgentNativeLibFullName((String)ld, (boolean)false, (String)jdkVersion, (int)architecture) + "=" + ld + "," + port + "," + System.getProperty("profiler.agent.connect.timeout", "10");
    }

    private static ArrayList getSettings(Project project, int mask) {
        ProfilingSettings[] projectSettings;
        ArrayList<ProfilingSettings> matching = new ArrayList<ProfilingSettings>();
        for (ProfilingSettings settings : projectSettings = ProfilingSettingsManager.getDefault().getProfilingSettings(project).getProfilingSettings()) {
            if (!IDEUtils.matchesMask(settings, mask)) continue;
            matching.add(settings);
        }
        return matching;
    }

    private static String forwardSlashes(String text) {
        return text.replace('\\', '/');
    }

    private static boolean matchesMask(ProfilingSettings settings, int mask) {
        return Utils.isCPUSettings(settings);
    }
}

