/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.ui.HyperlinkTextArea;
import org.netbeans.modules.profiler.ui.stp.ProfilingSettingsManager;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.ui.stp.TaskChooser;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.util.NbBundle;

public class TaskPresenter
implements TaskChooser.Item {
    private static final String CREATE_CUSTOM_STRING = NbBundle.getMessage(TaskPresenter.class, (String)"TaskPresenter_CreateCustomString");
    private static final String RENAME_ITEM_TEXT = NbBundle.getMessage(TaskPresenter.class, (String)"TaskPresenter_RenameItemText");
    private static final String DUPLICATE_ITEM_TEXT = NbBundle.getMessage(TaskPresenter.class, (String)"TaskPresenter_DuplicateItemText");
    private static final String DELETE_ITEM_TEXT = NbBundle.getMessage(TaskPresenter.class, (String)"TaskPresenter_DeleteItemText");
    private static final String MOVE_UP_ITEM_TEXT = NbBundle.getMessage(TaskPresenter.class, (String)"TaskPresenter_MoveUpItemText");
    private static final String MOVE_DOWN_ITEM_TEXT = NbBundle.getMessage(TaskPresenter.class, (String)"TaskPresenter_MoveDownItemText");
    private static final String CREATE_CUSTOM_TOOLTIP = NbBundle.getMessage(TaskPresenter.class, (String)"TaskPresenter_CreateCustomToolTip");
    private Context context;
    private Icon icon;
    private LargeTaskPresenter largeTaskPresenter;
    private SmallTaskPresenter smallTaskPresenter;
    private String name;

    public TaskPresenter(String string, Icon icon, Context context) {
        this.name = string;
        this.icon = icon;
        this.context = context;
    }

    @Override
    public JComponent getLargeComponent() {
        if (this.largeTaskPresenter == null) {
            this.largeTaskPresenter = new LargeTaskPresenter(this.name, this.icon, this.context);
        }
        return this.largeTaskPresenter;
    }

    public void setProfilingSettings(ArrayList<ProfilingSettings> arrayList) {
        this.largeTaskPresenter.setProfilingSettings(arrayList);
    }

    public ArrayList<ProfilingSettings> getProfilingSettings() {
        return this.largeTaskPresenter.getProfilingSettings();
    }

    public ProfilingSettings getSelectedProfilingSettings() {
        return this.largeTaskPresenter.getSelectedProfilingSettings();
    }

    @Override
    public JComponent getSmallComponent() {
        if (this.smallTaskPresenter == null) {
            this.smallTaskPresenter = new SmallTaskPresenter(this.name, this.icon);
        }
        return this.smallTaskPresenter;
    }

    public void resetProfilingSettings() {
        this.largeTaskPresenter.resetProfilingSettings();
    }

    public void selectProfilingSettings(ProfilingSettings profilingSettings) {
        this.largeTaskPresenter.selectSettings(profilingSettings);
    }

    private static class TPHyperlinkTextArea
    extends HyperlinkTextArea {
        public TPHyperlinkTextArea(String string) {
            super(string);
            this.setForeground(SelectProfilingTask.DARKLINK_COLOR_INACTIVE);
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    JComponent jComponent = (JComponent)TPHyperlinkTextArea.this.getParent();
                    if (jComponent != null) {
                        jComponent.scrollRectToVisible(TPHyperlinkTextArea.this.getBounds());
                    }
                }
            });
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
            this.getInputMap().put(keyStroke, "");
        }

        @Override
        protected Color getHighlightColor() {
            return SelectProfilingTask.DARKLINK_COLOR;
        }

        @Override
        protected String getHighlightText(String string) {
            return "<u>" + string + "</u>";
        }

        @Override
        protected Color getNormalColor() {
            return SelectProfilingTask.DARKLINK_COLOR_INACTIVE;
        }

        @Override
        protected String getNormalText(String string) {
            return string;
        }
    }

    private static class SmallTaskPresenter
    extends JPanel {
        public SmallTaskPresenter(String string, Icon icon) {
            this.initComponents(string, icon);
        }

        private void initComponents(String string, Icon icon) {
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
            this.setBackground(SelectProfilingTask.BACKGROUND_COLOR_INACTIVE);
            JLabel jLabel = new JLabel();
            jLabel.setFont(jLabel.getFont().deriveFont(1, jLabel.getFont().getSize2D() + 3.0f));
            jLabel.setForeground(new Color(80, 80, 80));
            jLabel.setIcon(icon);
            jLabel.setText(string);
            jLabel.setIconTextGap(10);
            jLabel.setBorder(BorderFactory.createEmptyBorder(5, 12, 5, 12));
            this.add((Component)jLabel, "North");
        }
    }

    private static class LargeTaskPresenter
    extends JPanel {
        private static final int MAX_VISIBLE_ROWS = 4;
        private static final int CONFIGURATION_HEIGHT = new HTMLTextArea((String)"H").getPreferredSize().height;
        private ArrayList<ProfilingSettings> profilingSettings = new ArrayList();
        private Context context;
        private JMenuItem deleteItem;
        private JMenuItem duplicateItem;
        private JMenuItem moveDownItem;
        private JMenuItem moveUpItem;
        private JMenuItem renameItem;
        private JPanel configurationsContainer;
        private JPopupMenu presetPopupMenu;
        private JScrollPane configurationsScrollPane;
        private TPHyperlinkTextArea createCustom;
        private int activeSettingsIndex = -1;
        private int selectedSettingsIndex = 0;

        public LargeTaskPresenter(String string, Icon icon, Context context) {
            this.context = context;
            this.initComponents(string, icon);
        }

        public void setProfilingSettings(ArrayList<ProfilingSettings> arrayList) {
            this.resetProfilingSettings();
            this.profilingSettings.addAll(arrayList);
            this.updateItems();
        }

        public ArrayList<ProfilingSettings> getProfilingSettings() {
            return this.profilingSettings;
        }

        public ProfilingSettings getSelectedProfilingSettings() {
            if (this.selectedSettingsIndex == -1) {
                return null;
            }
            return this.profilingSettings.get(this.selectedSettingsIndex);
        }

        public void resetProfilingSettings() {
            this.selectedSettingsIndex = 0;
            this.profilingSettings.clear();
        }

        public void selectSettings(ProfilingSettings profilingSettings) {
            this.selectSettings(profilingSettings, true);
        }

        private TPHyperlinkTextArea getPresenter(ProfilingSettings profilingSettings) {
            if (profilingSettings == null || this.profilingSettings.indexOf(profilingSettings) == -1) {
                return null;
            }
            return (TPHyperlinkTextArea)((Object)this.configurationsContainer.getComponent(this.profilingSettings.indexOf(profilingSettings) * 2 + 1));
        }

        private void createCustomSettings() {
            SelectProfilingTask.getDefault().synchronizeCurrentSettings();
            ProfilingSettings profilingSettings = ProfilingSettingsManager.getDefault().createNewSettings(this.profilingSettings.get(0).getProfilingType(), this.profilingSettings.toArray(new ProfilingSettings[this.profilingSettings.size()]));
            if (profilingSettings != null) {
                ProfilingSettings profilingSettings2 = this.profilingSettings.get(this.selectedSettingsIndex);
                this.profilingSettings.add(profilingSettings);
                this.updateItems();
                this.selectedSettingsIndex = this.profilingSettings.indexOf(profilingSettings2);
                this.context.selectSettings(profilingSettings);
            }
        }

        private void initComponents(String string, Icon icon) {
            this.setLayout(new GridBagLayout());
            this.setOpaque(true);
            this.setBackground(SelectProfilingTask.BACKGROUND_COLOR);
            JLabel jLabel = new JLabel();
            jLabel.setFont(jLabel.getFont().deriveFont(1, jLabel.getFont().getSize2D() + 3.0f));
            jLabel.setForeground(new Color(198, 129, 0));
            jLabel.setIcon(icon);
            jLabel.setText(string);
            jLabel.setIconTextGap(10);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(5, 12, 5, 12);
            this.add((Component)jLabel, gridBagConstraints);
            JSeparator jSeparator = Utils.createHorizontalSeparator();
            jSeparator.setBackground(this.getBackground());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 7, 10);
            this.add((Component)jSeparator, gridBagConstraints);
            this.configurationsContainer = new ConfigurationsContainer();
            this.configurationsContainer.setLayout(new GridBagLayout());
            this.configurationsContainer.setOpaque(true);
            this.configurationsContainer.setBackground(SelectProfilingTask.BACKGROUND_COLOR);
            this.configurationsContainer.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && LargeTaskPresenter.this.configurationsContainer.isShowing() && LargeTaskPresenter.this.selectedSettingsIndex != -1) {
                        ProfilingSettings profilingSettings = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.selectedSettingsIndex);
                        TPHyperlinkTextArea tPHyperlinkTextArea = LargeTaskPresenter.this.getPresenter(profilingSettings);
                        tPHyperlinkTextArea.requestFocusInWindow();
                    }
                }
            });
            this.configurationsScrollPane = new JScrollPane(20, 31){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, Math.min(((LargeTaskPresenter)LargeTaskPresenter.this).configurationsContainer.getPreferredSize().height, CONFIGURATION_HEIGHT * 4));
                }
            };
            this.configurationsScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.configurationsScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            this.configurationsScrollPane.setViewportView(this.configurationsContainer);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            this.add((Component)this.configurationsScrollPane, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            this.add((Component)Utils.createFillerPanel(), gridBagConstraints);
            this.createCustom = new TPHyperlinkTextArea(CREATE_CUSTOM_STRING);
            this.createCustom.setToolTipText(CREATE_CUSTOM_TOOLTIP);
            this.createCustom.setName(CREATE_CUSTOM_STRING);
            this.createCustom.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1) {
                        this.mouseExited(mouseEvent);
                        LargeTaskPresenter.this.createCustomSettings();
                    }
                }
            });
            this.createCustom.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 32) {
                        LargeTaskPresenter.this.createCustomSettings();
                    }
                }
            });
            this.renameItem = new JMenuItem(RENAME_ITEM_TEXT);
            this.renameItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ProfilingSettings profilingSettings = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.activeSettingsIndex);
                    ProfilingSettings profilingSettings2 = ProfilingSettingsManager.getDefault().renameSettings(profilingSettings, LargeTaskPresenter.this.profilingSettings.toArray(new ProfilingSettings[LargeTaskPresenter.this.profilingSettings.size()]));
                    if (profilingSettings2 != null) {
                        ProfilingSettings profilingSettings3 = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.selectedSettingsIndex);
                        LargeTaskPresenter.this.profilingSettings.add(LargeTaskPresenter.this.profilingSettings.indexOf(profilingSettings), profilingSettings2);
                        LargeTaskPresenter.this.profilingSettings.remove(profilingSettings);
                        LargeTaskPresenter.this.updateItems();
                        if (LargeTaskPresenter.this.activeSettingsIndex != LargeTaskPresenter.this.selectedSettingsIndex) {
                            LargeTaskPresenter.this.selectSettings(profilingSettings3, false);
                        } else {
                            LargeTaskPresenter.this.context.selectSettings(profilingSettings2);
                        }
                    }
                }
            });
            this.duplicateItem = new JMenuItem(DUPLICATE_ITEM_TEXT);
            this.duplicateItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SelectProfilingTask.getDefault().synchronizeCurrentSettings();
                    ProfilingSettings profilingSettings = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.activeSettingsIndex);
                    ProfilingSettings profilingSettings2 = ProfilingSettingsManager.getDefault().createDuplicateSettings(profilingSettings, LargeTaskPresenter.this.profilingSettings.toArray(new ProfilingSettings[LargeTaskPresenter.this.profilingSettings.size()]));
                    if (profilingSettings2 != null) {
                        ProfilingSettings profilingSettings3 = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.selectedSettingsIndex);
                        LargeTaskPresenter.this.profilingSettings.add(profilingSettings2);
                        LargeTaskPresenter.this.updateItems();
                        LargeTaskPresenter.this.selectedSettingsIndex = LargeTaskPresenter.this.profilingSettings.indexOf(profilingSettings3);
                        LargeTaskPresenter.this.context.selectSettings(profilingSettings2);
                    }
                }
            });
            this.deleteItem = new JMenuItem(DELETE_ITEM_TEXT);
            this.deleteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ProfilingSettings profilingSettings = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.selectedSettingsIndex);
                    LargeTaskPresenter.this.profilingSettings.remove(LargeTaskPresenter.this.activeSettingsIndex);
                    LargeTaskPresenter.this.updateItems();
                    LargeTaskPresenter.this.selectedSettingsIndex = LargeTaskPresenter.this.profilingSettings.indexOf(profilingSettings);
                    if (LargeTaskPresenter.this.selectedSettingsIndex == -1) {
                        LargeTaskPresenter.this.context.selectSettings((ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(Math.max(LargeTaskPresenter.this.activeSettingsIndex - 1, 0)));
                    } else {
                        LargeTaskPresenter.this.selectSettings(profilingSettings, false);
                    }
                }
            });
            this.moveUpItem = new JMenuItem(MOVE_UP_ITEM_TEXT);
            this.moveUpItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ProfilingSettings profilingSettings = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.selectedSettingsIndex);
                    ProfilingSettings profilingSettings2 = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.activeSettingsIndex);
                    LargeTaskPresenter.this.profilingSettings.remove(profilingSettings2);
                    LargeTaskPresenter.this.profilingSettings.add(LargeTaskPresenter.this.activeSettingsIndex - 1, profilingSettings2);
                    LargeTaskPresenter.this.updateItems();
                    LargeTaskPresenter.this.selectSettings(profilingSettings, false);
                }
            });
            this.moveDownItem = new JMenuItem(MOVE_DOWN_ITEM_TEXT);
            this.moveDownItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ProfilingSettings profilingSettings = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.selectedSettingsIndex);
                    ProfilingSettings profilingSettings2 = (ProfilingSettings)LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.activeSettingsIndex);
                    LargeTaskPresenter.this.profilingSettings.remove(profilingSettings2);
                    LargeTaskPresenter.this.profilingSettings.add(LargeTaskPresenter.this.activeSettingsIndex + 1, profilingSettings2);
                    LargeTaskPresenter.this.updateItems();
                    LargeTaskPresenter.this.selectSettings(profilingSettings, false);
                }
            });
            this.presetPopupMenu = new JPopupMenu();
            this.presetPopupMenu.add(this.renameItem);
            this.presetPopupMenu.add(this.duplicateItem);
            this.presetPopupMenu.add(this.deleteItem);
            this.presetPopupMenu.addSeparator();
            this.presetPopupMenu.add(this.moveUpItem);
            this.presetPopupMenu.add(this.moveDownItem);
        }

        private void selectSettings(ProfilingSettings profilingSettings, final boolean bl) {
            TPHyperlinkTextArea tPHyperlinkTextArea;
            if (this.selectedSettingsIndex != -1 && this.profilingSettings.get(this.selectedSettingsIndex) != profilingSettings) {
                tPHyperlinkTextArea = this.profilingSettings.get(this.selectedSettingsIndex);
                TPHyperlinkTextArea tPHyperlinkTextArea2 = this.getPresenter((ProfilingSettings)tPHyperlinkTextArea);
                tPHyperlinkTextArea2.setSelected(false);
            }
            this.selectedSettingsIndex = this.profilingSettings.indexOf(profilingSettings);
            this.setCursor(Cursor.getDefaultCursor());
            tPHyperlinkTextArea = this.getPresenter(profilingSettings);
            tPHyperlinkTextArea.setSelected(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tPHyperlinkTextArea.requestFocusInWindow();
                    if (bl) {
                        LargeTaskPresenter.this.configurationsContainer.scrollRectToVisible(tPHyperlinkTextArea.getBounds());
                    }
                }
            });
        }

        private void showPopupMenu(ProfilingSettings profilingSettings, int n, int n2) {
            this.activeSettingsIndex = this.profilingSettings.indexOf(profilingSettings);
            this.renameItem.setEnabled(!profilingSettings.isPreset());
            this.deleteItem.setEnabled(!profilingSettings.isPreset());
            this.moveUpItem.setEnabled(this.activeSettingsIndex > 0);
            this.moveDownItem.setEnabled(this.activeSettingsIndex < this.profilingSettings.size() - 1);
            this.presetPopupMenu.show((Component)((Object)this.getPresenter(profilingSettings)), n, n2);
        }

        private void updateItems() {
            GridBagConstraints gridBagConstraints;
            Object object;
            this.configurationsContainer.removeAll();
            int n = 0;
            while (n < this.profilingSettings.size()) {
                object = this.profilingSettings.get(n);
                String string = object.getSettingsName();
                JLabel jLabel = new JLabel("\u00b7");
                jLabel.setOpaque(false);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(3, 25, 0, 2);
                this.configurationsContainer.add((Component)jLabel, gridBagConstraints);
                TPHyperlinkTextArea tPHyperlinkTextArea = new TPHyperlinkTextArea(string);
                tPHyperlinkTextArea.getAccessibleContext().setAccessibleName(string);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = n++;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(0, 0, 0, 4);
                this.configurationsContainer.add((Component)((Object)tPHyperlinkTextArea), gridBagConstraints);
                tPHyperlinkTextArea.addMouseListener(new MouseAdapter((ProfilingSettings)object){
                    final /* synthetic */ ProfilingSettings val$settings;
                    {
                        this.val$settings = profilingSettings;
                    }

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getButton() == 1) {
                            if (LargeTaskPresenter.this.selectedSettingsIndex != -1 && this.val$settings != LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.selectedSettingsIndex)) {
                                LargeTaskPresenter.this.context.selectSettings(this.val$settings);
                            }
                        } else if (mouseEvent.getButton() == 3) {
                            LargeTaskPresenter.this.showPopupMenu(this.val$settings, mouseEvent.getX(), mouseEvent.getY());
                        }
                    }
                });
                tPHyperlinkTextArea.addKeyListener(new KeyAdapter((ProfilingSettings)object, tPHyperlinkTextArea){
                    final /* synthetic */ ProfilingSettings val$settings;
                    final /* synthetic */ TPHyperlinkTextArea val$presenter;
                    {
                        this.val$settings = profilingSettings;
                        this.val$presenter = tPHyperlinkTextArea;
                    }

                    @Override
                    public void keyPressed(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 32 && LargeTaskPresenter.this.selectedSettingsIndex != -1 && this.val$settings != LargeTaskPresenter.this.profilingSettings.get(LargeTaskPresenter.this.selectedSettingsIndex)) {
                            LargeTaskPresenter.this.context.selectSettings(this.val$settings);
                        } else if (keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) {
                            Dimension dimension = this.val$presenter.getSize();
                            LargeTaskPresenter.this.showPopupMenu(this.val$settings, dimension.width / 2, dimension.height / 2);
                        }
                    }
                });
            }
            n = this.profilingSettings.size();
            object = new JLabel("\u00b7");
            ((JComponent)object).setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(3, 25, 0, 2);
            this.configurationsContainer.add((Component)object, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 0, 4);
            this.configurationsContainer.add((Component)((Object)this.createCustom), gridBagConstraints);
            this.context.refreshLayout();
        }
    }

    private static class ConfigurationsContainer
    extends JPanel
    implements Scrollable {
        private ConfigurationsContainer() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return null;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            Container container = this.getParent();
            if (container == null || !(container instanceof JViewport)) {
                return 50;
            }
            return (int)((float)((JViewport)container).getHeight() * 0.95f);
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 20;
        }
    }

    public static interface Context {
        public void refreshLayout();

        public void selectSettings(ProfilingSettings var1);
    }
}

