/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.util.Properties;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointsDisplayer;
import org.netbeans.modules.profiler.spi.ProjectTypeProfiler;
import org.netbeans.modules.profiler.ui.stp.CPUSettingsAdvancedPanel;
import org.netbeans.modules.profiler.ui.stp.CPUSettingsBasicPanel;
import org.netbeans.modules.profiler.ui.stp.MemorySettingsAdvancedPanel;
import org.netbeans.modules.profiler.ui.stp.MemorySettingsBasicPanel;
import org.netbeans.modules.profiler.ui.stp.MonitorSettingsAdvancedPanel;
import org.netbeans.modules.profiler.ui.stp.MonitorSettingsBasicPanel;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.ui.stp.SettingsContainerPanel;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.filesystems.FileObject;

public class DefaultSettingsConfigurator
implements SelectProfilingTask.SettingsConfigurator {
    public static final DefaultSettingsConfigurator SHARED_INSTANCE = new DefaultSettingsConfigurator();
    private CPUContents cpuContents = new CPUContents();
    private FileObject profiledFile;
    private MemoryContents memoryContents = new MemoryContents();
    private MonitorContents monitorContents = new MonitorContents();
    private ProfilingSettings settings;
    private Project project;
    private boolean enableOverride;
    private boolean isAttach;
    private boolean isModify;
    private boolean isPreset;

    @Override
    public SettingsContainerPanel.Contents getCPUConfigurator() {
        return this.cpuContents;
    }

    @Override
    public void setContext(Project project, FileObject fileObject, boolean bl, boolean bl2, boolean bl3) {
        this.project = project;
        this.profiledFile = fileObject;
        this.enableOverride = bl3;
        this.isAttach = bl;
        this.isModify = bl2;
        this.monitorContents.setContext(project, fileObject, bl, bl2, bl3);
        this.cpuContents.setContext(project, fileObject, bl, bl2, bl3);
        this.memoryContents.setContext(project, fileObject, bl, bl2, bl3);
    }

    @Override
    public JPanel getCustomSettingsPanel() {
        return null;
    }

    @Override
    public SettingsContainerPanel.Contents getMemoryConfigurator() {
        return this.memoryContents;
    }

    @Override
    public SettingsContainerPanel.Contents getMonitorConfigurator() {
        return this.monitorContents;
    }

    @Override
    public void setSettings(ProfilingSettings profilingSettings) {
        this.settings = profilingSettings;
        this.isPreset = profilingSettings.isPreset();
        if (Utils.isMonitorSettings(profilingSettings)) {
            this.monitorContents.setSettings(profilingSettings);
        } else if (Utils.isCPUSettings(profilingSettings)) {
            this.cpuContents.setSettings(profilingSettings);
        } else if (Utils.isMemorySettings(profilingSettings)) {
            this.memoryContents.setSettings(profilingSettings);
        }
    }

    @Override
    public ProfilingSettings getSettings() {
        return this.settings;
    }

    @Override
    public ProfilingSettings createFinalSettings() {
        if (Utils.isMonitorSettings(this.settings)) {
            return this.monitorContents.createFinalSettings();
        }
        if (Utils.isCPUSettings(this.settings)) {
            return this.cpuContents.createFinalSettings();
        }
        if (Utils.isMemorySettings(this.settings)) {
            return this.memoryContents.createFinalSettings();
        }
        return null;
    }

    @Override
    public void loadCustomSettings(Properties properties) {
    }

    @Override
    public void reset() {
        this.settings = null;
        this.project = null;
        this.profiledFile = null;
        this.enableOverride = false;
        this.isAttach = false;
        this.isModify = false;
        this.isPreset = false;
        this.monitorContents.reset();
        this.cpuContents.reset();
        this.memoryContents.reset();
    }

    @Override
    public void storeCustomSettings(Properties properties) {
    }

    @Override
    public void synchronizeSettings() {
        if (Utils.isMonitorSettings(this.settings)) {
            this.monitorContents.synchronizeSettings();
        } else if (Utils.isCPUSettings(this.settings)) {
            this.cpuContents.synchronizeSettings();
        } else if (Utils.isMemorySettings(this.settings)) {
            this.memoryContents.synchronizeSettings();
        }
    }

    protected boolean isAttach() {
        return this.isAttach;
    }

    protected boolean isModify() {
        return this.isModify;
    }

    protected boolean isPreset() {
        return this.isPreset;
    }

    protected FileObject getProfiledFile() {
        return this.profiledFile;
    }

    protected Project getProject() {
        return this.project;
    }

    protected boolean enableOverride() {
        return this.enableOverride;
    }

    public static class MonitorContents
    implements SettingsContainerPanel.Contents,
    ChangeListener {
        private FileObject profiledFile;
        private MonitorSettingsAdvancedPanel advancedSettingsPanel;
        private MonitorSettingsBasicPanel basicSettingsPanel;
        private ProfilingSettings settings;
        private Project project;
        private ProjectTypeProfiler ptp;
        private Vector<ChangeListener> changeListeners = new Vector();
        private boolean enableOverride;
        private boolean internalChange = false;
        private boolean isAttach;
        private boolean isModify;
        private boolean isPreset;

        public MonitorContents() {
            this.basicSettingsPanel = new MonitorSettingsBasicPanel();
            this.advancedSettingsPanel = new MonitorSettingsAdvancedPanel();
            this.basicSettingsPanel.addChangeListener(this);
            this.advancedSettingsPanel.addChangeListener(this);
        }

        @Override
        public JPanel getAdvancedSettingsPanel() {
            return this.advancedSettingsPanel;
        }

        @Override
        public JPanel getBasicSettingsPanel() {
            return this.basicSettingsPanel;
        }

        public void setContext(Project project, FileObject fileObject, boolean bl, boolean bl2, boolean bl3) {
            this.project = project;
            this.ptp = ProjectUtilities.getProjectTypeProfiler(project);
            this.profiledFile = fileObject;
            this.enableOverride = bl3;
            this.isAttach = bl;
            this.isModify = bl2;
        }

        @Override
        public float getProfilingOverhead() {
            if (this.settings == null) {
                return 0.0f;
            }
            this.synchronizeBasicAdvancedPanels();
            return this.ptp.getProfilingOverhead(this.createFinalSettings());
        }

        public void setSettings(ProfilingSettings profilingSettings) {
            this.settings = profilingSettings;
            this.isPreset = profilingSettings.isPreset();
            this.internalChange = true;
            SelectProfilingTask.getDefault().enableSubmitButton();
            this.basicSettingsPanel.setThreadsMonitoring(profilingSettings.getThreadsMonitoringEnabled());
            if (!profilingSettings.isPreset()) {
                this.advancedSettingsPanel.enableAll();
            }
            this.advancedSettingsPanel.setOverrideAvailable(this.enableOverride);
            this.advancedSettingsPanel.setOverrideSettings(profilingSettings.getOverrideGlobalSettings());
            this.advancedSettingsPanel.setWorkingDirectory(profilingSettings.getWorkingDir());
            this.advancedSettingsPanel.setJavaPlatformName(profilingSettings.getJavaPlatformName());
            this.advancedSettingsPanel.setVMArguments(profilingSettings.getJVMArgs());
            if (profilingSettings.isPreset()) {
                this.advancedSettingsPanel.disableAll();
            }
            this.internalChange = false;
            this.fireSettingsChanged();
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            if (!this.changeListeners.contains(changeListener)) {
                this.changeListeners.add(changeListener);
            }
        }

        public ProfilingSettings createFinalSettings() {
            ProfilingSettings profilingSettings = ProfilingSettingsPresets.createMonitorPreset();
            profilingSettings.setIsPreset(this.settings.isPreset());
            profilingSettings.setSettingsName(this.settings.getSettingsName());
            profilingSettings.setThreadsMonitoringEnabled(this.basicSettingsPanel.getThreadsMonitoring());
            profilingSettings.setOverrideGlobalSettings(this.advancedSettingsPanel.getOverrideSettings());
            profilingSettings.setWorkingDir(this.advancedSettingsPanel.getWorkingDirectory());
            profilingSettings.setJavaPlatformName(this.advancedSettingsPanel.getJavaPlatformName());
            profilingSettings.setJVMArgs(this.advancedSettingsPanel.getVMArguments());
            return profilingSettings;
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
            this.changeListeners.remove(changeListener);
        }

        public void reset() {
            this.settings = null;
            this.project = null;
            this.ptp = null;
            this.profiledFile = null;
            this.enableOverride = false;
            this.isAttach = false;
            this.isModify = false;
            this.isPreset = false;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.fireSettingsChanged();
        }

        @Override
        public void synchronizeBasicAdvancedPanels() {
        }

        public void synchronizeSettings() {
            this.synchronizeBasicAdvancedPanels();
            this.settings.setThreadsMonitoringEnabled(this.basicSettingsPanel.getThreadsMonitoring());
            this.settings.setOverrideGlobalSettings(this.advancedSettingsPanel.getOverrideSettings());
            this.settings.setWorkingDir(this.advancedSettingsPanel.getWorkingDirectory());
            this.settings.setJavaPlatformName(this.advancedSettingsPanel.getJavaPlatformName());
            this.settings.setJVMArgs(this.advancedSettingsPanel.getVMArguments());
        }

        private void fireSettingsChanged() {
            if (!this.internalChange) {
                for (ChangeListener changeListener : this.changeListeners) {
                    changeListener.stateChanged(new ChangeEvent(this));
                }
            }
        }
    }

    public static class MemoryContents
    implements SettingsContainerPanel.Contents,
    ChangeListener {
        private FileObject profiledFile;
        private MemorySettingsAdvancedPanel advancedSettingsPanel = new MemorySettingsAdvancedPanel();
        private MemorySettingsBasicPanel basicSettingsPanel = new MemorySettingsBasicPanel();
        private ProfilingSettings settings;
        private Project project;
        private ProjectTypeProfiler ptp;
        private Vector<ChangeListener> changeListeners = new Vector();
        private boolean enableOverride;
        private boolean internalChange = false;
        private boolean isAttach;
        private boolean isModify;
        private boolean isPreset;

        public MemoryContents() {
            this.basicSettingsPanel = new MemorySettingsBasicPanel();
            this.advancedSettingsPanel = new MemorySettingsAdvancedPanel();
            this.basicSettingsPanel.addChangeListener(this);
            this.advancedSettingsPanel.addChangeListener(this);
        }

        @Override
        public JPanel getAdvancedSettingsPanel() {
            return this.advancedSettingsPanel;
        }

        @Override
        public JPanel getBasicSettingsPanel() {
            return this.basicSettingsPanel;
        }

        public void setContext(Project project, FileObject fileObject, boolean bl, boolean bl2, boolean bl3) {
            this.project = project;
            this.ptp = ProjectUtilities.getProjectTypeProfiler(project);
            this.profiledFile = fileObject;
            this.enableOverride = bl3;
            this.isAttach = bl;
            this.isModify = bl2;
        }

        @Override
        public float getProfilingOverhead() {
            if (this.settings == null) {
                return 0.0f;
            }
            this.synchronizeBasicAdvancedPanels();
            return this.ptp.getProfilingOverhead(this.createFinalSettings());
        }

        public void setSettings(ProfilingSettings profilingSettings) {
            this.settings = profilingSettings;
            this.isPreset = profilingSettings.isPreset();
            this.internalChange = true;
            SelectProfilingTask.getDefault().enableSubmitButton();
            this.basicSettingsPanel.setContext(this.project, new Runnable(){

                @Override
                public void run() {
                    MemoryContents.this.synchronizeSettings();
                    ProfilingPointsDisplayer.displayProfilingPoints(MemoryContents.this.project, MemoryContents.this.settings);
                }
            });
            this.basicSettingsPanel.setProfilingType(profilingSettings.getProfilingType());
            this.basicSettingsPanel.setTrackEvery(profilingSettings.getAllocTrackEvery());
            this.basicSettingsPanel.setRecordStackTrace(profilingSettings.getAllocStackTraceLimit() != 0);
            this.basicSettingsPanel.setUseProfilingPoints(profilingSettings.useProfilingPoints() && this.project != null);
            if (!profilingSettings.isPreset()) {
                this.advancedSettingsPanel.enableAll();
            }
            this.advancedSettingsPanel.setAllocStackTraceLimit(profilingSettings.getAllocStackTraceLimit());
            this.advancedSettingsPanel.setRunGC(profilingSettings.getRunGCOnGetResultsInMemoryProfiling());
            this.advancedSettingsPanel.setThreadsMonitoring(profilingSettings.getThreadsMonitoringEnabled());
            this.advancedSettingsPanel.setOverrideAvailable(this.enableOverride);
            this.advancedSettingsPanel.setOverrideSettings(profilingSettings.getOverrideGlobalSettings());
            this.advancedSettingsPanel.setWorkingDirectory(profilingSettings.getWorkingDir());
            this.advancedSettingsPanel.setJavaPlatformName(profilingSettings.getJavaPlatformName());
            this.advancedSettingsPanel.setVMArguments(profilingSettings.getJVMArgs());
            if (profilingSettings.isPreset()) {
                this.advancedSettingsPanel.disableAll();
            }
            this.internalChange = false;
            this.fireSettingsChanged();
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            if (!this.changeListeners.contains(changeListener)) {
                this.changeListeners.add(changeListener);
            }
        }

        public ProfilingSettings createFinalSettings() {
            ProfilingSettings profilingSettings = ProfilingSettingsPresets.createMemoryPreset();
            profilingSettings.setIsPreset(this.settings.isPreset());
            profilingSettings.setSettingsName(this.settings.getSettingsName());
            profilingSettings.setProfilingType(this.basicSettingsPanel.getProfilingType());
            profilingSettings.setAllocTrackEvery(this.basicSettingsPanel.getTrackEvery());
            profilingSettings.setUseProfilingPoints(this.basicSettingsPanel.getUseProfilingPoints());
            profilingSettings.setAllocStackTraceLimit(this.basicSettingsPanel.getRecordStackTrace() ? this.advancedSettingsPanel.getAllocStackTraceLimit() : 0);
            profilingSettings.setRunGCOnGetResultsInMemoryProfiling(this.advancedSettingsPanel.getRunGC());
            profilingSettings.setThreadsMonitoringEnabled(this.advancedSettingsPanel.getThreadsMonitoring());
            profilingSettings.setOverrideGlobalSettings(this.advancedSettingsPanel.getOverrideSettings());
            profilingSettings.setWorkingDir(this.advancedSettingsPanel.getWorkingDirectory());
            profilingSettings.setJavaPlatformName(this.advancedSettingsPanel.getJavaPlatformName());
            profilingSettings.setJVMArgs(this.advancedSettingsPanel.getVMArguments());
            return profilingSettings;
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
            this.changeListeners.remove(changeListener);
        }

        public void reset() {
            this.settings = null;
            this.project = null;
            this.ptp = null;
            this.profiledFile = null;
            this.enableOverride = false;
            this.isAttach = false;
            this.isModify = false;
            this.isPreset = false;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.fireSettingsChanged();
        }

        @Override
        public void synchronizeBasicAdvancedPanels() {
            boolean bl = this.basicSettingsPanel.getRecordStackTrace();
            this.advancedSettingsPanel.setRecordStackTrace(bl);
            this.advancedSettingsPanel.updateRunGC(this.basicSettingsPanel.getProfilingType() == 2);
        }

        public void synchronizeSettings() {
            this.synchronizeBasicAdvancedPanels();
            this.settings.setProfilingType(this.basicSettingsPanel.getProfilingType());
            this.settings.setAllocTrackEvery(this.basicSettingsPanel.getTrackEvery());
            this.settings.setUseProfilingPoints(this.basicSettingsPanel.getUseProfilingPoints());
            this.settings.setAllocStackTraceLimit(this.basicSettingsPanel.getRecordStackTrace() ? this.advancedSettingsPanel.getAllocStackTraceLimit() : 0);
            this.settings.setRunGCOnGetResultsInMemoryProfiling(this.advancedSettingsPanel.getRunGC());
            this.settings.setThreadsMonitoringEnabled(this.advancedSettingsPanel.getThreadsMonitoring());
            this.settings.setOverrideGlobalSettings(this.advancedSettingsPanel.getOverrideSettings());
            this.settings.setWorkingDir(this.advancedSettingsPanel.getWorkingDirectory());
            this.settings.setJavaPlatformName(this.advancedSettingsPanel.getJavaPlatformName());
            this.settings.setJVMArgs(this.advancedSettingsPanel.getVMArguments());
        }

        private void fireSettingsChanged() {
            if (!this.internalChange) {
                for (ChangeListener changeListener : this.changeListeners) {
                    changeListener.stateChanged(new ChangeEvent(this));
                }
            }
        }
    }

    public static class CPUContents
    implements SettingsContainerPanel.Contents,
    ChangeListener {
        private static final boolean ENABLE_THREAD_CPU_TIMER = Boolean.getBoolean("org.netbeans.lib.profiler.enableThreadCPUTimer");
        private CPUSettingsAdvancedPanel advancedSettingsPanel;
        private CPUSettingsBasicPanel basicSettingsPanel;
        private FileObject profiledFile;
        private ProfilingSettings settings;
        private Project project;
        private ProjectTypeProfiler ptp;
        private Vector<ChangeListener> changeListeners = new Vector();
        private boolean enableOverride;
        private boolean internalChange = false;
        private boolean isAttach;
        private boolean isModify;
        private boolean isPreset;
        private boolean useCPUTimer;

        public CPUContents() {
            this.basicSettingsPanel = new CPUSettingsBasicPanel();
            this.advancedSettingsPanel = new CPUSettingsAdvancedPanel();
            this.basicSettingsPanel.addChangeListener(this);
            this.advancedSettingsPanel.addChangeListener(this);
        }

        @Override
        public JPanel getAdvancedSettingsPanel() {
            return this.advancedSettingsPanel;
        }

        @Override
        public JPanel getBasicSettingsPanel() {
            return this.basicSettingsPanel;
        }

        public void setContext(Project project, FileObject fileObject, boolean bl, boolean bl2, boolean bl3) {
            this.project = project;
            this.ptp = ProjectUtilities.getProjectTypeProfiler(project);
            this.profiledFile = fileObject;
            this.enableOverride = bl3;
            this.isAttach = bl;
            this.isModify = bl2;
            this.useCPUTimer = ENABLE_THREAD_CPU_TIMER || bl || Platform.isSolaris();
        }

        @Override
        public float getProfilingOverhead() {
            if (this.settings == null) {
                return 0.0f;
            }
            this.synchronizeBasicAdvancedPanels();
            return this.ptp.getProfilingOverhead(this.createFinalSettings());
        }

        public void setSettings(ProfilingSettings profilingSettings) {
            this.settings = profilingSettings;
            this.isPreset = profilingSettings.isPreset();
            this.internalChange = true;
            this.basicSettingsPanel.setContext(this.project, SelectProfilingTask.getDefault().getPredefinedInstrFilterKeys(), new Runnable(){

                @Override
                public void run() {
                    CPUContents.this.synchronizeSettings();
                    ProfilingPointsDisplayer.displayProfilingPoints(CPUContents.this.project, CPUContents.this.settings);
                }
            });
            this.basicSettingsPanel.setProfilingType(profilingSettings.getProfilingType());
            this.basicSettingsPanel.setRootMethods(profilingSettings.getInstrumentationRootMethods());
            this.basicSettingsPanel.setQuickFilter(profilingSettings.getQuickFilter());
            this.basicSettingsPanel.setInstrumentationFilter(profilingSettings.getSelectedInstrumentationFilter());
            this.basicSettingsPanel.setUseProfilingPoints(profilingSettings.useProfilingPoints() && this.project != null);
            if (!profilingSettings.isPreset()) {
                this.advancedSettingsPanel.enableAll();
            }
            this.advancedSettingsPanel.setCPUProfilingType(profilingSettings.getCPUProfilingType());
            this.advancedSettingsPanel.setSamplingInterval(profilingSettings.getSamplingInterval());
            this.advancedSettingsPanel.setExcludeThreadTime(profilingSettings.getExcludeWaitTime());
            this.advancedSettingsPanel.setProfileSpawnedThreads(profilingSettings.getInstrumentSpawnedThreads());
            this.advancedSettingsPanel.setUseCPUTimer(profilingSettings.getThreadCPUTimerOn(), this.useCPUTimer);
            this.advancedSettingsPanel.setInstrumentMethodInvoke(profilingSettings.getInstrumentMethodInvoke());
            this.advancedSettingsPanel.setInstrumentGettersSetters(profilingSettings.getInstrumentGetterSetterMethods());
            this.advancedSettingsPanel.setInstrumentEmptyMethods(profilingSettings.getInstrumentEmptyMethods());
            this.advancedSettingsPanel.setInstrumentationScheme(profilingSettings.getInstrScheme());
            this.advancedSettingsPanel.setProfiledThreadsLimit(profilingSettings.getNProfiledThreadsLimit());
            this.advancedSettingsPanel.setProfileFramework(profilingSettings.getProfileUnderlyingFramework());
            this.advancedSettingsPanel.setThreadsMonitoring(profilingSettings.getThreadsMonitoringEnabled());
            this.advancedSettingsPanel.setOverrideAvailable(this.enableOverride);
            this.advancedSettingsPanel.setOverrideSettings(profilingSettings.getOverrideGlobalSettings());
            this.advancedSettingsPanel.setWorkingDirectory(profilingSettings.getWorkingDir());
            this.advancedSettingsPanel.setJavaPlatformName(profilingSettings.getJavaPlatformName());
            this.advancedSettingsPanel.setVMArguments(profilingSettings.getJVMArgs());
            if (profilingSettings.isPreset()) {
                this.advancedSettingsPanel.disableAll();
            }
            this.internalChange = false;
            this.fireSettingsChanged();
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            if (!this.changeListeners.contains(changeListener)) {
                this.changeListeners.add(changeListener);
            }
        }

        public ProfilingSettings createFinalSettings() {
            ProfilingSettings profilingSettings = ProfilingSettingsPresets.createCPUPreset((int)this.settings.getProfilingType());
            profilingSettings.setIsPreset(this.settings.isPreset());
            profilingSettings.setSettingsName(this.settings.getSettingsName());
            profilingSettings.setProfilingType(this.basicSettingsPanel.getProfilingType());
            profilingSettings.setSelectedInstrumentationFilter(this.basicSettingsPanel.getInstrumentationFilter());
            profilingSettings.setUseProfilingPoints(this.basicSettingsPanel.getUseProfilingPoints());
            profilingSettings.setCPUProfilingType(this.advancedSettingsPanel.getCPUProfilingType());
            profilingSettings.setSamplingInterval(this.advancedSettingsPanel.getSamplingInterval());
            profilingSettings.setExcludeWaitTime(this.advancedSettingsPanel.getExcludeThreadTime());
            profilingSettings.setProfileUnderlyingFramework(this.advancedSettingsPanel.getProfileFramework());
            profilingSettings.setInstrumentSpawnedThreads(this.advancedSettingsPanel.getProfileSpawnedThreads());
            profilingSettings.setThreadCPUTimerOn(this.useCPUTimer && this.advancedSettingsPanel.getUseCPUTimer());
            profilingSettings.setInstrumentMethodInvoke(this.advancedSettingsPanel.getInstrumentMethodInvoke());
            profilingSettings.setInstrumentGetterSetterMethods(this.advancedSettingsPanel.getInstrumentGettersSetters());
            profilingSettings.setInstrumentEmptyMethods(this.advancedSettingsPanel.getInstrumentEmptyMethods());
            profilingSettings.setInstrScheme(this.advancedSettingsPanel.getInstrumentationScheme());
            profilingSettings.setNProfiledThreadsLimit(this.advancedSettingsPanel.getProfiledThreadsLimit());
            profilingSettings.setThreadsMonitoringEnabled(this.advancedSettingsPanel.getThreadsMonitoring());
            profilingSettings.setOverrideGlobalSettings(this.advancedSettingsPanel.getOverrideSettings());
            profilingSettings.setWorkingDir(this.advancedSettingsPanel.getWorkingDirectory());
            profilingSettings.setJavaPlatformName(this.advancedSettingsPanel.getJavaPlatformName());
            profilingSettings.setJVMArgs(this.advancedSettingsPanel.getVMArguments());
            if (profilingSettings.getProfilingType() == 8) {
                profilingSettings.setInstrumentationRootMethods(new ClientUtils.SourceCodeSelection[0]);
                profilingSettings.instrRootMethodsPending = true;
            } else {
                profilingSettings.setInstrumentationRootMethods(this.basicSettingsPanel.getRootMethods());
            }
            return profilingSettings;
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
            this.changeListeners.remove(changeListener);
        }

        public void reset() {
            this.settings = null;
            this.project = null;
            this.ptp = null;
            this.profiledFile = null;
            this.enableOverride = false;
            this.isAttach = false;
            this.isModify = false;
            this.isPreset = false;
            this.useCPUTimer = false;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.fireSettingsChanged();
        }

        @Override
        public void synchronizeBasicAdvancedPanels() {
            if (this.basicSettingsPanel.getProfilingType() == 8) {
                this.advancedSettingsPanel.setEntireAppDefaults(this.isPreset);
            } else {
                this.advancedSettingsPanel.setPartOfAppDefaults(this.isPreset);
            }
        }

        public void synchronizeSettings() {
            this.synchronizeBasicAdvancedPanels();
            this.settings.setProfilingType(this.basicSettingsPanel.getProfilingType());
            this.settings.setInstrumentationRootMethods(this.basicSettingsPanel.getRootMethods());
            this.settings.setQuickFilter(this.basicSettingsPanel.getQuickFilter());
            this.settings.setSelectedInstrumentationFilter(this.basicSettingsPanel.getInstrumentationFilter());
            this.settings.setUseProfilingPoints(this.basicSettingsPanel.getUseProfilingPoints());
            this.settings.setCPUProfilingType(this.advancedSettingsPanel.getCPUProfilingType());
            this.settings.setSamplingInterval(this.advancedSettingsPanel.getSamplingInterval());
            this.settings.setExcludeWaitTime(this.advancedSettingsPanel.getExcludeThreadTime());
            this.settings.setProfileUnderlyingFramework(this.advancedSettingsPanel.getProfileFramework());
            this.settings.setInstrumentSpawnedThreads(this.advancedSettingsPanel.getProfileSpawnedThreads());
            this.settings.setThreadCPUTimerOn(this.advancedSettingsPanel.getUseCPUTimer());
            this.settings.setInstrumentMethodInvoke(this.advancedSettingsPanel.getInstrumentMethodInvoke());
            this.settings.setInstrumentGetterSetterMethods(this.advancedSettingsPanel.getInstrumentGettersSetters());
            this.settings.setInstrumentEmptyMethods(this.advancedSettingsPanel.getInstrumentEmptyMethods());
            this.settings.setInstrScheme(this.advancedSettingsPanel.getInstrumentationScheme());
            this.settings.setNProfiledThreadsLimit(this.advancedSettingsPanel.getProfiledThreadsLimit());
            this.settings.setThreadsMonitoringEnabled(this.advancedSettingsPanel.getThreadsMonitoring());
            this.settings.setOverrideGlobalSettings(this.advancedSettingsPanel.getOverrideSettings());
            this.settings.setWorkingDir(this.advancedSettingsPanel.getWorkingDirectory());
            this.settings.setJavaPlatformName(this.advancedSettingsPanel.getJavaPlatformName());
            this.settings.setJVMArgs(this.advancedSettingsPanel.getVMArguments());
        }

        private void fireSettingsChanged() {
            if (!this.internalChange) {
                for (ChangeListener changeListener : this.changeListeners) {
                    changeListener.stateChanged(new ChangeEvent(this));
                }
            }
        }
    }
}

