/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SnapshotCustomizer
extends ValidityAwarePanel
implements ActionListener,
ChangeListener,
DocumentListener {
    private static final String TAKE_LABEL_TEXT = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_TakeLabelText");
    private static final String PROFILING_DATA_RADIO_TEXT = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_ProfilingDataRadioText");
    private static final String HEAPDUMP_RADIO_TEXT = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_HeapDumpRadioText");
    private static final String SAVE_LABEL_TEXT = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_SaveLabelText");
    private static final String TO_PROJECT_RADIO_TEXT = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_ToProjectRadioText");
    private static final String TO_DIRECTORY_RADIO_TEXT = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_ToDirectoryRadioText");
    private static final String BROWSE_BUTTON_TEXT = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_BrowseButtonText");
    private static final String RESET_RESULTS_CHECKBOX_TEXT = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_ResetResultsCheckboxText");
    private static final String SELECT_SNAPSHOT_DIALOG_CAPTION = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_SelectSnapshotDialogCaption");
    private static final String SAVE_FIELD_ACCESS_NAME = NbBundle.getMessage(SnapshotCustomizer.class, (String)"SnapshotCustomizer_SaveFieldAccessName");
    private static int defaultTextComponentHeight = -1;
    private static JFileChooser fileChooser;
    private JButton saveToFileButton;
    private JCheckBox resetResultsCheckbox;
    private JLabel saveLabel;
    private JLabel takeLabel;
    private JPanel firstLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JPanel secondLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JPanel thirdLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JRadioButton saveToFileRadio;
    private JRadioButton saveToProjectRadio;
    private JRadioButton takeHeapdumpRadio;
    private JRadioButton takeSnapshotRadio;
    private JTextField saveToFileField;

    public SnapshotCustomizer() {
        this.initComponents();
    }

    public int getPreferredCaptionAreaWidth() {
        return Math.max(this.takeLabel.getPreferredSize().width, this.saveLabel.getPreferredSize().width);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.saveToFileButton) {
            JFileChooser fileChooser = this.getFileChooser();
            fileChooser.setCurrentDirectory(new File(this.saveToFileField.getText()).getParentFile());
            if (fileChooser.showOpenDialog(null) == 0) {
                this.saveToFileField.setText(fileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            // empty catch block
        }
        SnapshotCustomizer main = new SnapshotCustomizer();
        JFrame frame = new JFrame("Customize Profiling Point");
        frame.getContentPane().add(main);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public void normalizeCaptionAreaWidth(int captionAreaWidth) {
        int requiredCaptionAreaWidth = this.getPreferredCaptionAreaWidth();
        int diffCaptionAreaWidth = captionAreaWidth - requiredCaptionAreaWidth;
        int normalizedCaptionAreaWidth = diffCaptionAreaWidth > 0 ? diffCaptionAreaWidth : 0;
        this.firstLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, normalizedCaptionAreaWidth, 0, 0));
        this.secondLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, normalizedCaptionAreaWidth, 0, 0));
        this.thirdLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, normalizedCaptionAreaWidth, 0, 0));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.saveToProjectRadio) {
            this.updateValidity();
        } else if (e.getSource() == this.saveToFileRadio) {
            this.saveToFileField.setEnabled(this.saveToFileRadio.isSelected());
            this.saveToFileButton.setEnabled(this.saveToFileRadio.isSelected());
            this.updateValidity();
        }
    }

    void setPPFile(String fileName) {
        if (fileName == null) {
            this.saveToFileField.setText("");
        } else {
            this.saveToFileField.setText(fileName);
        }
    }

    String getPPFile() {
        String text = this.saveToFileField.getText().trim();
        if (text.length() == 0) {
            return null;
        }
        return text;
    }

    void setPPResetResults(boolean resetResults) {
        this.resetResultsCheckbox.setSelected(resetResults);
    }

    boolean getPPResetResults() {
        return this.resetResultsCheckbox.isSelected();
    }

    void setPPTarget(boolean target) {
        this.saveToProjectRadio.setSelected(target);
        this.saveToFileRadio.setSelected(!target);
    }

    boolean getPPTarget() {
        return this.saveToProjectRadio.isSelected();
    }

    void setPPType(boolean type) {
        this.takeSnapshotRadio.setSelected(type);
        this.takeHeapdumpRadio.setSelected(!type);
        this.resetResultsCheckbox.setEnabled(type);
    }

    boolean getPPType() {
        return this.takeSnapshotRadio.isSelected();
    }

    private boolean isDestinationDirectoryValid() {
        File file = new File(this.saveToFileField.getText());
        return file.exists() && file.isDirectory();
    }

    private JFileChooser getFileChooser() {
        if (fileChooser == null) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogType(0);
            chooser.setDialogTitle(SELECT_SNAPSHOT_DIALOG_CAPTION);
            fileChooser = chooser;
        }
        return fileChooser;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.takeLabel = new JLabel(TAKE_LABEL_TEXT);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.takeLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.firstLineCaptionSpacer, constraints);
        ButtonGroup takeRadiosGroup = new ButtonGroup();
        JPanel takeRadiosContainer = new JPanel(new GridBagLayout());
        this.takeSnapshotRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.takeSnapshotRadio, (String)PROFILING_DATA_RADIO_TEXT);
        takeRadiosGroup.add(this.takeSnapshotRadio);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        takeRadiosContainer.add((Component)this.takeSnapshotRadio, constraints);
        this.takeSnapshotRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SnapshotCustomizer.this.resetResultsCheckbox.setEnabled(SnapshotCustomizer.this.takeSnapshotRadio.isSelected());
            }
        });
        this.takeHeapdumpRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.takeHeapdumpRadio, (String)HEAPDUMP_RADIO_TEXT);
        takeRadiosGroup.add(this.takeHeapdumpRadio);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        takeRadiosContainer.add((Component)this.takeHeapdumpRadio, constraints);
        JPanel takeRadiosSpacer = new JPanel(new FlowLayout(3, 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        takeRadiosContainer.add((Component)takeRadiosSpacer, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)takeRadiosContainer, constraints);
        ButtonGroup saveRadiosGroup = new ButtonGroup();
        this.saveLabel = new JLabel(SAVE_LABEL_TEXT);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.saveLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.secondLineCaptionSpacer, constraints);
        this.saveToProjectRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.saveToProjectRadio, (String)TO_PROJECT_RADIO_TEXT);
        saveRadiosGroup.add(this.saveToProjectRadio);
        this.saveToProjectRadio.addChangeListener(this);
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.saveToProjectRadio, constraints);
        JPanel saveToFileSettingsContainer = new JPanel(new GridBagLayout());
        JPanel saveToFileSpacer = new JPanel(new FlowLayout(3, 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        takeRadiosContainer.add((Component)saveToFileSpacer, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.thirdLineCaptionSpacer, constraints);
        this.saveToFileRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.saveToFileRadio, (String)TO_DIRECTORY_RADIO_TEXT);
        saveRadiosGroup.add(this.saveToFileRadio);
        this.saveToFileRadio.setSelected(true);
        this.saveToFileRadio.addChangeListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        saveToFileSettingsContainer.add((Component)this.saveToFileRadio, constraints);
        this.saveToFileField = new JTextField(""){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getMinimumSize().width, super.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.saveToFileField.getAccessibleContext().setAccessibleName(TO_DIRECTORY_RADIO_TEXT);
        this.saveToFileField.getAccessibleContext().setAccessibleDescription(SAVE_FIELD_ACCESS_NAME);
        this.saveToFileField.getDocument().addDocumentListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 5);
        saveToFileSettingsContainer.add((Component)this.saveToFileField, constraints);
        this.saveToFileButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.saveToFileButton, (String)BROWSE_BUTTON_TEXT);
        this.saveToFileButton.addActionListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        saveToFileSettingsContainer.add((Component)this.saveToFileButton, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)saveToFileSettingsContainer, constraints);
        this.resetResultsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.resetResultsCheckbox, (String)RESET_RESULTS_CHECKBOX_TEXT);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.resetResultsCheckbox, constraints);
        JPanel fillerPanel = new JPanel(new FlowLayout(3, 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.weighty = 1.0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)fillerPanel, constraints);
    }

    private void updateValidity() {
        boolean isValid;
        boolean isDirectoryValid = this.isDestinationDirectoryValid();
        this.saveToFileField.setForeground(isDirectoryValid ? UIManager.getColor("TextField.foreground") : Color.RED);
        boolean bl = isValid = this.saveToProjectRadio.isSelected() || isDirectoryValid;
        if (isValid != this.areSettingsValid()) {
            this.fireValidityChanged(isValid);
        }
    }
}

