/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.modules.profiler.heapwalk.HintsController;
import org.netbeans.modules.profiler.ui.Utils;
import org.openide.util.NbBundle;

public class HintsControllerUI
extends JTitledPanel {
    private static final String VIEW_TITLE_HINTS = NbBundle.getMessage(HintsControllerUI.class, (String)"HintsControllerUI_ViewTitleHints");
    private static final String FIND_BUTTON_TITLE = NbBundle.getMessage(HintsControllerUI.class, (String)"HintsControllerUI_FindButton");
    private static final String FIND_BUTTON_TOOLTIP = NbBundle.getMessage(HintsControllerUI.class, (String)"HintsControllerUI_FindButtonTooltip");
    private static final String LABEL1_STRING = NbBundle.getMessage(HintsControllerUI.class, (String)"HintsControllerUI_Label1String");
    private static final String LABEL2_STRING = NbBundle.getMessage(HintsControllerUI.class, (String)"HintsControllerUI_Label2String");
    private static final Number OBJECTS_DEFAULT = 20;
    private static final int OBJECTS_MAX = 100;
    private HintsController hintsController;
    private JPanel hintsTextContainer;
    private JSpinner spinner;
    private JLabel textLabel1;
    private JLabel textLabel2;
    private JButton findButton;
    private HTMLTextArea dataArea;

    public HintsControllerUI(HintsController hintsController) {
        super(VIEW_TITLE_HINTS, (Icon)Utils.FIND_ACTION_ICON, true);
        this.hintsController = hintsController;
        this.initComponents();
    }

    public void setResult(String result) {
        this.dataArea.setText(result);
        try {
            this.dataArea.setCaretPosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.findButton.setEnabled(true);
    }

    private void initComponents() {
        final int SPINNER_HEIGHT = new JTextField().getPreferredSize().height;
        this.setLayout(new BorderLayout());
        this.hintsTextContainer = new JPanel(new GridBagLayout());
        this.hintsTextContainer.setOpaque(false);
        this.hintsTextContainer.setBorder(BorderFactory.createMatteBorder(0, 0, 10, 0, UIUtils.getProfilerResultsBackground()));
        this.textLabel1 = new JLabel(LABEL1_STRING);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.hintsTextContainer.add((Component)this.textLabel1, constraints);
        this.spinner = new JExtendedSpinner(new SpinnerNumberModel(OBJECTS_DEFAULT, Integer.valueOf(1), Integer.valueOf(100), (Number)1)){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, SPINNER_HEIGHT);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.weighty = 1.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.hintsTextContainer.add((Component)this.spinner, constraints);
        this.textLabel2 = new JLabel(LABEL2_STRING);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.hintsTextContainer.add((Component)this.textLabel2, constraints);
        this.findButton = new JButton(FIND_BUTTON_TITLE){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                HintsControllerUI.this.findButton.setEnabled(false);
                int selectedValue = ((Number)HintsControllerUI.this.spinner.getValue()).intValue();
                HintsControllerUI.this.hintsController.computeBiggestObjects(selectedValue);
            }
        };
        this.findButton.setToolTipText(FIND_BUTTON_TOOLTIP);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.hintsTextContainer.add((Component)this.findButton, constraints);
        JPanel fillerPanel = new JPanel(null);
        fillerPanel.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 4;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.hintsTextContainer.add((Component)fillerPanel, constraints);
        this.dataArea = new HTMLTextArea(){

            protected void showURL(URL url) {
                if (url == null) {
                    return;
                }
                HintsControllerUI.this.hintsController.showURL(url);
            }
        };
        JPanel contentsPanel = new JPanel();
        contentsPanel.setLayout(new BorderLayout());
        contentsPanel.setOpaque(true);
        contentsPanel.setBackground(this.dataArea.getBackground());
        contentsPanel.add((Component)this.hintsTextContainer, "North");
        contentsPanel.add((Component)this.dataArea, "Center");
        JScrollPane contentsPanelScrollPane = new JScrollPane(contentsPanel, 20, 30);
        contentsPanelScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, this.getTitleBorderColor()), BorderFactory.createMatteBorder(10, 4, 5, 5, UIUtils.getProfilerResultsBackground())));
        contentsPanelScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        contentsPanelScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        contentsPanelScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.setLayout(new BorderLayout());
        this.add(contentsPanelScrollPane, "Center");
        this.setBackground(this.dataArea.getBackground());
    }
}

