/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.Color;
import java.net.URL;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.AnalysisController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.SummaryController;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.ui.HintsControllerUI;
import org.openide.util.NbBundle;

public class HintsController
extends AbstractController {
    private static final String CLASS_URL_PREFIX = "file://class/";
    private static final String INSTANCE_URL_PREFIX = "file://instance/";
    private static final String CANNOT_RESOLVE_CLASS_MSG = NbBundle.getMessage(AnalysisController.class, (String)"AnalysisController_CannotResolveClassMsg");
    private static final String CANNOT_RESOLVE_INSTANCE_MSG = NbBundle.getMessage(AnalysisController.class, (String)"AnalysisController_CannotResolveInstanceMsg");
    private static final String NO_DATA_MSG = NbBundle.getMessage(HintsController.class, (String)"HintsController_NoData");
    private static final String CLASS_NAME_MSG = NbBundle.getMessage(HintsController.class, (String)"HintsController_ClassName");
    private static final String RETAINED_SIZE_MSG = NbBundle.getMessage(HintsController.class, (String)"HintsController_RetainedSize");
    private SummaryController summaryController;

    public HintsController(SummaryController summaryController) {
        this.summaryController = summaryController;
    }

    public SummaryController getSummaryController() {
        return this.summaryController;
    }

    public void createNavigationHistoryPoint() {
        this.summaryController.getHeapFragmentWalker().createNavigationHistoryPoint();
    }

    public void showURL(URL url) {
        String urls = url.toString();
        HeapFragmentWalker heapFragmentWalker = this.summaryController.getHeapFragmentWalker();
        if (urls.startsWith(INSTANCE_URL_PREFIX)) {
            urls = urls.substring(INSTANCE_URL_PREFIX.length());
            String[] id = urls.split("/");
            JavaClass c = heapFragmentWalker.getHeapFragment().getJavaClassByName(id[0]);
            if (c != null) {
                List instances = c.getInstances();
                Instance i = null;
                int instanceNumber = Integer.parseInt(id[1]);
                if (instanceNumber <= instances.size()) {
                    i = (Instance)instances.get(instanceNumber - 1);
                }
                if (i != null) {
                    heapFragmentWalker.getClassesController().showInstance(i);
                } else {
                    NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_INSTANCE_MSG, id[1], c.getName()));
                }
            } else {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_CLASS_MSG, id[0]));
            }
        } else if (urls.startsWith(CLASS_URL_PREFIX)) {
            urls = urls.substring(CLASS_URL_PREFIX.length());
            JavaClass c = heapFragmentWalker.getHeapFragment().getJavaClassByName(urls);
            if (c != null) {
                heapFragmentWalker.getClassesController().showClass(c);
            } else {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_CLASS_MSG, urls));
            }
        }
    }

    public void computeBiggestObjects(final int number) {
        BrowserUtils.performTask(new Runnable(){

            @Override
            public void run() {
                int retainedSizesState = HintsController.this.getSummaryController().getHeapFragmentWalker().computeRetainedSizes(false);
                final String result = retainedSizesState == 3 ? HintsController.this.findBiggestObjects(number) : NO_DATA_MSG;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((HintsControllerUI)((Object)HintsController.this.getPanel())).setResult(result);
                    }
                });
            }
        });
    }

    private String findBiggestObjects(int number) {
        Heap heap = this.getSummaryController().getHeapFragmentWalker().getHeapFragment();
        List bigObjects = heap.getBiggestObjectsByRetainedSize(number);
        StringBuffer output = new StringBuffer();
        JavaClass java_lang_Class = heap.getJavaClassByName(Class.class.getName());
        NumberFormat formatter = NumberFormat.getInstance();
        boolean[] oddRow = new boolean[1];
        Color oddRowBackground = UIUtils.getDarker((Color)UIUtils.getProfilerResultsBackground());
        String oddRowBackgroundString = "rgb(" + oddRowBackground.getRed() + "," + oddRowBackground.getGreen() + "," + oddRowBackground.getBlue() + ")";
        output.append("<table border='0' width='100%'>");
        output.append("<tr style='background-color:");
        output.append(oddRowBackgroundString + ";'>");
        this.addHeading(output, CLASS_NAME_MSG);
        this.addHeading(output, RETAINED_SIZE_MSG);
        output.append("</tr>");
        for (Instance in : bigObjects) {
            output.append(oddRow[0] ? "<tr style='background-color: " + oddRowBackgroundString + ";'>" : "<tr>");
            if (in.getJavaClass().equals(java_lang_Class)) {
                JavaClass javaClass = heap.getJavaClassByID(in.getInstanceId());
                this.addCell(output, this.printClass(javaClass), false);
            } else {
                this.addCell(output, this.printInstance(in), false);
            }
            this.addCell(output, formatter.format(in.getRetainedSize()), true);
            output.append("</tr>");
            oddRow[0] = !oddRow[0];
        }
        output.append("</table>");
        return output.toString();
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((HintsControllerUI)((Object)this.getPanel())).getPresenter();
    }

    private void addHeading(StringBuffer output, String text) {
        this.addTag(output, text, "th", false);
    }

    private void addCell(StringBuffer output, String text, boolean ralign) {
        this.addTag(output, text, "td", ralign);
    }

    private void addTag(StringBuffer output, String text, String tag, boolean ralign) {
        output.append("<" + tag + (ralign ? " style='text-align: right;'>" : ">"));
        output.append(text);
        output.append("</" + tag + ">");
    }

    private String printInstance(Instance in) {
        String className = in.getJavaClass().getName();
        return "<a href='file://instance/" + className + "/" + in.getInstanceNumber() + "'>" + className + '#' + in.getInstanceNumber() + "</a>";
    }

    private String printClass(JavaClass jcls) {
        String className = jcls.getName();
        return "<a href='file://class/" + className + "'>class " + className + "</a>";
    }

    @Override
    protected JPanel createControllerUI() {
        return new HintsControllerUI(this);
    }
}

