/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.palette;

import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.microedition.m2g.SVGImage;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.export.AnimationRasterizer;
import org.netbeans.modules.mobility.svgcore.util.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public final class SVGPaletteItemData {
    private static final String PROP_NAME = "name";
    private static final String PROP_DISPLAY_NAME = "displayName";
    private static final String PROP_FOLDER_NAME = "folderName";
    private static final String PROP_FILE = "file";
    private final Properties m_props = new Properties();
    private Image m_icon32 = null;
    private static final Map<String, SVGPaletteItemData> s_pool = new HashMap<String, SVGPaletteItemData>(10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SVGPaletteItemData get(FileObject fo) throws FileNotFoundException, IOException {
        String key = fo.getPath();
        SVGPaletteItemData data = s_pool.get(key);
        if (data == null) {
            InputStream in = fo.getInputStream();
            try {
                data = new SVGPaletteItemData(in);
            }
            finally {
                in.close();
            }
            s_pool.put(key, data);
        }
        return data;
    }

    public static synchronized void set(String path, SVGPaletteItemData data) {
        s_pool.put(path, data);
    }

    private SVGPaletteItemData(InputStream in) throws IOException {
        this.m_props.loadFromXML(in);
    }

    public SVGPaletteItemData(String name, String folderName, String filePath) {
        this.m_props.put(PROP_NAME, name);
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        this.m_props.put(PROP_DISPLAY_NAME, name);
        this.m_props.put(PROP_FILE, filePath);
        this.m_props.put(PROP_FOLDER_NAME, folderName);
    }

    public String getName() {
        return this.m_props.getProperty(PROP_NAME);
    }

    public String getDisplayName() {
        return this.m_props.getProperty(PROP_DISPLAY_NAME);
    }

    public String getFilePath() {
        return this.m_props.getProperty(PROP_FILE);
    }

    public String getFolderName() {
        return this.m_props.getProperty(PROP_FOLDER_NAME);
    }

    public void serialize(OutputStream out) throws IOException {
        this.m_props.storeToXML(out, "");
    }

    public synchronized Image getIcon32() {
        if (this.m_icon32 == null) {
            SceneManager.log(Level.INFO, "Obtaining icon for " + this.getFilePath());
            try {
                FileObject thumbFO;
                String folderName = this.getFolderName();
                FileObject thumbsFolder = FileUtil.getConfigFile((String)"SVGPalette/ThumbnailImages");
                FileObject fo = thumbsFolder.getFileObject(folderName);
                if (fo != null) {
                    thumbsFolder = fo;
                    thumbFO = thumbsFolder.getFileObject(this.getDisplayName(), "png");
                } else {
                    thumbsFolder = thumbsFolder.createFolder(folderName);
                    thumbFO = null;
                }
                if (thumbFO == null) {
                    SceneManager.log(Level.INFO, "Constructing icon...");
                    File svgFile = new File(this.getFilePath());
                    if (svgFile.exists() && svgFile.isFile()) {
                        FileObject svgFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)svgFile));
                        DataObject dObj = DataObject.find((FileObject)svgFO);
                        if (dObj != null && dObj instanceof SVGDataObject) {
                            thumbFO = SVGPaletteItemData.createThumb((SVGDataObject)dObj, thumbsFolder);
                            SceneManager.log(Level.INFO, "Icon constructed.");
                        } else {
                            SceneManager.log(Level.SEVERE, "File " + svgFO.getPath() + " is not valid SVG file.");
                        }
                    } else {
                        SceneManager.log(Level.SEVERE, "File " + svgFile.getPath() + " not found");
                    }
                }
                if (thumbFO != null) {
                    this.m_icon32 = ImageIO.read(thumbFO.getInputStream());
                }
            }
            catch (Exception e) {
                SceneManager.error("Could not load icon", e);
            }
        }
        return this.m_icon32;
    }

    private static FileObject createThumb(final SVGDataObject dObj, FileObject parent) throws IOException {
        FileObject thumbFO = null;
        try {
            thumbFO = AnimationRasterizer.export(dObj, new AnimationRasterizer.Params(){

                @Override
                public SVGImage getSVGImage() throws IOException, BadLocationException {
                    return Util.createSVGImage(dObj.getPrimaryFile(), false);
                }

                @Override
                public int getImageWidth() {
                    return 32;
                }

                @Override
                public int getImageHeight() {
                    return 32;
                }

                @Override
                public float getStartTime() {
                    return 0.0f;
                }

                @Override
                public float getEndTime() {
                    return 0.0f;
                }

                @Override
                public float getFramesPerSecond() {
                    return 0.0f;
                }

                @Override
                public boolean isForAllConfigurations() {
                    return false;
                }

                @Override
                public double getRatio() {
                    return 1.0;
                }

                @Override
                public float getCompressionQuality() {
                    return 100.0f;
                }

                @Override
                public boolean isProgressive() {
                    return false;
                }

                @Override
                public boolean isInSingleImage() {
                    return true;
                }

                @Override
                public boolean isTransparent() {
                    return true;
                }

                @Override
                public AnimationRasterizer.ImageType getImageType() {
                    return AnimationRasterizer.ImageType.PNG24;
                }

                @Override
                public void setImageWidth(int w) {
                }

                @Override
                public void setImageHeight(int h) {
                }

                @Override
                public int getNumberFrames() {
                    return 1;
                }

                @Override
                public J2MEProject getProject() {
                    return null;
                }

                @Override
                public String getElementId() {
                    return null;
                }

                @Override
                public AnimationRasterizer.ColorReductionMethod getColorReductionMethod() {
                    return null;
                }
            }, parent);
            assert (thumbFO != null) : "Null thumbnail image file";
        }
        catch (MissingResourceException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return thumbFO;
    }
}

