/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.model;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.editor.BaseDocument;

public class EncodingInputStream
extends InputStream {
    private final CharBuffer m_chars;
    private CharsetEncoder m_encoder = null;
    private final ByteBuffer m_buffer;
    private static final Map ENCODING_MAPPING = new HashMap();

    public EncodingInputStream(StringBuilder sb, String encoding) {
        this(CharBuffer.wrap(sb), encoding);
    }

    public EncodingInputStream(BaseDocument doc, String encoding) {
        this((CharSequence)doc.getProperty(CharSequence.class), encoding);
    }

    public EncodingInputStream(CharSequence chars, String encoding) {
        this(CharBuffer.wrap(chars), encoding);
    }

    public EncodingInputStream(CharBuffer chars, String encoding) {
        Charset charset;
        this.m_chars = chars;
        if (encoding == null) {
            charset = Charset.defaultCharset();
        } else {
            if (!Charset.isSupported(encoding)) {
                encoding = (String)ENCODING_MAPPING.get(encoding.toLowerCase());
            }
            charset = Charset.forName(encoding);
        }
        this.m_encoder = charset.newEncoder();
        this.m_buffer = ByteBuffer.allocate(16384);
        this.m_buffer.limit(0);
    }

    @Override
    public int read() throws IOException {
        int b;
        if (this.m_buffer.remaining() <= 0) {
            if (this.m_chars.remaining() > 0) {
                this.m_buffer.clear();
                CoderResult result = this.m_encoder.encode(this.m_chars, this.m_buffer, true);
                if (result.isError()) {
                    throw new IOException(result.toString());
                }
                this.m_buffer.flip();
            }
            if (this.m_buffer.remaining() <= 0) {
                return -1;
            }
        }
        return (b = this.m_buffer.get()) >= 0 ? b : b + 256;
    }

    static {
        ENCODING_MAPPING.put("unicodelittleunmarked", "UTF-16");
        ENCODING_MAPPING.put("unicodebigunmarked", "UTF-16");
        ENCODING_MAPPING.put("unicode", "UTF-16");
        ENCODING_MAPPING.put("utf8", "UTF-8");
        ENCODING_MAPPING.put("unicodebig", "UTF-16BE");
        ENCODING_MAPPING.put("unicodelittle", "UTF-16LE");
    }
}

