/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.items.form;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteItemDataObject;
import org.openide.text.ActiveEditorDrop;

public abstract class SVGComponentDrop
implements ActiveEditorDrop {
    protected static final String PATTERN = "%%";
    private static final String X_COORDINATE_PATTERN = "%%COORDINATE_X%%";
    private static final String Y_COORDINATE_PATTERN = "%%COORDINATE_Y%%";
    private SVGDataObject mySvgDataObject;
    private float[] myPoint;

    protected abstract boolean doTransfer(SVGDataObject var1);

    protected abstract boolean doTransfer(JTextComponent var1);

    public static SVGComponentDrop getDefault(String snippet) {
        return new Default(snippet);
    }

    protected static String loadSnippetString(Class clazz, String relatedSnippetPath) throws IOException {
        String line;
        InputStream is = clazz.getResourceAsStream(relatedSnippetPath);
        assert (is != null) : relatedSnippetPath + " resource Input Stream is null";
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        StringBuffer buffer = new StringBuffer();
        while ((line = in.readLine()) != null) {
            buffer.append(line);
        }
        return buffer.toString();
    }

    protected static void insertToTextComponent(String text, JTextComponent target) {
        SVGPaletteItemDataObject.insertToTextComponent(text, target);
    }

    public boolean handleTransfer(SVGDataObject svgDataObject, float[] point) {
        if (svgDataObject == null) {
            SceneManager.log(Level.INFO, "SVGDataObject not found.");
            return false;
        }
        this.mySvgDataObject = svgDataObject;
        this.myPoint = point;
        return this.doTransfer(svgDataObject);
    }

    public boolean handleTransfer(JTextComponent target) {
        this.myPoint = new float[]{0.0f, 0.0f};
        return this.doTransfer(target);
    }

    protected float[] getDropPoint() {
        return this.myPoint;
    }

    protected void setSelection(String id) {
        if (this.mySvgDataObject != null) {
            this.mySvgDataObject.getSceneManager().setSelection(id, true);
        }
    }

    protected String replaceCoordinates(String text) {
        return text.replace(X_COORDINATE_PATTERN, String.valueOf(this.myPoint[0])).replace(Y_COORDINATE_PATTERN, String.valueOf(this.myPoint[1]));
    }

    private static class Default
    extends SVGComponentDrop {
        private String mySnippet;

        public Default(String snippet) {
            this.mySnippet = snippet;
        }

        @Override
        protected boolean doTransfer(SVGDataObject svgDataObject) {
            try {
                if (this.mySnippet != null) {
                    String text = this.replaceCoordinates(this.mySnippet);
                    String id = svgDataObject.getModel().mergeImage(text, false);
                    this.setSelection(id);
                }
                return true;
            }
            catch (Exception ex) {
                SceneManager.error("Error during image merge", ex);
                return false;
            }
        }

        @Override
        protected boolean doTransfer(JTextComponent target) {
            if (this.mySnippet != null) {
                String text = this.replaceCoordinates(this.mySnippet);
                Default.insertToTextComponent(text, target);
            }
            return true;
        }
    }
}

