/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.ActionMouseCursor;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.openide.util.ImageUtilities;

public final class SkewActionFactory
extends AbstractComposerActionFactory {
    private static final ActionMouseCursor SKEW_MOUSE_CURSOR = new ActionMouseCursor(Toolkit.getDefaultToolkit().createCustomCursor(ImageUtilities.loadImage((String)"org/netbeans/modules/mobility/svgcore/resources/skew_cursor.png"), new Point(8, 8), "skewCursor"), 3);

    public SkewActionFactory(SceneManager sceneMgr) {
        super(sceneMgr);
    }

    @Override
    public synchronized ComposerAction startAction(AWTEvent e, boolean isOutsideEvent) {
        MouseEvent me;
        SVGObject selObj;
        if (!isOutsideEvent && !this.m_sceneMgr.isReadOnly() && e.getID() == 501 && (selObj = this.getObjectToSkewAt(me = (MouseEvent)e)) != null) {
            return new SkewAction(selObj, me);
        }
        return null;
    }

    @Override
    public ActionMouseCursor getMouseCursor(MouseEvent evt, boolean isOutsideEvent) {
        if (!isOutsideEvent && this.getObjectToSkewAt(evt) != null) {
            return SKEW_MOUSE_CURSOR;
        }
        return null;
    }

    private SVGObject getObjectToSkewAt(MouseEvent me) {
        SVGObject selObj;
        SVGObject[] selectedObjects = this.m_sceneMgr.getSelected();
        if (selectedObjects != null && selectedObjects.length > 0 && (selObj = selectedObjects[0]).getOutline().isAtSkewHandlePoint(me.getX(), me.getY())) {
            return selObj;
        }
        return null;
    }

    private final class SkewAction
    extends AbstractComposerAction {
        private final SVGObject m_skewed;
        private final int m_initialX;
        private final int m_initialY;

        public SkewAction(SVGObject skewed, MouseEvent me) {
            super(SkewActionFactory.this);
            this.m_skewed = skewed;
            this.m_initialX = me.getX();
            this.m_initialY = me.getY();
        }

        @Override
        public boolean consumeEvent(AWTEvent evt, boolean isOutsideEvent) {
            if (!isOutsideEvent && evt.getID() == 506) {
                double a;
                int diff;
                MouseEvent me = (MouseEvent)evt;
                Rectangle bBox = this.m_skewed.getScreenBBox();
                float skewX = 0.0f;
                float skewY = 0.0f;
                if (bBox.height > 0 && (diff = me.getX() - this.m_initialX) != 0) {
                    a = Math.atan((double)diff / (double)bBox.height);
                    skewX = (float)Math.toDegrees(a);
                }
                if (bBox.width > 0 && (diff = this.m_initialY - me.getY()) != 0) {
                    a = Math.atan((double)diff / (double)bBox.width);
                    skewY = (float)Math.toDegrees(a);
                }
                this.m_skewed.skew(skewX, skewY);
                bBox.add(this.m_skewed.getScreenBBox());
                this.m_factory.getSceneManager().getScreenManager().repaint(bBox, 5);
            } else if (evt.getID() == 502) {
                this.actionCompleted();
                this.m_skewed.commitChanges();
            }
            return false;
        }

        @Override
        public ActionMouseCursor getMouseCursor(boolean isOutsideEvent) {
            return isOutsideEvent ? null : SKEW_MOUSE_CURSOR;
        }

        @Override
        public void actionCompleted() {
            this.m_skewed.repaint(5);
            this.m_skewed.applyTextChanges();
            this.m_skewed.commitChanges();
            if (this.getScreenManager().getShowAllArea()) {
                this.getScreenManager().refresh();
            }
            super.actionCompleted();
        }
    }
}

