/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.ActionMouseCursor;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.ComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.composer.actions.ScaleActionFactory;

public final class ScaleXActionFactory
extends ScaleActionFactory {
    private static final ActionMouseCursor SCALE_E_MOUSE_CURSOR = new ActionMouseCursor(11, 2);
    private static final ActionMouseCursor SCALE_W_MOUSE_CURSOR = new ActionMouseCursor(10, 2);

    public ScaleXActionFactory(SceneManager sceneMgr) {
        super(sceneMgr);
    }

    @Override
    public synchronized ComposerAction startAction(AWTEvent e, boolean isOutsideEvent) {
        MouseEvent me;
        SVGObject selObj;
        if (!isOutsideEvent && !this.m_sceneMgr.isReadOnly() && e.getID() == 501 && (selObj = this.getObjectToScaleAt(me = (MouseEvent)e)) != null) {
            return new ScaleXAction(this, selObj, me);
        }
        return null;
    }

    @Override
    public ActionMouseCursor getMouseCursor(MouseEvent evt, boolean isOutsideEvent) {
        SVGObject selObj = this.getSelectedObject();
        if (!isOutsideEvent && selObj != null) {
            if (this.isEScalePoint(selObj, evt)) {
                return SCALE_E_MOUSE_CURSOR;
            }
            if (this.isWScalePoint(selObj, evt)) {
                return SCALE_W_MOUSE_CURSOR;
            }
        }
        return null;
    }

    private SVGObject getObjectToScaleAt(MouseEvent me) {
        SVGObject selObj = this.getSelectedObject();
        if (selObj != null && (this.isEScalePoint(selObj, me) || this.isWScalePoint(selObj, me))) {
            return selObj;
        }
        return null;
    }

    private boolean isEScalePoint(SVGObject selObj, MouseEvent me) {
        return selObj.getOutline().isAtScaleEHandlePoint(me.getX(), me.getY());
    }

    private boolean isWScalePoint(SVGObject selObj, MouseEvent me) {
        return selObj.getOutline().isAtScaleWHandlePoint(me.getX(), me.getY());
    }

    private static class ScaleXAction
    extends ScaleActionFactory.ScaleAction {
        public ScaleXAction(ComposerActionFactory factory, SVGObject selected, MouseEvent me) {
            super(factory, selected, me);
        }

        @Override
        public boolean consumeEvent(AWTEvent evt, boolean isOutsideEvent) {
            if (!isOutsideEvent && evt.getID() == 506) {
                MouseEvent me = (MouseEvent)evt;
                Rectangle bBox = this.m_scaled.getScreenBBox();
                this.m_scaled.scale(this.calculateScaleX(me.getX()), 1.0f, this.m_scalePtIdx);
                bBox.add(this.m_scaled.getScreenBBox());
                this.m_factory.getSceneManager().getScreenManager().repaint(bBox, 5);
            } else if (evt.getID() == 502) {
                this.actionCompleted();
                this.m_scaled.commitChanges();
            }
            return false;
        }

        @Override
        public ActionMouseCursor getMouseCursor(boolean isOutsideEvent) {
            return isOutsideEvent ? null : SCALE_E_MOUSE_CURSOR;
        }
    }
}

