/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer;

import com.sun.perseus.j2d.Transform;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.netbeans.modules.mobility.svgcore.composer.GraphicUtils;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.w3c.dom.svg.SVGRect;

public final class SVGObjectOutline {
    private static final int ROUND_CORNER_SIZE = 3;
    private static final int DIAMOND_CORNER_SIZE = 3;
    public static final int SELECTOR_OVERLAP = 5;
    private static final float HANDLE_DIST = 30.0f;
    public static final Color SELECTOR_BODY = Color.RED;
    private static final Color SELECTOR_OUTLINE = Color.WHITE;
    private static final Color COLOR_HIGHLIGHT = new Color(0, 0, 0, 64);
    private static final int RESIZE_NW_CORNER_INDEX = 0;
    private static final int ROTATE_CORNER_INDEX = 1;
    private static final int RESIZE_SE_CORNER_INDEX = 2;
    private static final int SKEW_CORNER_INDEX = 3;
    private final SVGObject m_svgObject;
    private final float[][] m_coords = new float[4][2];
    private short m_tickerCopy;

    public SVGObjectOutline(SVGObject svgObject) {
        assert (svgObject != null) : "The SVGObject reference cannot be null";
        this.m_svgObject = svgObject;
        this.setDirty();
    }

    public float[][] getCoords() {
        this.checkObject();
        return this.m_coords;
    }

    public void setDirty() {
        this.m_tickerCopy = (short)-1;
    }

    public static void drawOutline(Graphics g, int xOff, int yOff, float[][] coords) {
        for (int i = 0; i < 4; ++i) {
            int j = (i + 1) % 4;
            g.drawLine(Math.round(coords[i][0]) + xOff, Math.round(coords[i][1]) + yOff, Math.round(coords[j][0]) + xOff, Math.round(coords[j][1]) + yOff);
        }
    }

    public void draw(Graphics g, int xOff, int yOff, Color color, boolean drawCorners) {
        this.checkObject();
        g.setColor(color);
        SVGObjectOutline.drawOutline(g, xOff, yOff, this.m_coords);
        if (drawCorners) {
            for (int i = 0; i < 4; ++i) {
                if (i == 1) {
                    GraphicUtils.drawRoundSelectorCorner(g, SELECTOR_OUTLINE, SELECTOR_BODY, (int)this.m_coords[i][0] + xOff, (int)this.m_coords[i][1] + yOff, 3);
                    continue;
                }
                if (i == 3) {
                    GraphicUtils.drawDiamondSelectorCorner(g, SELECTOR_OUTLINE, SELECTOR_BODY, (int)this.m_coords[i][0] + xOff, (int)this.m_coords[i][1] + yOff, 3);
                    continue;
                }
                SVGObjectOutline.drawRectSelectorCorner(g, (int)this.m_coords[i][0] + xOff, (int)this.m_coords[i][1] + yOff);
            }
        }
    }

    public void highlight(Graphics g, int xOff, int yOff, Color color) {
        this.checkObject();
        g.setColor(color);
        int[] xPoints = new int[4];
        int[] yPoints = new int[4];
        for (int i = 0; i < 4; ++i) {
            xPoints[i] = Math.round((float)xOff + this.m_coords[i][0]);
            yPoints[i] = Math.round((float)yOff + this.m_coords[i][1]);
        }
        g.fillPolygon(xPoints, yPoints, 4);
    }

    public void highlight(Graphics g, int xOff, int yOff) {
        this.highlight(g, xOff, yOff, COLOR_HIGHLIGHT);
    }

    public static Rectangle getShapeBoundingBox(float[][] points) {
        float max_y;
        float max_x;
        float min_x = max_x = points[0][0];
        float min_y = max_y = points[0][1];
        for (int i = 1; i < points.length; ++i) {
            float x = points[i][0];
            float y = points[i][1];
            if (x < min_x) {
                min_x = x;
            } else if (x > max_x) {
                max_x = x;
            }
            if (y < min_y) {
                min_y = y;
                continue;
            }
            if (!(y > max_y)) continue;
            max_y = y;
        }
        return new Rectangle(Math.round(min_x), Math.round(min_y), Math.round(max_x - min_x), Math.round(max_y - min_y));
    }

    public Rectangle getScreenBoundingBox() {
        this.checkObject();
        return SVGObjectOutline.getShapeBoundingBox(this.m_coords);
    }

    public float[] getRotatePivotPoint() {
        return this.getCenter();
    }

    public float[] getScalePivotPoint(float x, float y) {
        if (this.isAtScaleSEHandlePoint(x, y) || this.isAtScaleEHandlePoint(x, y) || this.isAtScaleSHandlePoint(x, y)) {
            return this.m_coords[0];
        }
        return this.m_coords[2];
    }

    public float[] getCenter() {
        this.checkObject();
        float sx = 0.0f;
        float sy = 0.0f;
        for (int i = 0; i < this.m_coords.length; ++i) {
            sx += this.m_coords[i][0];
            sy += this.m_coords[i][1];
        }
        return new float[]{sx / 4.0f, sy / 4.0f};
    }

    public boolean isAtRotateHandlePoint(float x, float y) {
        this.checkObject();
        float[] pt = this.m_coords[1];
        return GraphicUtils.areNear(x, y, pt[0], pt[1], 30.0f);
    }

    public boolean isAtScaleNWHandlePoint(float x, float y) {
        this.checkObject();
        float[] pt = this.m_coords[0];
        return GraphicUtils.areNear(x, y, pt[0], pt[1], 30.0f);
    }

    public boolean isAtScaleSEHandlePoint(float x, float y) {
        this.checkObject();
        float[] pt = this.m_coords[2];
        return GraphicUtils.areNear(x, y, pt[0], pt[1], 30.0f);
    }

    public boolean isAtScaleEHandlePoint(float x, float y) {
        this.checkObject();
        return GraphicUtils.isNearLine(x, y, this.m_coords[1][0], this.m_coords[1][1], this.m_coords[2][0], this.m_coords[2][1], 30.0f);
    }

    public boolean isAtScaleWHandlePoint(float x, float y) {
        this.checkObject();
        return GraphicUtils.isNearLine(x, y, this.m_coords[3][0], this.m_coords[3][1], this.m_coords[0][0], this.m_coords[0][1], 30.0f);
    }

    public boolean isAtScaleNHandlePoint(float x, float y) {
        this.checkObject();
        return GraphicUtils.isNearLine(x, y, this.m_coords[0][0], this.m_coords[0][1], this.m_coords[1][0], this.m_coords[1][1], 30.0f);
    }

    public boolean isAtScaleSHandlePoint(float x, float y) {
        this.checkObject();
        return GraphicUtils.isNearLine(x, y, this.m_coords[2][0], this.m_coords[2][1], this.m_coords[3][0], this.m_coords[3][1], 30.0f);
    }

    public boolean isAtSkewHandlePoint(float x, float y) {
        this.checkObject();
        float[] pt = this.m_coords[3];
        return GraphicUtils.areNear(x, y, pt[0], pt[1], 30.0f);
    }

    private static void drawRectSelectorCorner(Graphics g, int x, int y) {
        g.setColor(SELECTOR_BODY);
        g.fillRect(x - 2, y - 2, 5, 5);
        g.setColor(SELECTOR_OUTLINE);
        g.drawRect(x - 3, y - 3, 6, 6);
    }

    private synchronized void checkObject() {
        assert (this.m_svgObject != null) : "SVGObject reference cannot be null";
        short ticker = this.m_svgObject.getScreenManager().getChangeTicker();
        if (ticker != this.m_tickerCopy) {
            SVGObjectOutline.transformRectangle(this.m_svgObject.getSafeBBox(), (Transform)this.m_svgObject.getSVGElement().getScreenCTM(), this.m_coords);
            this.m_tickerCopy = ticker;
        }
    }

    public static float[][] transformRectangle(SVGRect rect, Transform txf, float[][] coords) {
        float x = rect.getX();
        float y = rect.getY();
        float w = rect.getWidth();
        float h = rect.getHeight();
        float[][] points = new float[][]{{x, y}, {x + w, y}, {x + w, y + h}, {x, y + h}};
        assert (coords.length == 4);
        for (int i = 0; i < 4; ++i) {
            txf.transformPoint(points[i], coords[i]);
        }
        return coords;
    }
}

