/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.mobility.end2end.E2EDataObject;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.end2end.ui.wizard.ClientOptionsPanel;
import org.netbeans.modules.mobility.end2end.ui.wizard.ServiceSelectionPanel;
import org.netbeans.modules.mobility.end2end.ui.wizard.WebApplicationPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class GenericServiceIterator
implements TemplateWizard.Iterator,
ChangeListener {
    public static final String PROP_CONFIGURATION = "e2e-configuration";
    public static final String PROP_SERVER_PROJECT = "server-project";
    static String PROP_CLIENT_ROOT = "client-root";
    static String PROP_DATABINDING = "DataBinding";
    protected static GenericServiceIterator instance;
    private static final int STEPS_COUNT = 3;
    private int currentStep;
    private boolean isWebService = false;
    private WebApplicationPanel.WebApplicationPanelWizard webapplicationPanel;
    private ServiceSelectionPanel serviceSelectionPanel;
    private ClientOptionsPanel clientOptionsPanel;
    static String firstStep;
    static String clientTypeStep;
    static String serviceSelectionStep;
    static String clientOptionsStep;
    static String operationSelectionStep;
    private final String[] stepsMethodCall = new String[]{firstStep, clientTypeStep, serviceSelectionStep, clientOptionsStep};
    private final String[] stepsWebService = new String[]{firstStep, clientTypeStep, operationSelectionStep, clientOptionsStep};
    private static final int INDEX_SERVICES = 2;
    private final transient Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    private String[] getSteps() {
        return !this.isWebService ? this.stepsMethodCall : this.stepsWebService;
    }

    static Object create() {
        return new GenericServiceIterator();
    }

    public void initialize(TemplateWizard templateWizard) {
        Configuration configuration = new Configuration();
        templateWizard.putProperty(PROP_CONFIGURATION, (Object)configuration);
        this.webapplicationPanel = WebApplicationPanel.create();
        this.webapplicationPanel.addChangeListener(this);
        this.serviceSelectionPanel = new ServiceSelectionPanel();
        this.serviceSelectionPanel.getComponent().setName(this.getSteps()[2]);
        this.clientOptionsPanel = new ClientOptionsPanel();
        this.currentStep = 0;
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.webapplicationPanel.removeChangeListener(this);
        this.webapplicationPanel = null;
        this.serviceSelectionPanel = null;
        this.clientOptionsPanel = null;
        this.currentStep = -1;
    }

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        Configuration configuration = (Configuration)templateWizard.getProperty(PROP_CONFIGURATION);
        String string = configuration.getClientConfiguration().getClassDescriptor().getPackageName();
        string = string.replace('.', '/');
        FileObject fileObject = (FileObject)templateWizard.getProperty(PROP_CLIENT_ROOT);
        if (string.length() != 0) {
            fileObject = FileUtil.createFolder((FileObject)fileObject, (String)string);
        }
        FileObject fileObject2 = FileUtil.getConfigFile((String)"Templates/MIDP/E2EWebApplication.wsclient");
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        E2EDataObject e2EDataObject = (E2EDataObject)dataObject.createFromTemplate((DataFolder)DataObject.find((FileObject)fileObject), configuration.getClientConfiguration().getClassDescriptor().getLeafClassName());
        FileObject fileObject3 = e2EDataObject.getPrimaryFile();
        Project project = (Project)templateWizard.getProperty(PROP_SERVER_PROJECT);
        FileObject fileObject4 = project.getProjectDirectory();
        String string2 = CollocationQuery.areCollocated((File)FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)fileObject3)), (File)FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)fileObject4))) ? FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject4) : FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)fileObject4)).getAbsolutePath();
        configuration.getServerConfigutation().setProjectPath(string2);
        e2EDataObject.setConfiguration(configuration);
        e2EDataObject.generate();
        HashSet<DataObject> hashSet = new HashSet<DataObject>();
        hashSet.add((DataObject)e2EDataObject);
        return hashSet;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.currentStep;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentStep;
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public boolean hasPrevious() {
        return this.currentStep > 0;
    }

    public boolean hasNext() {
        return this.currentStep < 2;
    }

    public WizardDescriptor.Panel current() {
        WizardDescriptor.Panel panel = null;
        switch (this.currentStep) {
            case 0: {
                panel = this.webapplicationPanel;
                break;
            }
            case 1: {
                panel = this.serviceSelectionPanel;
                break;
            }
            case 2: {
                panel = this.clientOptionsPanel;
            }
        }
        JPanel jPanel = null;
        jPanel = (JPanel)panel.getComponent();
        if (jPanel == null) {
            throw new IllegalStateException();
        }
        jPanel.putClientProperty("WizardPanel_contentData", this.getSteps());
        jPanel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.currentStep));
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        HashSet<ChangeListener> hashSet;
        Object object = this.listeners;
        synchronized (object) {
            hashSet = new HashSet<ChangeListener>(this.listeners);
        }
        object = new ChangeEvent(this);
        for (ChangeListener changeListener : hashSet) {
            changeListener.stateChanged((ChangeEvent)object);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource().getClass() == WebApplicationPanel.WebApplicationPanelWizard.class && this.webapplicationPanel != null) {
            this.isWebService = ((WebApplicationPanel)this.webapplicationPanel.getComponent()).isWsdl();
            if (this.serviceSelectionPanel != null) {
                this.serviceSelectionPanel.getComponent().setName(this.getSteps()[2]);
            }
        }
        this.fireChangeEvent();
    }

    public static synchronized GenericServiceIterator singleton() {
        if (instance == null) {
            instance = new GenericServiceIterator();
        }
        return instance;
    }

    static {
        firstStep = NbBundle.getMessage(GenericServiceIterator.class, (String)"TITLE_firstStep");
        clientTypeStep = NbBundle.getMessage(GenericServiceIterator.class, (String)"TITLE_clientTypeStep");
        serviceSelectionStep = NbBundle.getMessage(GenericServiceIterator.class, (String)"TITLE_serviceSelectionStep");
        clientOptionsStep = NbBundle.getMessage(GenericServiceIterator.class, (String)"TITLE_clientOptionsStep");
        operationSelectionStep = NbBundle.getMessage(GenericServiceIterator.class, (String)"TITLE_operationSelectionStep");
    }
}

