/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.mapping;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.e2e.classdata.FieldData;
import org.netbeans.modules.mobility.javon.JavonMapping;
import org.netbeans.modules.mobility.javon.JavonSerializer;
import org.netbeans.modules.mobility.javon.Traversable;

public class BeanTypeSerializer
implements JavonSerializer {
    private Map<String, ClassData> beanTypes = new HashMap<String, ClassData>();
    private static final Set<String> UNSUPPORTED_PACKAGES = new HashSet<String>(Arrays.asList("javax", "java"));

    @Override
    public String getName() {
        return "Bean type serializer";
    }

    @Override
    public boolean isTypeSupported(Traversable traversable, TypeMirror typeMirror, Map<String, ClassData> map) {
        if (TypeKind.ARRAY == typeMirror.getKind()) {
            return false;
        }
        if (TypeKind.DECLARED == typeMirror.getKind()) {
            TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            String string = typeElement.getSimpleName().toString();
            String string2 = typeElement.getQualifiedName().toString();
            if ("java.lang.Object".equals(string2)) {
                return false;
            }
            if (string2.startsWith("java.util")) {
                return false;
            }
            String string3 = "";
            if (string.length() != string2.length()) {
                int n = string2.length();
                int n2 = string.length();
                string3 = string2.substring(n - n2 - 1);
            }
            if (typeElement.getSuperclass().getKind() != TypeKind.DECLARED) {
                return false;
            }
            TypeElement typeElement2 = (TypeElement)((DeclaredType)typeElement.getSuperclass()).asElement();
            if (!traversable.isTypeSupported(typeElement.getSuperclass(), map) && !"java.lang.Object".equals(typeElement2.getQualifiedName().toString())) {
                return false;
            }
            List<ExecutableElement> list = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
            boolean bl = false;
            for (ExecutableElement executableElement : list) {
                if (executableElement.getParameters().size() != 0 || !executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || executableElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
                bl = true;
                break;
            }
            return bl;
        }
        return false;
    }

    @Override
    public ClassData getType(Traversable traversable, TypeMirror typeMirror, Map<String, ClassData> map) {
        if (TypeKind.ARRAY == typeMirror.getKind()) {
            return null;
        }
        if (TypeKind.DECLARED == typeMirror.getKind()) {
            TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            String string = typeElement.getSimpleName().toString();
            String string2 = typeElement.getQualifiedName().toString();
            String string3 = "";
            if (string.length() != string2.length()) {
                int n = string2.length();
                int n2 = string.length();
                string3 = string2.substring(0, n - n2 - 1);
            }
            for (String string4 : UNSUPPORTED_PACKAGES) {
                if (!string3.startsWith(string4)) continue;
                return null;
            }
            if (map.get(string2) != null) {
                return map.get(string2);
            }
            Object object = this.beanTypes.get(string2);
            if (object != null) {
                return object;
            }
            object = new ClassData(string3, string, false, false, (JavonSerializer)this);
            this.beanTypes.put(string2, (ClassData)object);
            map.put(string2, (ClassData)object);
            for (VariableElement object2 : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
                if (object2.getModifiers().contains((Object)Modifier.STATIC) || object2.getModifiers().contains((Object)Modifier.FINAL)) continue;
                ClassData classData = traversable.traverseType(object2.asType(), map);
                if (classData == null) {
                    ((ClassData)object).addInvalidField(object2);
                    continue;
                }
                String string4 = object2.getSimpleName().toString().substring(0, 1).toUpperCase() + object2.getSimpleName().toString().substring(1);
                String string5 = "set" + string4;
                String string6 = (object2.asType().getKind() == TypeKind.BOOLEAN ? "is" : "get") + string4;
                FieldData fieldData = new FieldData(object2.getSimpleName().toString(), classData);
                if (object2.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    fieldData.setModifier(ClassData.Modifier.PUBLIC);
                    ((ClassData)object).addField(fieldData);
                    traversable.registerType(classData);
                    continue;
                }
                boolean bl = false;
                boolean bl2 = false;
                for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                    String string7 = executableElement.getSimpleName().toString();
                    if (string5.equals(string7)) {
                        fieldData.setSetter(string5);
                        bl = true;
                    }
                    if (!string6.equals(string7)) continue;
                    fieldData.setGetter(string6);
                    bl2 = true;
                }
                fieldData.setModifier(ClassData.Modifier.PRIVATE);
                if (!bl2 || !bl) continue;
                ((ClassData)object).addField(fieldData);
                traversable.registerType(classData);
            }
            if (typeElement.getSuperclass().getKind() == TypeKind.DECLARED) {
                TypeElement typeElement2 = (TypeElement)((DeclaredType)typeElement.getSuperclass()).asElement();
                ClassData classData = traversable.traverseType(typeElement2.asType(), map);
                if (classData != null) {
                    traversable.registerType(classData);
                    ((ClassData)object).setParent(classData);
                } else if (!"java.lang.Object".equals(typeElement2.getQualifiedName().toString())) {
                    return null;
                }
            }
            return object;
        }
        return null;
    }

    @Override
    public String instanceOf(JavonMapping javonMapping, ClassData classData) {
        if (this.beanTypes.get(classData.getFullyQualifiedName()) != null) {
            return classData.getFullyQualifiedName();
        }
        throw new IllegalArgumentException("Invalid type: " + classData.getName());
    }

    @Override
    public String toObject(JavonMapping javonMapping, ClassData classData, String string) {
        if (this.beanTypes.get(classData.getFullyQualifiedName()) != null) {
            return "(" + classData.getFullyQualifiedName() + ")" + (string == null ? "" : string);
        }
        throw new IllegalArgumentException("Invalid type: " + classData.getName());
    }

    @Override
    public String fromObject(JavonMapping javonMapping, ClassData classData, String string) {
        if (this.beanTypes.get(classData.getFullyQualifiedName()) != null) {
            return "(" + classData.getFullyQualifiedName() + ")" + string;
        }
        throw new IllegalArgumentException("Invalid type: " + classData.getName());
    }

    @Override
    public String toStream(JavonMapping javonMapping, ClassData classData, String string, String string2) {
        if (this.beanTypes.get(classData.getFullyQualifiedName()) != null) {
            String string3 = "";
            String string4 = "b_" + classData.getFullyQualifiedName().replace(".", "_");
            string3 = string3 + classData.getFullyQualifiedName() + " " + string4 + " = (" + classData.getFullyQualifiedName() + ")" + string2 + ";\n";
            for (FieldData fieldData : classData.getAllFields()) {
                String string5 = "";
                string5 = ", " + javonMapping.getRegistry().getRegisteredTypeId(fieldData.getType());
                if (javonMapping.getProperty("target").equals("client") && javonMapping.getProperty("create-stubs").equals("true") || fieldData.getModifier() == ClassData.Modifier.PUBLIC) {
                    if (fieldData.getType().isPrimitive()) {
                        string3 = string3 + javonMapping.getRegistry().getTypeSerializer(fieldData.getType()).toStream(javonMapping, fieldData.getType(), string, string4 + "." + fieldData.getName()) + "\n";
                        continue;
                    }
                    string3 = string3 + "writeObject(" + string + ", " + string4 + "." + fieldData.getName() + string5 + ");\n";
                    continue;
                }
                if (fieldData.getType().isPrimitive()) {
                    string3 = string3 + javonMapping.getRegistry().getTypeSerializer(fieldData.getType()).toStream(javonMapping, fieldData.getType(), string, string4 + "." + this.getGetter(fieldData) + "()") + "\n";
                    continue;
                }
                string3 = string3 + "writeObject(" + string + ", " + string4 + "." + this.getGetter(fieldData) + "()" + string5 + ");\n";
            }
            return string3;
        }
        throw new IllegalArgumentException("Invalid type: " + classData.getName());
    }

    @Override
    public String fromStream(JavonMapping javonMapping, ClassData classData, String string, String string2) {
        if (this.beanTypes.get(classData.getFullyQualifiedName()) != null) {
            String string3 = "b_" + classData.getFullyQualifiedName().replace(".", "_");
            String string4 = classData.getFullyQualifiedName() + " " + string3 + " = new " + classData.getFullyQualifiedName() + "();\n";
            for (FieldData fieldData : classData.getAllFields()) {
                if (javonMapping.getProperty("target").equals("client") && javonMapping.getProperty("create-stubs").equals("true") || fieldData.getModifier() == ClassData.Modifier.PUBLIC) {
                    if (fieldData.getType().isPrimitive() && !fieldData.getType().isArray()) {
                        string4 = string4 + string3 + "." + fieldData.getName() + " = " + fieldData.getType().getSerializer().fromStream(javonMapping, fieldData.getType(), string, null) + ";\n";
                        continue;
                    }
                    string4 = string4 + string3 + "." + fieldData.getName() + " = (" + fieldData.getType().getSerializer().instanceOf(javonMapping, fieldData.getType()) + ") readObject(" + string + ");\n";
                    continue;
                }
                if (fieldData.getType().isPrimitive() && !fieldData.getType().isArray()) {
                    string4 = string4 + string3 + "." + this.getSetter(fieldData) + "(" + javonMapping.getRegistry().getTypeSerializer(fieldData.getType()).fromStream(javonMapping, fieldData.getType(), string, null) + ");\n";
                    continue;
                }
                string4 = string4 + string3 + "." + this.getSetter(fieldData) + "((" + fieldData.getType().getSerializer().instanceOf(javonMapping, fieldData.getType()) + ") readObject(" + string + "));\n";
            }
            string4 = string4 + (string2 == null ? "" : string2 + " = " + string3 + ";\n");
            return string4;
        }
        throw new IllegalArgumentException("Invalid type: " + classData.getName());
    }

    private String getSetter(FieldData fieldData) {
        return "set" + fieldData.getName().substring(0, 1).toUpperCase() + fieldData.getName().substring(1);
    }

    private String getGetter(FieldData fieldData) {
        return (!fieldData.getType().getClassName().toLowerCase().equals("boolean") ? "get" : "is") + fieldData.getName().substring(0, 1).toUpperCase() + fieldData.getName().substring(1);
    }

    @Override
    public Set<ClassData> getReferencedTypes(ClassData classData, Set<ClassData> set) {
        HashSet<ClassData> hashSet = new HashSet<ClassData>();
        hashSet.add(classData);
        set.add(classData);
        ClassData classData2 = classData.getParent();
        if (classData2 != null && classData2.getSerializer() != null && !set.contains(classData2)) {
            set.addAll(classData2.getSerializer().getReferencedTypes(classData2, set));
        }
        for (FieldData fieldData : classData.getFields()) {
            ClassData classData3 = fieldData.getType();
            if (set.contains(classData3)) continue;
            hashSet.addAll(classData3.getSerializer().getReferencedTypes(classData3, set));
            set.add(classData3);
        }
        return hashSet;
    }
}

