/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.hyperlink;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.spring.beans.editor.BeanClassFinder;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkEnv;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkProcessor;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.MatchType;
import org.netbeans.modules.spring.java.Property;
import org.netbeans.modules.spring.java.PropertyFinder;
import org.openide.util.Exceptions;

public class PropertyHyperlinkProcessor
extends HyperlinkProcessor {
    @Override
    public void process(HyperlinkEnv hyperlinkEnv) {
        try {
            final String string = new BeanClassFinder(hyperlinkEnv.getBeanAttributes(), hyperlinkEnv.getFileObject()).findImplementationClass();
            if (string == null) {
                return;
            }
            final String string2 = this.getPropertyChainUptoPosition(hyperlinkEnv);
            if (string2 == null || string2.equals("")) {
                return;
            }
            final boolean bl = StringUtils.occurs(hyperlinkEnv.getValueString(), ".", string2.length());
            JavaSource javaSource = JavaUtils.getJavaSource(hyperlinkEnv.getFileObject());
            if (javaSource == null) {
                return;
            }
            final int n = string2.lastIndexOf(".");
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    Object object;
                    Property[] propertyArray;
                    String string3;
                    if (string == null) {
                        return;
                    }
                    TypeElement typeElement = JavaUtils.findClassElementByBinaryName(string, compilationController);
                    if (typeElement == null) {
                        return;
                    }
                    TypeMirror typeMirror = typeElement.asType();
                    ElementUtilities elementUtilities = compilationController.getElementUtilities();
                    if (n != -1) {
                        string3 = string2.substring(0, n);
                        propertyArray = new StringTokenizer(string3, ".");
                        while (propertyArray.hasMoreTokens() && typeMirror != null) {
                            object = propertyArray.nextToken();
                            Property[] propertyArray2 = new PropertyFinder(typeMirror, (String)object, elementUtilities, MatchType.PREFIX).findProperties();
                            if (propertyArray2.length == 0 || propertyArray2[0].getGetter() == null) {
                                typeMirror = null;
                                break;
                            }
                            TypeMirror typeMirror2 = propertyArray2[0].getGetter().getReturnType();
                            if (typeMirror2.getKind() == TypeKind.DECLARED) {
                                typeMirror = typeMirror2;
                                continue;
                            }
                            typeMirror = null;
                        }
                    }
                    if (typeMirror == null) {
                        return;
                    }
                    string3 = string2.substring(n + 1);
                    propertyArray = new PropertyFinder(typeMirror, string3, elementUtilities, MatchType.PREFIX).findProperties();
                    if (propertyArray.length > 0) {
                        Object object2 = object = bl ? propertyArray[0].getGetter() : propertyArray[0].getSetter();
                        if (object != null) {
                            ElementOpen.open((ClasspathInfo)compilationController.getClasspathInfo(), (Element)object);
                        }
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    @Override
    public int[] getSpan(HyperlinkEnv hyperlinkEnv) {
        int n = hyperlinkEnv.getTokenStartOffset() + 1;
        String string = this.getPropertyChainUptoPosition(hyperlinkEnv);
        if (string == null || string.equals("")) {
            return null;
        }
        int n2 = hyperlinkEnv.getTokenStartOffset() + string.length() + 1;
        int n3 = string.lastIndexOf(".");
        n3 = n3 == -1 ? 0 : ++n3;
        return new int[]{n3 += n, n2};
    }

    private String getPropertyChainUptoPosition(HyperlinkEnv hyperlinkEnv) {
        int n = hyperlinkEnv.getOffset() - hyperlinkEnv.getTokenStartOffset() - 1;
        int n2 = hyperlinkEnv.getValueString().indexOf(".", n);
        if (n2 == -1) {
            return hyperlinkEnv.getValueString();
        }
        return hyperlinkEnv.getValueString().substring(0, n2);
    }
}

