/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractInvoker;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.FreedMemoryIO;
import org.jruby.ext.ffi.InvalidMemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.jffi.CallbackManager;
import org.jruby.ext.ffi.jffi.CodeMemoryIO;
import org.jruby.ext.ffi.jffi.DefaultMethodFactory;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.MethodFactory;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::Function"}, parent="FFI::Pointer")
public final class Function
extends AbstractInvoker {
    private final com.kenai.jffi.Function function;
    private final Type returnType;
    private final Type[] parameterTypes;
    private final CallingConvention convention;
    private final IRubyObject enums;
    private volatile boolean autorelease = true;

    public static RubyClass createFunctionClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder("Function", module.fastGetClass("Pointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(AbstractInvoker.class);
        result.defineAnnotatedMethods(Function.class);
        result.defineAnnotatedConstants(Function.class);
        return result;
    }

    Function(Ruby runtime2, RubyClass klass, DirectMemoryIO address2, Type returnType, Type[] parameterTypes, CallingConvention convention, IRubyObject enums) {
        super(runtime2, klass, parameterTypes.length, address2);
        com.kenai.jffi.Type jffiReturnType = FFIUtil.getFFIType(returnType);
        if (jffiReturnType == null) {
            throw runtime2.newArgumentError("Invalid return type " + returnType);
        }
        com.kenai.jffi.Type[] jffiParamTypes = new com.kenai.jffi.Type[parameterTypes.length];
        for (int i = 0; i < jffiParamTypes.length; ++i) {
            jffiParamTypes[i] = FFIUtil.getFFIType(parameterTypes[i]);
            if (jffiParamTypes[i] != null) continue;
            throw runtime2.newArgumentError("Invalid parameter type " + parameterTypes[i]);
        }
        this.function = new com.kenai.jffi.Function(address2.getAddress(), jffiReturnType, jffiParamTypes);
        this.parameterTypes = (Type[])parameterTypes.clone();
        this.returnType = returnType;
        this.convention = convention;
        this.enums = enums;
        this.getSingletonClass().addMethod("call", this.createDynamicMethod(this.getSingletonClass()));
    }

    @JRubyMethod(name={"new"}, meta=true, required=2, optional=2)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        CallingConvention callConvention;
        InvalidMemoryIO fptr = null;
        RubyHash options2 = null;
        Object proc2 = null;
        int optionsIndex = 2;
        Type returnType = FFIUtil.resolveType(context, args2[0]);
        if (!(args2[1] instanceof RubyArray)) {
            throw context.getRuntime().newTypeError("Invalid parameter array " + args2[1].getMetaClass().getName() + " (expected Array)");
        }
        RubyArray paramTypes = (RubyArray)args2[1];
        Type[] parameterTypes = new Type[paramTypes.size()];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = FFIUtil.resolveType(context, paramTypes.entry(i));
        }
        if (args2.length > 2 && args2[2] instanceof Pointer) {
            fptr = new CodeMemoryIO(context.getRuntime(), (Pointer)args2[2]);
            optionsIndex = 3;
        } else if (args2.length > 2 && (args2[2] instanceof RubyProc || args2[2].respondsTo("call"))) {
            proc2 = args2[2];
            optionsIndex = 3;
        } else if (block.isGiven()) {
            proc2 = block;
            optionsIndex = 2;
        } else {
            throw context.getRuntime().newTypeError("Invalid function address " + args2[0].getMetaClass().getName() + " (expected FFI::Pointer)");
        }
        String convention = "default";
        IRubyObject enums = null;
        if (args2.length > optionsIndex && args2[optionsIndex] instanceof RubyHash) {
            options2 = (RubyHash)args2[optionsIndex];
            IRubyObject rbConvention = options2.fastARef(context.getRuntime().newSymbol("convention"));
            if (rbConvention != null && !rbConvention.isNil()) {
                convention = rbConvention.asJavaString();
            }
            if ((enums = options2.fastARef(context.getRuntime().newSymbol("enums"))) != null && !enums.isNil() && !(enums instanceof RubyHash)) {
                throw context.getRuntime().newTypeError("wrong type for options[:enum] " + enums.getMetaClass().getName() + " (expected Hash)");
            }
        }
        CallingConvention callingConvention = callConvention = "stdcall".equals(convention) ? CallingConvention.STDCALL : CallingConvention.DEFAULT;
        if (fptr == null && proc2 != null) {
            fptr = CallbackManager.getInstance().newClosure(context.getRuntime(), returnType, parameterTypes, proc2, callConvention);
        }
        return new Function(context.getRuntime(), (RubyClass)recv2, (DirectMemoryIO)((Object)fptr), returnType, parameterTypes, callConvention, enums);
    }

    @JRubyMethod(name={"free"})
    public final IRubyObject free(ThreadContext context) {
        if (!(this.getMemoryIO() instanceof AllocatedDirectMemoryIO)) {
            throw context.getRuntime().newRuntimeError("cannot free non-allocated function");
        }
        ((AllocatedDirectMemoryIO)this.getMemoryIO()).free();
        this.setMemoryIO(new FreedMemoryIO(context.getRuntime()));
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"autorelease="}, required=1)
    public final IRubyObject autorelease(ThreadContext context, IRubyObject release) {
        if (this.autorelease != release.isTrue() && this.getMemoryIO() instanceof AllocatedDirectMemoryIO) {
            this.autorelease = release.isTrue();
            ((AllocatedDirectMemoryIO)this.getMemoryIO()).setAutoRelease(this.autorelease);
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"autorelease?", "autorelease"})
    public final IRubyObject autorelease_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.autorelease);
    }

    public DynamicMethod createDynamicMethod(RubyModule module) {
        if (this.enums == null || this.enums.isNil()) {
            return MethodFactory.createDynamicMethod(this.getRuntime(), module, this.function, this.returnType, this.parameterTypes, this.convention);
        }
        return DefaultMethodFactory.getFactory().createMethod(module, this.function, this.returnType, this.parameterTypes, this.convention, this.enums);
    }
}

