/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.jffi.BoundedNativeMemoryIO;
import org.jruby.util.ReferenceReaper;

final class AllocatedNativeMemoryIO
extends BoundedNativeMemoryIO
implements AllocatedDirectMemoryIO {
    private static final Map<MemoryHolder, Boolean> referenceSet = new ConcurrentHashMap<MemoryHolder, Boolean>();
    private final MemoryHolder holder;

    static final AllocatedNativeMemoryIO allocate(Ruby runtime2, int size2, boolean clear2) {
        return AllocatedNativeMemoryIO.allocateAligned(runtime2, size2, 1, clear2);
    }

    static final AllocatedNativeMemoryIO allocateAligned(Ruby runtime2, int size2, int align, boolean clear2) {
        long address2 = IO.allocateMemory(size2 + align - 1, clear2);
        if (address2 == 0L) {
            throw runtime2.newRuntimeError("failed to allocate " + size2 + " bytes of native memory");
        }
        try {
            return new AllocatedNativeMemoryIO(runtime2, address2, size2, align);
        }
        catch (Throwable t) {
            IO.freeMemory(address2);
            throw new RuntimeException(t);
        }
    }

    private AllocatedNativeMemoryIO(Ruby runtime2, long address2, int size2, int align) {
        super(runtime2, (address2 - 1L & (long)(~(align - 1))) + (long)align, size2);
        this.holder = new MemoryHolder(this, address2);
        referenceSet.put(this.holder, Boolean.TRUE);
    }

    public void free() {
        if (this.holder.released) {
            throw this.getRuntime().newRuntimeError("memory already freed");
        }
        this.holder.free();
        referenceSet.remove(this.holder);
    }

    public void setAutoRelease(boolean release) {
        this.holder.autorelease = release;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MemoryHolder
    extends ReferenceReaper.Phantom<AllocatedNativeMemoryIO>
    implements Runnable {
        private final long storage;
        private volatile boolean released = false;
        private volatile boolean autorelease = true;

        MemoryHolder(AllocatedNativeMemoryIO mem, long storage) {
            super(mem);
            this.storage = storage;
        }

        @Override
        public final void run() {
            referenceSet.remove(this);
            if (this.autorelease) {
                this.free();
            }
        }

        final void free() {
            if (!this.released) {
                this.released = true;
                BoundedNativeMemoryIO.IO.freeMemory(this.storage);
            }
        }
    }
}

