/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.embed.variable.BiVariable;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class ClassVariable
extends AbstractVariable {
    private static String pattern = "@@([a-zA-Z]|_)([a-zA-Z]|_|\\d)*";

    public static BiVariable getInstance(Ruby runtime2, String name2, Object ... javaObject) {
        if (name2.matches(pattern)) {
            return new ClassVariable(runtime2, name2, javaObject);
        }
        return null;
    }

    private ClassVariable(Ruby runtime2, String name2, Object ... javaObject) {
        super(runtime2, name2, javaObject);
    }

    ClassVariable(IRubyObject origin, String name2, IRubyObject irubyObject) {
        super(origin, name2, irubyObject);
    }

    public static void retrieve(Ruby runtime2, IRubyObject receiver2, BiVariableMap vars) {
        if (receiver2 == null) {
            receiver2 = runtime2.getTopSelf();
        }
        List<String> names2 = receiver2.getMetaClass().getClassVariableNameList();
        for (String name2 : names2) {
            BiVariable var;
            IRubyObject value2 = receiver2.getMetaClass().getClassVar(name2);
            if (vars.containsKey(name2)) {
                var = vars.getVariable(name2);
                var.setRubyObject(value2);
                continue;
            }
            var = new ClassVariable(receiver2, name2, value2);
            vars.update(name2, var);
        }
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.ClassVariable;
    }

    public static boolean isValidName(Object name2) {
        return ClassVariable.isValidName(pattern, name2);
    }

    public void inject(Ruby runtime2, IRubyObject receiver2) {
        if (this.origin != null && this.origin != receiver2) {
            return;
        }
        RubyModule rubyClass = this.getRubyClass(runtime2);
        rubyClass.setClassVar(this.name, this.irubyObject);
    }

    public void remove(Ruby runtime2) {
        RubyModule rubyClass = this.getRubyClass(runtime2);
        IRubyObject rubyName = JavaEmbedUtils.javaToRuby(runtime2, this.name);
        rubyClass.removeCvar(rubyName);
    }
}

